/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world;

import java.util.LinkedList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.fml.common.Mod;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.item.QuarkSpawnEggItem;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.type.CostSensitiveEntitySpawnConfig;
import vazkii.quark.base.module.config.type.EntitySpawnConfig;

@Mod.EventBusSubscriber(modid="quark")
public class EntitySpawnHandler {
    private static final List<TrackedSpawnConfig> trackedSpawnConfigs = new LinkedList<TrackedSpawnConfig>();

    public static <T extends Mob> void registerSpawn(EntityType<T> entityType, MobCategory classification, SpawnPlacements.Type placementType, Heightmap.Types heightMapType, SpawnPlacements.SpawnPredicate<T> placementPredicate, EntitySpawnConfig config) {
        SpawnPlacements.m_21754_(entityType, (SpawnPlacements.Type)placementType, (Heightmap.Types)heightMapType, placementPredicate);
        EntitySpawnHandler.track(entityType, classification, config, false);
    }

    public static <T extends Mob> void track(EntityType<T> entityType, MobCategory classification, EntitySpawnConfig config, boolean secondary) {
        trackedSpawnConfigs.add(new TrackedSpawnConfig(entityType, classification, config, secondary));
    }

    public static void addEgg(QuarkModule module, EntityType<? extends Mob> entityType, int color1, int color2, EntitySpawnConfig config) {
        EntitySpawnHandler.addEgg(entityType, color1, color2, module, config::isEnabled);
    }

    public static void addEgg(EntityType<? extends Mob> entityType, int color1, int color2, QuarkModule module, BooleanSupplier enabledSupplier) {
        new QuarkSpawnEggItem(() -> entityType, color1, color2, RegistryHelper.getInternalName(entityType) + "_spawn_egg", module, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)).setCondition(enabledSupplier);
    }

    public static void modifyBiome(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder biomeInfoBuilder) {
        MobSpawnSettingsBuilder builder = biomeInfoBuilder.getMobSpawnSettings();
        for (TrackedSpawnConfig c : trackedSpawnConfigs) {
            EntitySpawnConfig entitySpawnConfig;
            List l = builder.getSpawner(c.classification);
            if (!c.secondary) {
                l.removeIf(e -> e.f_48404_.equals(c.entityType));
            }
            if (c.config.isEnabled() && c.config.biomes.canSpawn(biome)) {
                l.add(c.entry);
            }
            if (!((entitySpawnConfig = c.config) instanceof CostSensitiveEntitySpawnConfig)) continue;
            CostSensitiveEntitySpawnConfig csc = (CostSensitiveEntitySpawnConfig)entitySpawnConfig;
            builder.m_48370_(c.entityType, csc.spawnCost, csc.maxCost);
        }
    }

    public static void refresh() {
        for (TrackedSpawnConfig c : trackedSpawnConfigs) {
            c.refresh();
        }
    }

    private static class TrackedSpawnConfig {
        final EntityType<?> entityType;
        final MobCategory classification;
        final EntitySpawnConfig config;
        final boolean secondary;
        MobSpawnSettings.SpawnerData entry;

        TrackedSpawnConfig(EntityType<?> entityType, MobCategory classification, EntitySpawnConfig config, boolean secondary) {
            this.entityType = entityType;
            this.classification = classification;
            this.config = config;
            this.secondary = secondary;
            this.refresh();
        }

        private void refresh() {
            this.entry = new MobSpawnSettings.SpawnerData(this.entityType, this.config.spawnWeight, Math.min(this.config.minGroupSize, this.config.maxGroupSize), Math.max(this.config.minGroupSize, this.config.maxGroupSize));
        }
    }
}

