/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.client.handler.BarOverlayRenderer;
import fuzs.overflowingbars.client.handler.HealthBarRenderer;
import fuzs.overflowingbars.client.helper.ChatOffsetHelper;
import fuzs.overflowingbars.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod.EventBusSubscriber(modid="overflowingbars", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class OverflowingBarsForgeClient {
    private static final IGuiOverlay TOUGHNESS_LEVEL = new IGuiOverlay(){

        public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
            ClientConfig.ToughnessRowConfig config = ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).toughness;
            if (!config.armorToughnessBar) {
                return;
            }
            Minecraft minecraft = gui.getMinecraft();
            if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                RenderSystem.m_69478_();
                BarOverlayRenderer.renderToughnessLevelBar(poseStack, screenWidth, screenHeight, minecraft, config.leftSide ? gui.leftHeight : gui.rightHeight, config.allowCount, config.leftSide, !config.allowLayers);
                RenderSystem.m_69461_();
                if (ChatOffsetHelper.toughnessRow((Player)minecraft.f_91074_)) {
                    if (config.leftSide) {
                        gui.leftHeight += 10;
                    } else {
                        gui.rightHeight += 10;
                    }
                }
            }
        }
    };

    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        OverflowingBarsForgeClient.registerHandlers();
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            ForgeGui gui;
            Minecraft minecraft;
            if (evt.getOverlay() == VanillaGuiOverlay.PLAYER_HEALTH.type() && ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.allowLayers) {
                minecraft = Minecraft.m_91087_();
                gui = (ForgeGui)minecraft.f_91065_;
                if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                    RenderSystem.m_69478_();
                    BarOverlayRenderer.renderHealthLevelBars(evt.getPoseStack(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_(), minecraft, gui.leftHeight, ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.allowCount);
                    RenderSystem.m_69461_();
                    gui.leftHeight = gui.leftHeight + (ChatOffsetHelper.twoHealthRows((Player)minecraft.f_91074_) ? 20 : 10);
                }
                evt.setCanceled(true);
            }
            if (evt.getOverlay() == VanillaGuiOverlay.ARMOR_LEVEL.type() && ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).armor.allowLayers) {
                minecraft = Minecraft.m_91087_();
                gui = (ForgeGui)minecraft.f_91065_;
                if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                    RenderSystem.m_69478_();
                    BarOverlayRenderer.renderArmorLevelBar(evt.getPoseStack(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_(), minecraft, gui.leftHeight, ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).armor.allowCount, false);
                    RenderSystem.m_69461_();
                    if (ChatOffsetHelper.armorRow((Player)minecraft.f_91074_)) {
                        gui.leftHeight += 10;
                    }
                }
                evt.setCanceled(true);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (!((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).moveChatAboveArmor) {
                return;
            }
            evt.setPosY(evt.getPosY() - (int)ChatOffsetHelper.getChatOffsetY());
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.phase == TickEvent.Phase.START) {
                HealthBarRenderer.INSTANCE.onClientTick$Start(Minecraft.m_91087_());
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterGuiOverlays(RegisterGuiOverlaysEvent evt) {
        evt.registerAbove(VanillaGuiOverlay.MOUNT_HEALTH.id(), "toughness_level", TOUGHNESS_LEVEL);
    }
}

