/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.Tooltip;
import org.thinkingstudio.obsidianui.Tooltipable;
import org.thinkingstudio.obsidianui.widget.AbstractSpruceWidget;
import org.thinkingstudio.obsidianui.wrapper.VanillaButtonWrapper;

public abstract class AbstractSpruceButtonWidget
extends AbstractSpruceWidget
implements Tooltipable {
    private Component message;
    private Component tooltip;
    private int tooltipTicks;
    private long lastTick;
    protected float alpha = 1.0f;

    public AbstractSpruceButtonWidget(Position position, int width, int height, Component message) {
        super(position);
        this.width = width;
        this.height = height;
        this.message = message;
    }

    public Component getMessage() {
        return this.message;
    }

    public void setMessage(Component message) {
        this.message = message;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float value) {
        this.alpha = value;
    }

    @Override
    public Optional<Component> getTooltip() {
        return Optional.ofNullable(this.tooltip);
    }

    @Override
    public void setTooltip(@Nullable Component tooltip) {
        this.tooltip = tooltip;
    }

    public VanillaButtonWrapper asVanilla() {
        return new VanillaButtonWrapper(this);
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    @Override
    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isValidClickButton(button)) {
            this.onDrag(mouseX, mouseY, deltaX, deltaY);
            return true;
        }
        return false;
    }

    protected void onClick(double mouseX, double mouseY) {
    }

    protected void onRelease(double mouseX, double mouseY) {
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
    }

    protected int getVOffset() {
        if (!this.isActive()) {
            return 0;
        }
        return this.isFocusedOrHovered() ? 2 : 1;
    }

    @Override
    protected void renderWidget(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderButton(matrices, mouseX, mouseY, delta);
        if (!this.dragging) {
            Tooltip.queueFor(this, mouseX, mouseY, this.tooltipTicks, i -> {
                this.tooltipTicks = i;
            }, this.lastTick, i -> {
                this.lastTick = i;
            });
        }
    }

    protected void renderButton(PoseStack matrices, int mouseX, int mouseY, float delta) {
        int color = this.active ? 0xFFFFFF : 0xA0A0A0;
        AbstractSpruceButtonWidget.m_93215_((PoseStack)matrices, (Font)this.client.f_91062_, (Component)this.getMessage(), (int)(this.getX() + this.getWidth() / 2), (int)(this.getY() + (this.getHeight() - 8) / 2), (int)(color | Mth.m_14167_((float)(this.alpha * 255.0f)) << 24));
    }

    @Override
    protected void renderBackground(PoseStack matrices, int mouseX, int mouseY, float delta) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha());
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractWidget.f_93617_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        int v = 46 + this.getVOffset() * 20;
        if (this.getWidth() / 2 < 200) {
            this.m_93228_(matrices, this.getX(), this.getY(), 0, v, this.getWidth() / 2, this.getHeight());
            this.m_93228_(matrices, this.getX() + this.getWidth() / 2, this.getY(), 200 - this.getWidth() / 2, v, this.getWidth() / 2, this.getHeight());
        } else {
            int x;
            int middleWidth = this.getWidth() - 100;
            this.m_93228_(matrices, this.getX(), this.getY(), 0, v, 50, this.getHeight());
            for (x = 50; x < middleWidth; x += 100) {
                this.m_93228_(matrices, this.getX() + x, this.getY(), 50, v, 100, this.getHeight());
            }
            if (x - middleWidth > 0) {
                this.m_93228_(matrices, this.getX() + x, this.getY(), 50, v, x - middleWidth, this.getHeight());
            }
            this.m_93228_(matrices, this.getX() + this.getWidth() - 50, this.getY(), 150, v, 50, this.getHeight());
        }
    }

    @Override
    @Nullable
    protected Component getNarrationMessage() {
        return Component.m_237110_((String)"gui.narrate.button", (Object[])new Object[]{this.getMessage()});
    }

    protected Component getNarrationFocusedUsageMessage() {
        return Component.m_237115_((String)"narration.button.usage.focused");
    }

    protected Component getNarrationHoveredUsageMessage() {
        return Component.m_237115_((String)"narration.button.usage.hovered");
    }

    @Override
    public void m_142291_(NarrationElementOutput builder) {
        super.m_142291_(builder);
        if (this.isActive()) {
            if (this.isFocused()) {
                builder.m_169146_(NarratedElementType.USAGE, this.getNarrationFocusedUsageMessage());
            } else {
                builder.m_169146_(NarratedElementType.USAGE, this.getNarrationHoveredUsageMessage());
            }
        }
        this.getTooltip().ifPresent(text -> builder.m_169146_(NarratedElementType.HINT, text));
    }
}

