/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.border;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import net.minecraft.client.renderer.GameRenderer;
import org.thinkingstudio.obsidianui.border.Border;
import org.thinkingstudio.obsidianui.util.ColorUtil;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;

public final class SimpleBorder
implements Border {
    public static final SimpleBorder SIMPLE_BORDER = new SimpleBorder(1, 192, 192, 192, 255);
    private final int thickness;
    private final int[] color;
    private final int[] focusedColor;

    public SimpleBorder(int thickness, int color) {
        this(thickness, color, color);
    }

    public SimpleBorder(int thickness, int color, int focusedColor) {
        this.thickness = thickness;
        this.color = ColorUtil.unpackARGBColor(color);
        this.focusedColor = ColorUtil.unpackARGBColor(focusedColor);
    }

    public SimpleBorder(int thickness, int red, int green, int blue, int alpha) {
        this(thickness, red, green, blue, alpha, red, green, blue, alpha);
    }

    public SimpleBorder(int thickness, int red, int green, int blue, int alpha, int focusedRed, int focusedGreen, int focusedBlue, int focusedAlpha) {
        this.thickness = thickness;
        this.color = new int[]{red, green, blue, alpha};
        this.focusedColor = new int[]{focusedRed, focusedGreen, focusedBlue, focusedAlpha};
    }

    @Override
    public void render(PoseStack matrices, SpruceWidget widget, int mouseX, int mouseY, float delta) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        int x = widget.getX();
        int y = widget.getY();
        int right = x + widget.getWidth();
        int bottom = y + widget.getHeight();
        boolean focused = widget.isFocused();
        this.vertex(buffer, x, y + this.thickness, focused);
        this.vertex(buffer, right, y + this.thickness, focused);
        this.vertex(buffer, right, y, focused);
        this.vertex(buffer, x, y, focused);
        this.vertex(buffer, right - this.thickness, bottom, focused);
        this.vertex(buffer, right, bottom, focused);
        this.vertex(buffer, right, y, focused);
        this.vertex(buffer, right - this.thickness, y, focused);
        this.vertex(buffer, x, bottom, focused);
        this.vertex(buffer, right, bottom, focused);
        this.vertex(buffer, right, bottom - this.thickness, focused);
        this.vertex(buffer, x, bottom - this.thickness, focused);
        this.vertex(buffer, x, bottom, focused);
        this.vertex(buffer, x + this.thickness, bottom, focused);
        this.vertex(buffer, x + this.thickness, y, focused);
        this.vertex(buffer, x, y, focused);
        tessellator.m_85914_();
    }

    private void vertex(BufferBuilder buffer, int x, int y, boolean focused) {
        int[] color = focused ? this.focusedColor : this.color;
        buffer.m_5483_((double)x, (double)y, 0.0).m_6122_(color[0], color[1], color[2], color[3]).m_5752_();
    }

    @Override
    public int getThickness() {
        return this.thickness;
    }

    public String toString() {
        return "SimpleBorder{thickness=" + this.thickness + ", color=" + Arrays.toString(this.color) + ", focusedColor=" + Arrays.toString(this.focusedColor) + "}";
    }
}

