/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.particle;

import com.github.L_Ender.cataclysm.client.render.entity.RendererMaledictus;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.Maledictus.Maledictus_Entity;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.util.CMMathUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class MaledictusRingParticle
extends TextureSheetParticle {
    public float r;
    public float g;
    public float b;
    public float opacity;
    public boolean facesCamera;
    public float yaw;
    public float pitch;
    public float size;
    private final SpriteSet sprites;
    private final EnumRingBehavior behavior;
    public boolean right;
    private final int EntityId;

    public MaledictusRingParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, float yaw, float pitch, int duration, float r, float g, float b, float opacity, float size, boolean facesCamera, boolean right, EnumRingBehavior behavior, int EntityId, SpriteSet sprites) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.setInHandPos();
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.sprites = sprites;
        this.m_107250_(1.0f, 1.0f);
        this.m_108339_(this.sprites);
        this.size = size * 0.1f;
        this.f_107225_ = duration;
        this.f_107230_ = 1.0f;
        this.r = r;
        this.g = g;
        this.b = b;
        this.opacity = opacity;
        this.yaw = yaw;
        this.pitch = pitch;
        this.facesCamera = facesCamera;
        this.right = right;
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        this.behavior = behavior;
        this.EntityId = EntityId;
    }

    public int m_6355_(float delta) {
        return 0xF0 | super.m_6355_(delta) & 0xFF0000;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.setInHandPos();
        this.m_108339_(this.sprites);
        if (this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
        ++this.f_107224_;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float var = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        this.f_107663_ = this.behavior == EnumRingBehavior.GROW ? this.size * var : (this.behavior == EnumRingBehavior.SHRINK ? this.size * (1.0f - var) : (this.behavior == EnumRingBehavior.GROW_THEN_SHRINK ? (float)((double)this.size * ((double)(1.0f - var) - Math.pow(2000.0, -var))) : this.size));
        this.f_107230_ = this.opacity * 0.95f * (1.0f - ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_) + 0.05f;
        this.f_107227_ = this.r;
        this.f_107228_ = this.g;
        this.f_107229_ = this.b;
        Vec3 Vector3d = renderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - Vector3d.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - Vector3d.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - Vector3d.m_7094_());
        Quaternion Quaternion2 = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        if (this.facesCamera) {
            if (this.f_107231_ == 0.0f) {
                Quaternion2 = renderInfo.m_90591_();
            } else {
                Quaternion2 = new Quaternion(renderInfo.m_90591_());
                float f3 = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
                Quaternion2.m_80148_(Vector3f.f_122227_.m_122270_(f3));
            }
        } else {
            Quaternion quatX = CMMathUtil.quatFromRotationXYZ(this.pitch, 0.0f, 0.0f, false);
            Quaternion quatY = CMMathUtil.quatFromRotationXYZ(0.0f, this.yaw, 0.0f, false);
            Quaternion2.m_80148_(quatY);
            Quaternion2.m_80148_(quatX);
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.m_122251_(Quaternion2);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.m_122251_(Quaternion2);
            vector3f.m_122261_(f4);
            vector3f.m_122272_(f, f1, f2);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(partialTicks);
        buffer.m_5483_((double)avector3f[0].m_122239_(), (double)avector3f[0].m_122260_(), (double)avector3f[0].m_122269_()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[1].m_122239_(), (double)avector3f[1].m_122260_(), (double)avector3f[1].m_122269_()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[2].m_122239_(), (double)avector3f[2].m_122260_(), (double)avector3f[2].m_122269_()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[3].m_122239_(), (double)avector3f[3].m_122260_(), (double)avector3f[3].m_122269_()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    public void setInHandPos() {
        Entity entity;
        if (this.EntityId != -1 && (entity = this.f_107208_.m_6815_(this.EntityId)) instanceof Maledictus_Entity) {
            Vec3 mouthPos;
            Maledictus_Entity entity2 = (Maledictus_Entity)entity;
            Vec3 vec3 = mouthPos = this.right ? RendererMaledictus.getRightHandPositionFor(this.EntityId) : RendererMaledictus.getLeftHandPositionFor(this.EntityId);
            if (mouthPos != null) {
                Vec3 translate = mouthPos.m_82549_(new Vec3(0.0, 0.0, 0.0)).m_82524_((float)(Math.PI - (double)(entity2.f_20883_ * ((float)Math.PI / 180))));
                this.m_107264_(entity2.m_20185_() + translate.f_82479_, entity2.m_20186_() + translate.f_82480_, entity2.m_20189_() + translate.f_82481_);
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static enum EnumRingBehavior {
        SHRINK,
        GROW,
        CONSTANT,
        GROW_THEN_SHRINK;

    }

    public static class MaledictusRingData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<MaledictusRingData> DESERIALIZER = new ParticleOptions.Deserializer<MaledictusRingData>(){

            public MaledictusRingData fromCommand(ParticleType<MaledictusRingData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float yaw = (float)reader.readDouble();
                reader.expect(' ');
                float pitch = (float)reader.readDouble();
                reader.expect(' ');
                float r = (float)reader.readDouble();
                reader.expect(' ');
                float g = (float)reader.readDouble();
                reader.expect(' ');
                float b = (float)reader.readDouble();
                reader.expect(' ');
                float a = (float)reader.readDouble();
                reader.expect(' ');
                float scale = (float)reader.readDouble();
                reader.expect(' ');
                int duration = reader.readInt();
                reader.expect(' ');
                int entity = reader.readInt();
                reader.expect(' ');
                boolean facesCamera = reader.readBoolean();
                boolean right = reader.readBoolean();
                return new MaledictusRingData(yaw, pitch, duration, r, g, b, a, scale, facesCamera, right, entity, EnumRingBehavior.GROW);
            }

            public MaledictusRingData fromNetwork(ParticleType<MaledictusRingData> particleTypeIn, FriendlyByteBuf buffer) {
                return new MaledictusRingData(buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean(), buffer.readBoolean(), buffer.readInt(), EnumRingBehavior.GROW);
            }
        };
        private final float yaw;
        private final float pitch;
        private final float r;
        private final float g;
        private final float b;
        private final float a;
        private final float scale;
        private final int duration;
        private final boolean facesCamera;
        private final boolean right;
        private final int EntityId;
        private final EnumRingBehavior behavior;

        public MaledictusRingData(float yaw, float pitch, int duration, float r, float g, float b, float a, float scale, boolean facesCamera, boolean right, int entityId, EnumRingBehavior behavior) {
            this.yaw = yaw;
            this.pitch = pitch;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.scale = scale;
            this.duration = duration;
            this.facesCamera = facesCamera;
            this.right = right;
            this.EntityId = entityId;
            this.behavior = behavior;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
            buffer.writeFloat(this.scale);
            buffer.writeInt(this.duration);
            buffer.writeInt(this.EntityId);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %.2f %d %d %b b", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.yaw), Float.valueOf(this.pitch), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.scale), Float.valueOf(this.a), this.duration, this.EntityId, this.facesCamera, this.right);
        }

        public ParticleType<MaledictusRingData> m_6012_() {
            return (ParticleType)ModParticle.MALEDICTUSRING.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getYaw() {
            return this.yaw;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getPitch() {
            return this.pitch;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getB() {
            return this.b;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getA() {
            return this.a;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getScale() {
            return this.scale;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getDuration() {
            return this.duration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getEntity() {
            return this.EntityId;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean getFacesCamera() {
            return this.facesCamera;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean getRight() {
            return this.right;
        }

        @OnlyIn(value=Dist.CLIENT)
        public EnumRingBehavior getBehavior() {
            return this.behavior;
        }

        public static Codec<MaledictusRingData> CODEC(ParticleType<MaledictusRingData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("yaw").forGetter(MaledictusRingData::getYaw), (App)Codec.FLOAT.fieldOf("pitch").forGetter(MaledictusRingData::getPitch), (App)Codec.FLOAT.fieldOf("r").forGetter(MaledictusRingData::getR), (App)Codec.FLOAT.fieldOf("g").forGetter(MaledictusRingData::getG), (App)Codec.FLOAT.fieldOf("b").forGetter(MaledictusRingData::getB), (App)Codec.FLOAT.fieldOf("a").forGetter(MaledictusRingData::getA), (App)Codec.FLOAT.fieldOf("scale").forGetter(MaledictusRingData::getScale), (App)Codec.INT.fieldOf("duration").forGetter(MaledictusRingData::getDuration), (App)Codec.BOOL.fieldOf("facesCamera").forGetter(MaledictusRingData::getFacesCamera), (App)Codec.BOOL.fieldOf("right").forGetter(MaledictusRingData::getRight), (App)Codec.INT.fieldOf("entityid").forGetter(MaledictusRingData::getEntity), (App)Codec.STRING.fieldOf("behavior").forGetter(ringData -> ringData.getBehavior().toString())).apply((Applicative)codecBuilder, (yaw, pitch, r, g, b, a, scale, duration, facesCamera, right, enitityid, behavior) -> new MaledictusRingData(yaw.floatValue(), pitch.floatValue(), (int)duration, r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue(), scale.floatValue(), (boolean)facesCamera, (boolean)right, (int)enitityid, EnumRingBehavior.valueOf(behavior))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class RingFactory
    implements ParticleProvider<MaledictusRingData> {
        private final SpriteSet spriteSet;

        public RingFactory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(MaledictusRingData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            MaledictusRingParticle particle = new MaledictusRingParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getYaw(), typeIn.getPitch(), typeIn.getDuration(), typeIn.getR(), typeIn.getG(), typeIn.getB(), typeIn.getA(), typeIn.getScale(), typeIn.getFacesCamera(), typeIn.getRight(), typeIn.getBehavior(), typeIn.getEntity(), this.spriteSet);
            return particle;
        }
    }
}

