/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.ICondition;
import snownee.kiwi.mixin.RecipeManagerAccess;
import snownee.kiwi.util.Util;

public enum AlternativesIngredientSerializer implements IIngredientSerializer<Ingredient>
{
    INSTANCE;


    public Ingredient parse(JsonObject json) {
        RecipeManager recipeManager = Util.getRecipeManager();
        if (recipeManager == null) {
            throw new JsonSyntaxException("Unable to get recipe manager");
        }
        ICondition.IContext ctx = ((RecipeManagerAccess)recipeManager).getContext();
        JsonArray list = GsonHelper.m_13933_((JsonObject)json, (String)"list");
        ArrayList ingredients = Lists.newArrayList();
        for (JsonElement e : list) {
            if (e.isJsonArray()) {
                JsonArray a = e.getAsJsonArray();
                if (a.size() == 0) {
                    return Ingredient.f_43901_;
                }
                for (JsonElement e2 : a) {
                    try {
                        ingredients.add(AlternativesIngredientSerializer.getIngredient(e2, ctx));
                    }
                    catch (Exception exception) {}
                }
            } else {
                try {
                    ingredients.add(AlternativesIngredientSerializer.getIngredient(e, ctx));
                }
                catch (Exception a) {
                    // empty catch block
                }
            }
            if (ingredients.isEmpty()) continue;
            if (ingredients.size() == 1) {
                return (Ingredient)ingredients.get(0);
            }
            try {
                return CompoundIngredient.of((Ingredient[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
            }
            catch (Exception e1) {
                break;
            }
        }
        throw new JsonSyntaxException("Mismatched: " + json);
    }

    public static Ingredient getIngredient(JsonElement e, ICondition.IContext ctx) {
        ResourceLocation resourcelocation;
        TagKey tagkey;
        JsonObject o;
        if (e.isJsonObject() && (o = e.getAsJsonObject()).size() == 1 && o.has("tag") && ctx.getTag(tagkey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)(resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)o, (String)"tag"))))).isEmpty()) {
            throw new JsonSyntaxException("hasNoMatchingItems");
        }
        Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)e);
        if (ingredient.m_43947_()) {
            throw new JsonSyntaxException("hasNoMatchingItems");
        }
        return ingredient;
    }

    public Ingredient parse(FriendlyByteBuf buffer) {
        throw new IllegalStateException();
    }

    public void write(FriendlyByteBuf buffer, Ingredient ingredient) {
        throw new IllegalStateException();
    }
}

