/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.item.ModItem;

@OnlyIn(value=Dist.CLIENT)
public final class TooltipEvents {
    private static ItemStack lastStack;
    private static CompoundTag lastNBT;
    private static Component lastFormatted;
    private static boolean firstSeenDebugTooltip;
    public static final String disableDebugTooltipCommand = "@kiwi disable debugTooltip";

    private TooltipEvents() {
    }

    public static void globalTooltip(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        if (KiwiClientConfig.globalTooltip) {
            ModItem.addTip(stack, tooltip, flag);
        }
    }

    public static void debugTooltip(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        List<String> tags;
        if (!Kiwi.areTagsUpdated() || !flag.m_7050_()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (stack != lastStack && minecraft.f_91074_ != null && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)292)) {
            lastStack = stack;
            CompoundTag data = stack.m_41783_();
            MutableComponent itextcomponent = Component.m_237113_((String)Registry.f_122827_.m_7981_((Object)stack.m_41720_()).toString());
            if (minecraft.f_91068_ != null) {
                minecraft.f_91068_.m_90911_(itextcomponent.getString());
            }
            if (data != null) {
                itextcomponent.m_7220_(NbtUtils.m_178061_((Tag)data));
            }
            itextcomponent.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, itextcomponent.getString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.copy.click"))).m_131138_(itextcomponent.getString()));
            minecraft.f_91074_.m_5661_((Component)itextcomponent, false);
            boolean bl = minecraft.f_91066_.f_92063_ = !minecraft.f_91066_.f_92063_;
        }
        if (KiwiClientConfig.nbtTooltip && Screen.m_96638_() && stack.m_41782_()) {
            TooltipEvents.trySendTipMsg(minecraft);
            tooltip.removeIf(c -> c.m_214077_() instanceof TranslatableContents && "item.nbt_tags".equals(((TranslatableContents)c.m_214077_()).m_237508_()));
            if (lastNBT != stack.m_41783_()) {
                lastNBT = stack.m_41783_();
                lastFormatted = NbtUtils.m_178061_((Tag)lastNBT);
            }
            tooltip.add(lastFormatted);
        } else if (KiwiClientConfig.tagsTooltip && !(tags = stack.m_204131_().map(TagKey::f_203868_).map(Object::toString).sorted().toList()).isEmpty()) {
            TooltipEvents.trySendTipMsg(minecraft);
            tags.forEach(id -> tooltip.add((Component)Component.m_237113_((String)("#" + id)).m_130940_(ChatFormatting.DARK_GRAY)));
        }
    }

    private static void trySendTipMsg(Minecraft mc) {
        if (firstSeenDebugTooltip && mc.f_91074_ != null) {
            firstSeenDebugTooltip = false;
            if (KiwiClientConfig.debugTooltipMsg) {
                MutableComponent clickHere = Component.m_237115_((String)"tip.kiwi.click_here").m_130938_($ -> $.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, disableDebugTooltipCommand)));
                mc.f_91074_.m_213846_((Component)Component.m_237110_((String)"tip.kiwi.debug_tooltip", (Object[])new Object[]{clickHere.m_130940_(ChatFormatting.AQUA)}));
                KiwiClientConfig.debugTooltipMsg = false;
                KiwiConfigManager.getHandler(KiwiClientConfig.class).save();
            }
        }
    }

    static {
        firstSeenDebugTooltip = true;
    }
}

