/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.net;

import java.math.BigInteger;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.util.XPUtil;
import org.zeith.improvableskills.data.PlayerDataManager;

@MainThreaded
public class PacketDrawXP
implements IPacket {
    public int xp;

    public PacketDrawXP(int xp) {
        this.xp = xp;
    }

    public PacketDrawXP() {
    }

    public void serverExecute(PacketContext net) {
        ServerPlayer player = net.getSender();
        PlayerDataManager.handleDataSafely((Player)player, data -> {
            if (!data.enableXPBank) {
                return;
            }
            int cxp = XPUtil.getXPTotal((Player)player);
            BigInteger bi = data.storageXp.min(new BigInteger(Integer.toUnsignedString(this.xp)));
            int xp = Math.max(bi.intValue(), 0);
            XPUtil.setPlayersExpTo((Player)player, (int)(cxp + xp));
            data.storageXp = data.storageXp.subtract(new BigInteger(Integer.toUnsignedString(xp)));
            data.sync();
        });
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.xp);
    }

    public void read(FriendlyByteBuf buf) {
        this.xp = buf.readInt();
    }
}

