/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.api.registry.RegistryMapping;
import org.zeith.hammerlib.core.adapter.LanguageAdapter;
import org.zeith.hammerlib.event.fml.FMLFingerprintCheckEvent;
import org.zeith.hammerlib.util.CommonMessages;
import org.zeith.improvableskills.api.loot.RandomBoolean;
import org.zeith.improvableskills.api.loot.SkillLoot;
import org.zeith.improvableskills.api.registry.PageletBase;
import org.zeith.improvableskills.api.registry.PlayerAbilityBase;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;
import org.zeith.improvableskills.cfg.ConfigsIS;
import org.zeith.improvableskills.command.CommandImprovableSkills;
import org.zeith.improvableskills.init.ItemsIS;
import org.zeith.improvableskills.init.TreasuresIS;
import org.zeith.improvableskills.proxy.ISClient;
import org.zeith.improvableskills.proxy.ISServer;

@Mod(value="improvableskills")
public class ImprovableSkills {
    public static final Logger LOG = LogManager.getLogger((String)"ImprovableSkills");
    public static final String MOD_ID = "improvableskills";
    public static final String MOD_NAME = "Improvable Skills";
    public static final String NBT_DATA_TAG = "ImprovableSkillsData";
    public static final ISServer PROXY = (ISServer)DistExecutor.unsafeRunForDist(() -> ISClient::new, () -> ISServer::new);
    public static final CreativeModeTab TAB = new CreativeModeTab("improvableskills"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ItemsIS.SKILLS_BOOK);
        }
    };
    private static Supplier<IForgeRegistry<PlayerSkillBase>> SKILLS;
    private static Supplier<IForgeRegistry<PlayerAbilityBase>> ABILITIES;
    private static Supplier<IForgeRegistry<PageletBase>> PAGELETS;

    public ImprovableSkills() {
        CommonMessages.printMessageOnIllegalRedistribution(ImprovableSkills.class, (Logger)LOG, (String)"ImprovableSkills", (String)"https://modrinth.com/mod/9fT7HUaI");
        LanguageAdapter.registerMod((String)MOD_ID);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::newRegistries);
        modBus.addListener(this::setup);
        modBus.addListener(this::loadComplete);
        modBus.addListener(this::checkFingerprint);
        PROXY.register(modBus);
        IEventBus mcfBus = MinecraftForge.EVENT_BUS;
        mcfBus.addListener(this::registerCommands);
        mcfBus.addListener(this::addLoot);
    }

    private void registerCommands(RegisterCommandsEvent e) {
        CommandImprovableSkills.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher(), e.getBuildContext());
    }

    private void setup(FMLCommonSetupEvent e) {
        TreasuresIS.register();
    }

    private void loadComplete(FMLLoadCompleteEvent e) {
        ConfigsIS.reloadCosts();
        if (ConfigsIS.config.hasChanged()) {
            ConfigsIS.config.save();
        }
    }

    public void checkFingerprint(FMLFingerprintCheckEvent e) {
        CommonMessages.printMessageOnFingerprintViolation((FMLFingerprintCheckEvent)e, (String)"97e852e9b3f01b83574e8315f7e77651c6605f2b455919a7319e9869564f013c", (Logger)LOG, (String)"ImprovableSkills", (String)"https://modrinth.com/mod/9fT7HUaI");
    }

    private void newRegistries(NewRegistryEvent e) {
        SKILLS = e.create(new RegistryBuilder().setName(new ResourceLocation(MOD_ID, "skills")).disableSync(), reg -> RegistryMapping.report(PlayerSkillBase.class, (IForgeRegistry)reg, (boolean)false));
        ABILITIES = e.create(new RegistryBuilder().setName(new ResourceLocation(MOD_ID, "abilities")).disableSync(), reg -> RegistryMapping.report(PlayerAbilityBase.class, (IForgeRegistry)reg, (boolean)false));
        PAGELETS = e.create(new RegistryBuilder().setName(new ResourceLocation(MOD_ID, "pagelets")).disableSync(), reg -> RegistryMapping.report(PageletBase.class, (IForgeRegistry)reg, (boolean)false));
    }

    private void addLoot(LootTableLoadEvent e) {
        for (PlayerSkillBase skill : ImprovableSkills.SKILLS()) {
            SkillLoot loot = skill.getLoot();
            if (loot == null) continue;
            loot.apply(e);
        }
        String ids = e.getName().toString();
        if (ids.contains("chests/") && ConfigsIS.parchmentGeneration) {
            if (ConfigsIS.blockedParchmentChests.contains(ids)) {
                LOG.debug("SKIPPING parchment injection for LootTable '" + ids + "'!");
                return;
            }
            RandomBoolean bool = new RandomBoolean();
            bool.n = 5;
            LOG.info("Injecting parchment into LootTable '" + e.getName() + "'!");
            try {
                LootTable table = e.getTable();
                table.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(ConfigsIS.parchmentRarity)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ItemsIS.PARCHMENT_FRAGMENT).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79707_(1).m_79711_(60)).name("parchment_fragment").m_79082_());
            }
            catch (Throwable err) {
                LOG.error("Failed to inject parchment into LootTable '" + e.getName() + "'!!!");
                err.printStackTrace();
            }
        }
    }

    public static IForgeRegistry<PlayerSkillBase> SKILLS() {
        return SKILLS.get();
    }

    public static IForgeRegistry<PlayerAbilityBase> ABILITIES() {
        return ABILITIES.get();
    }

    public static IForgeRegistry<PageletBase> PAGELETS() {
        return PAGELETS.get();
    }
}

