/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.api.posts;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import twistedgate.immersiveposts.api.posts.PostMaterialRegistry;
import twistedgate.immersiveposts.common.IPOContent;
import twistedgate.immersiveposts.common.blocks.HorizontalTrussBlock;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.enums.EnumPostMaterial;

public interface IPostMaterial {
    public ItemStack getItemStack();

    public ResourceLocation getTexture();

    public Block getSourceBlock();

    public boolean isFence();

    public String getName();

    public String getBlockName();

    public BlockBehaviour.Properties getBlockProperties();

    public static BlockState getPostState(@Nonnull ItemStack stack) {
        return IPostMaterial.getPostState(IPostMaterial.getPostMaterial(stack));
    }

    public static BlockState getPostState(IPostMaterial material) {
        PostBlock block = IPOContent.Blocks.Posts.get(material);
        if (block == null && PostMaterialRegistry.MAP.containsKey(material)) {
            block = (Block)PostMaterialRegistry.getPostFrom(material).get();
        }
        return block.m_49966_();
    }

    public static BlockState getTrussState(@Nonnull ItemStack stack) {
        return IPostMaterial.getTrussState(IPostMaterial.getPostMaterial(stack));
    }

    public static BlockState getTrussState(@Nonnull IPostMaterial material) {
        HorizontalTrussBlock block = IPOContent.Blocks.HorizontalTruss.get(material);
        if (block == null && PostMaterialRegistry.MAP.containsKey(material)) {
            block = (Block)PostMaterialRegistry.getTrussFrom(material).get();
        }
        return block.m_49966_();
    }

    public static IPostMaterial getPostMaterial(@Nonnull ItemStack stack) {
        for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            if (!stack.m_41656_(mat.getItemStack())) continue;
            return mat;
        }
        for (IPostMaterial mat : PostMaterialRegistry.MAP.keySet()) {
            if (!stack.m_41656_(mat.getItemStack())) continue;
            return mat;
        }
        return null;
    }

    public static boolean isValidItem(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            if (!stack.m_41656_(mat.getItemStack())) continue;
            return true;
        }
        for (IPostMaterial mat : PostMaterialRegistry.MAP.keySet()) {
            if (!stack.m_41656_(mat.getItemStack())) continue;
            return true;
        }
        return false;
    }
}

