/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import blusunrize.immersiveengineering.api.ApiUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.DerrickTileEntity;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.data.ModelData;

public class DerrickRenderer
implements BlockEntityRenderer<DerrickTileEntity> {
    static final Vector3f Y_AXIS = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final ResourceLocation DRILL = ResourceUtils.ip("multiblock/dyn/derrick_drill");
    public static final ResourceLocation PIPE_SEGMENT = ResourceUtils.ip("multiblock/dyn/derrick_pipe_segment");
    public static final ResourceLocation PIPE_TOP = ResourceUtils.ip("multiblock/dyn/derrick_pipe_top");

    public boolean shouldRenderOffScreen(@Nonnull DerrickTileEntity te) {
        return true;
    }

    public void render(DerrickTileEntity te, float partialTicks, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!te.formed || te.isDummy() || !te.getLevelNonnull().m_46805_(te.m_58899_())) {
            return;
        }
        matrix.m_85836_();
        float rot = (float)te.rotation + (te.drilling ? 10.0f * partialTicks : 0.0f);
        matrix.m_85837_(0.5, 1.0, 0.5);
        matrix.m_85845_(new Quaternion(Y_AXIS, rot, true));
        this.renderObj(DRILL, bufferIn, matrix, combinedLightIn, combinedOverlayIn);
        float pipeHeight = -(rot / 360.0f);
        for (int i = 0; i < 6; ++i) {
            float y = pipeHeight + (float)i;
            if (!((double)y > -1.0)) continue;
            matrix.m_85836_();
            matrix.m_85837_(0.0, (double)y + 0.75, 0.0);
            this.renderObj(i < 5 ? PIPE_SEGMENT : PIPE_TOP, bufferIn, matrix, combinedLightIn, combinedOverlayIn);
            matrix.m_85849_();
        }
        matrix.m_85849_();
    }

    private void renderObj(ResourceLocation modelRL, @Nonnull MultiBufferSource bufferIn, @Nonnull PoseStack matrix, int light, int overlay) {
        List quads = MCUtil.getModel(modelRL).getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        PoseStack.Pose last = matrix.m_85850_();
        VertexConsumer solid = bufferIn.m_6299_(RenderType.m_110451_());
        for (BakedQuad quad : quads) {
            solid.m_85987_(last, quad, 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }
}

