/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;

public class FlareBulletColorRecipe
extends CustomRecipe {
    public FlareBulletColorRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        boolean hasBullet = false;
        boolean hasDye = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (this.isFlareBullet(stackInSlot)) {
                if (hasBullet) {
                    return false;
                }
                hasBullet = true;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                hasDye = true;
                continue;
            }
            return false;
        }
        return hasBullet && hasDye;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv) {
        int[] colourArray = new int[3];
        int j = 0;
        int totalColourSets = 0;
        ItemStack bullet = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (bullet.m_41619_() && this.isFlareBullet(stackInSlot)) {
                bullet = stackInSlot;
                int colour = ((IEItemInterfaces.IColouredItem)bullet.m_41720_()).getColourForIEItem(bullet, 1);
                float r = (float)(colour >> 16 & 0xFF) / 255.0f;
                float g = (float)(colour >> 8 & 0xFF) / 255.0f;
                float b = (float)(colour & 0xFF) / 255.0f;
                j = (int)((float)j + Math.max(r, Math.max(g, b)) * 255.0f);
                colourArray[0] = (int)((float)colourArray[0] + r * 255.0f);
                colourArray[1] = (int)((float)colourArray[1] + g * 255.0f);
                colourArray[2] = (int)((float)colourArray[2] + b * 255.0f);
                ++totalColourSets;
                continue;
            }
            if (!Utils.isDye(stackInSlot)) continue;
            float[] afloat = Utils.getDye(stackInSlot).m_41068_();
            int r = (int)(afloat[0] * 255.0f);
            int g = (int)(afloat[1] * 255.0f);
            int b = (int)(afloat[2] * 255.0f);
            j += Math.max(r, Math.max(g, b));
            colourArray[0] = colourArray[0] + r;
            colourArray[1] = colourArray[1] + g;
            colourArray[2] = colourArray[2] + b;
            ++totalColourSets;
        }
        if (!bullet.m_41619_()) {
            ItemStack newBullet = ItemHandlerHelper.copyStackWithSize((ItemStack)bullet, (int)1);
            int r = colourArray[0] / totalColourSets;
            int g = colourArray[1] / totalColourSets;
            int b = colourArray[2] / totalColourSets;
            float colourMod = (float)j / (float)totalColourSets;
            float highestColour = Math.max(r, Math.max(g, b));
            r = (int)((float)r * colourMod / highestColour);
            g = (int)((float)g * colourMod / highestColour);
            b = (int)((float)b * colourMod / highestColour);
            int newColour = (r << 8) + g;
            newColour = (newColour << 8) + b;
            ItemNBTHelper.putInt(newBullet, "flareColour", newColour);
            return newBullet;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.FLARE_BULLET_COLOR.get();
    }

    private boolean isFlareBullet(ItemStack stack) {
        return stack.m_41720_() instanceof BulletItem && ((BulletItem)stack.m_41720_()).getType() == BulletHandler.getBullet(BulletItem.FLARE);
    }
}

