/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.metal.ClocheBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class ClocheRenderer
extends IEBlockEntityRenderer<ClocheBlockEntity> {
    private static final Map<BlockState, List<BakedQuad>> plantQuads = new HashMap<BlockState, List<BakedQuad>>();

    public void render(ClocheBlockEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.getLevelNonnull().m_46805_(tile.m_58899_())) {
            return;
        }
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BlockPos blockPos = tile.m_58899_();
        tile.particles.get().render(matrixStack, bufferIn, partialTicks);
        ClocheRecipe recipe = tile.cachedRecipe.get();
        if (recipe != null) {
            RenderType type = Sheets.m_110790_();
            VertexConsumer baseBuilder = bufferIn.m_6299_(type);
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 1.0625, 0.0);
            NonNullList<ItemStack> inventory = tile.getInventory();
            ItemStack seed = (ItemStack)inventory.get(1);
            ItemStack soil = (ItemStack)inventory.get(0);
            float growth = Mth.m_14036_((float)(tile.renderGrowth / (float)recipe.getTime(seed, soil)), (float)0.0f, (float)1.0f);
            float scale = recipe.renderFunction.getScale(seed, growth);
            matrixStack.m_85837_((double)((1.0f - scale) / 2.0f), 0.0, (double)((1.0f - scale) / 2.0f));
            matrixStack.m_85841_(scale, scale, scale);
            Collection<Pair<BlockState, Transformation>> blocks = recipe.renderFunction.getBlocks(seed, growth);
            for (Pair<BlockState, Transformation> block : blocks) {
                BlockState state = (BlockState)block.getFirst();
                List<BakedQuad> plantQuadList = plantQuads.get(state);
                if (plantQuadList == null) {
                    BakedModel plantModel = blockRenderer.m_110910_(state);
                    plantQuadList = new ArrayList<BakedQuad>(plantModel.getQuads(state, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null));
                    for (Direction f : Direction.values()) {
                        plantQuadList.addAll(plantModel.getQuads(state, f, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null));
                    }
                    plantQuads.put(state, plantQuadList);
                }
                int col = ClientUtils.mc().m_91298_().m_92577_(state, null, blockPos, -1);
                matrixStack.pushTransformation((Transformation)block.getSecond());
                RenderUtils.renderModelTESRFancy(plantQuadList, baseBuilder, matrixStack, tile.getLevelNonnull(), blockPos, false, col, combinedLightIn);
                matrixStack.m_85849_();
            }
            ArrayList<BakedQuad> injectedQuadList = new ArrayList<BakedQuad>();
            Consumer<Object> quadInjector = object -> {
                if (object instanceof BakedQuad) {
                    injectedQuadList.add((BakedQuad)object);
                }
            };
            recipe.renderFunction.injectQuads(seed, growth, quadInjector);
            if (injectedQuadList.size() > 0) {
                RenderUtils.renderModelTESRFancy(injectedQuadList, baseBuilder, matrixStack, tile.getLevelNonnull(), blockPos, false, -1, combinedLightIn);
            }
            matrixStack.m_85849_();
        }
    }

    public static void reset() {
        plantQuads.clear();
    }
}

