/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.metal.ArcFurnaceBlockEntity;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;

public class ArcFurnaceRenderer
extends IEBlockEntityRenderer<ArcFurnaceBlockEntity> {
    private TextureAtlasSprite hotMetal_flow = null;
    private TextureAtlasSprite hotMetal_still = null;
    public static final String NAME = "arc_furnace_electrodes";
    public static DynamicModel ELECTRODES;
    public static final ResourceLocation HOT_METLA_STILL;
    public static final ResourceLocation HOT_METLA_FLOW;

    public void render(ArcFurnaceBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!te.formed || te.isDummy() || !te.getLevelNonnull().m_46805_(te.m_58899_())) {
            return;
        }
        List renderedParts = null;
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)te.getInventory().get(23 + i)).m_41619_()) continue;
            if (renderedParts == null) {
                renderedParts = Lists.newArrayList((Object[])new String[]{"electrode" + (i + 1)});
                continue;
            }
            renderedParts.add("electrode" + (i + 1));
        }
        if (renderedParts == null) {
            return;
        }
        if (te.shouldRenderAsActive()) {
            renderedParts.add("active");
        }
        matrixStack.m_85836_();
        List quads = ELECTRODES.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelDataUtils.single(DynamicSubmodelCallbacks.getProperty(), IEProperties.VisibilityList.show(renderedParts)), RenderType.m_110463_());
        matrixStack.m_85836_();
        ArcFurnaceRenderer.rotateForFacing(matrixStack, te.getFacing());
        RenderUtils.renderModelTESRFast(quads, bufferIn.m_6299_(RenderType.m_110451_()), matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.m_85849_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        if (te.pouringMetal > 0) {
            if (this.hotMetal_flow == null) {
                TextureAtlas blockMap = ClientUtils.mc().m_91304_().m_119428_(InventoryMenu.f_39692_);
                this.hotMetal_still = blockMap.m_118316_(HOT_METLA_STILL);
                this.hotMetal_flow = blockMap.m_118316_(HOT_METLA_FLOW);
            }
            matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -te.getFacing().m_122435_() + 180.0f, true));
            int process = 40;
            float speed = 5.0f;
            int pour = process - te.pouringMetal;
            float h = ((float)pour > (float)process - speed ? (float)(process - pour) / speed * 27.0f : ((float)pour > speed ? 27.0f : (float)pour / speed * 27.0f)) / 16.0f;
            matrixStack.m_85837_(-0.5, 0.5625, 1.5);
            VertexConsumer fullbright = bufferIn.m_6299_(IERenderTypes.SOLID_FULLBRIGHT);
            matrixStack.m_85836_();
            if ((float)pour > (float)process - speed) {
                matrixStack.m_85837_(0.0, (double)(-1.6875f + h), 0.0);
            }
            if (h > 1.0f) {
                matrixStack.m_85837_(0.0, (double)(-h), 0.0);
                RenderUtils.renderTexturedBox(fullbright, matrixStack, 0.375f, 0.0f, 0.375f, 0.625f, 1.0f, 0.625f, this.hotMetal_flow, true);
                matrixStack.m_85837_(0.0, 1.0, 0.0);
                RenderUtils.renderTexturedBox(fullbright, matrixStack, 0.375f, 0.0f, 0.375f, 0.625f, h - 1.0f, 0.625f, this.hotMetal_flow, true);
                matrixStack.m_85837_(0.0, -1.0, 0.0);
                matrixStack.m_85837_(0.0, (double)h, 0.0);
            } else {
                matrixStack.m_85837_(0.0, (double)(-h), 0.0);
                RenderUtils.renderTexturedBox(fullbright, matrixStack, 0.375f, 0.0f, 0.375f, 0.625f, h, 0.625f, this.hotMetal_flow, true);
                matrixStack.m_85837_(0.0, (double)h, 0.0);
            }
            if ((float)pour > (float)process - speed) {
                matrixStack.m_85837_(0.0, (double)(1.6875f - h), 0.0);
            }
            if ((float)pour > speed) {
                float h2 = (float)pour > (float)process - speed ? 0.625f : (float)pour / ((float)process - speed) * 0.625f;
                matrixStack.m_85837_(0.0, -1.6875, 0.0);
                RenderUtils.renderTexturedBox(fullbright, matrixStack, 0.125f, 0.0f, 0.125f, 0.875f, h2, 0.875f, this.hotMetal_still, false);
                matrixStack.m_85837_(0.0, 1.6875, 0.0);
            }
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    static {
        HOT_METLA_STILL = new ResourceLocation("immersiveengineering", "block/fluid/hot_metal_still");
        HOT_METLA_FLOW = new ResourceLocation("immersiveengineering", "block/fluid/hot_metal_flow");
    }
}

