/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.Fetcher;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.java.functions.Function3;

public class ScanDataHelper {
    public static <T> List<Class<? extends T>> lookupAnnotatedTypes(Class<? extends Annotation> annotation, Class<T> baseType) {
        return ScanDataHelper.lookupAnnotatedTypes(annotation, baseType, (Predicate<ModAwareAnnotationData>)Predicates.alwaysTrue());
    }

    public static <T> List<Class<? extends T>> lookupAnnotatedTypes(Class<? extends Annotation> annotation, Class<T> baseType, Predicate<ModAwareAnnotationData> matcher) {
        ArrayList classes = new ArrayList();
        ScanDataHelper.lookupAnnotatedObjects(annotation, (ModAwareAnnotationData ad) -> ad.parent.targetType() == ElementType.TYPE && baseType.isAssignableFrom(ReflectionUtil.fetchClass(ad.parent.clazz())) && matcher.test((ModAwareAnnotationData)ad)).forEach(ad -> classes.add(ReflectionUtil.fetchClass(ad.parent.clazz())));
        return classes;
    }

    public static Collection<ModAwareAnnotationData> lookupAnnotatedObjects(Class<? extends Annotation> annotation) {
        return ScanDataHelper.lookupAnnotatedObjects(annotation, (Predicate<ModAwareAnnotationData>)Predicates.alwaysTrue());
    }

    public static Collection<ModAwareAnnotationData> lookupAnnotatedObjects(Class<? extends Annotation> annotation, Predicate<ModAwareAnnotationData> matcher) {
        ArrayList<ModAwareAnnotationData> data = new ArrayList<ModAwareAnnotationData>();
        Type annotationType = Type.getType(annotation);
        ModList.get().getAllScanData().stream().flatMap(d -> d.getAnnotations().stream().map(ad -> new ModAwareAnnotationData((ModFileScanData.AnnotationData)ad, (ModFileScanData)d))).filter(ad -> annotationType.equals((Object)ad.parent.annotationType()) && matcher.test((ModAwareAnnotationData)ad)).forEach(data::add);
        return data;
    }

    public static Collection<ModAwareAnnotationData> lookupAnnotatedObjects(ModFileScanData data, Class<? extends Annotation> annotation) {
        return ScanDataHelper.lookupAnnotatedObjects(data, annotation, (Predicate<ModAwareAnnotationData>)Predicates.alwaysTrue());
    }

    public static Collection<ModAwareAnnotationData> lookupAnnotatedObjects(ModFileScanData data, Class<? extends Annotation> annotation, Predicate<ModAwareAnnotationData> matcher) {
        ArrayList<ModAwareAnnotationData> lst = new ArrayList<ModAwareAnnotationData>();
        Type annotationType = Type.getType(annotation);
        Stream.of(data).flatMap(d -> d.getAnnotations().stream().map(ad -> new ModAwareAnnotationData((ModFileScanData.AnnotationData)ad, (ModFileScanData)d))).filter(ad -> annotationType.equals((Object)ad.parent.annotationType()) && matcher.test((ModAwareAnnotationData)ad)).forEach(lst::add);
        return lst;
    }

    public static ScanProperties properties(Object ... keyValuePairs) {
        return new ScanProperties(keyValuePairs);
    }

    public static <T, A extends Annotation> Map<ScanTarget, T> gatherScans(Class<A> annotation, ElementType target, Function3<ScanTarget, FMLModContainer, ModAwareAnnotationData, T> result) {
        return ((ImmutableMap.Builder)Util.m_137469_((Object)ImmutableMap.builder(), map -> {
            for (ModAwareAnnotationData data : ScanDataHelper.lookupAnnotatedObjects(annotation)) {
                FMLModContainer mod;
                if (data.getTargetType() != target || (mod = (FMLModContainer)data.getOwnerMod().orElse(null)) == null) continue;
                ScanTarget tg = new ScanTarget(data.clazz(), data.getMemberName());
                map.put((Object)tg, result.apply(tg, mod, data));
            }
        })).build();
    }

    public static class ScanProperties
    implements Predicate<ModFileScanData.AnnotationData> {
        private final Map<String, Object> entries;

        public ScanProperties(Object ... keyValuePairs) {
            if (keyValuePairs.length % 2 != 0) {
                throw new IllegalArgumentException("Odd amount of key & value pairs!");
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < keyValuePairs.length; i += 2) {
                String key = Cast.cast(keyValuePairs[i], String.class);
                Object value = keyValuePairs[i + 1];
                if (key == null) {
                    throw new NullPointerException("Key argument @" + i + " is " + (keyValuePairs[i] == null ? "null" : "not a string") + "!");
                }
                builder.put((Object)key, value);
            }
            this.entries = builder.build();
        }

        public boolean matches(Map<String, Object> data) {
            if (this.entries.size() > data.size()) {
                return false;
            }
            for (String key : this.entries.keySet()) {
                if (!data.containsKey(key)) {
                    return false;
                }
                if (Objects.equals(this.entries.get(key), data.get(key))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean test(ModFileScanData.AnnotationData t) {
            return this.matches(t.annotationData());
        }
    }

    public static class ModAwareAnnotationData {
        private final ModFileScanData modFile;
        private Fetcher<Optional<FMLModContainer>> ownerMod;
        public final ModFileScanData.AnnotationData parent;

        public ModAwareAnnotationData(ModFileScanData.AnnotationData parent, ModFileScanData modFile) {
            this.parent = parent;
            this.modFile = modFile;
        }

        public Optional<FMLModContainer> getOwnerMod() {
            if (this.ownerMod == null) {
                this.ownerMod = Fetcher.fetchOnce(() -> this.modFile.getIModInfoData().stream().flatMap(inf -> inf.getMods().stream()).map(IModInfo::getModId).map(arg_0 -> ((ModList)ModList.get()).getModContainerById(arg_0)).map(modopt -> modopt.orElse(null)).filter((Predicate<ModContainer>)Predicates.instanceOf(FMLModContainer.class)).findFirst().map(FMLModContainer.class::cast));
            }
            return this.ownerMod.get();
        }

        public ModFileScanData getModFile() {
            return this.modFile;
        }

        public Class<?> getOwnerClass() {
            return ReflectionUtil.fetchClass(this.parent.clazz());
        }

        public Type clazz() {
            return this.parent.clazz();
        }

        public Optional<Object> getProperty(String key) {
            Map map = this.parent.annotationData();
            return map.containsKey(key) ? Optional.ofNullable(map.get(key)) : Optional.empty();
        }

        public ElementType getTargetType() {
            return this.parent.targetType();
        }

        public String getMemberName() {
            return this.parent.memberName();
        }
    }

    public record ScanTarget(Type owner, String member) {
        public static ScanTarget of(Class<?> cls, String member) {
            return new ScanTarget(Type.getType(cls), member);
        }
    }
}

