/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.orcinus.goodending.init.GoodEndingBlocks;
import net.orcinus.goodending.world.gen.features.config.MuddyOakFeatureConfig;

public class MuddyOakTreeFeature
extends Feature<MuddyOakFeatureConfig> {
    public MuddyOakTreeFeature(Codec<MuddyOakFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<MuddyOakFeatureConfig> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        MuddyOakFeatureConfig config = (MuddyOakFeatureConfig)context.m_159778_();
        int treeHeight = ConstantInt.m_146483_((int)8).m_214085_(random);
        ArrayList leavePoses = Lists.newArrayList();
        for (int i = 0; i < treeHeight; ++i) {
            Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
            if (config.generateBranch && random.m_188503_(2) == 0 && i >= treeHeight / 2) {
                for (int branchLength = 0; branchLength <= Mth.m_216271_((RandomSource)random, (int)1, (int)2); ++branchLength) {
                    BlockPos branchPos = blockPos.m_6630_(i).m_5484_(direction, branchLength);
                    if (!world.m_7433_(branchPos.m_7495_(), DripstoneUtils::m_159664_) || !world.m_7433_(branchPos, blockState -> blockState.m_60795_() || blockState.m_204336_(BlockTags.f_13035_) || blockState.m_60713_(Blocks.f_49990_))) continue;
                    world.m_7731_(branchPos, (BlockState)config.f_68185_.m_213972_(random, branchPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 19);
                }
                if (!world.m_7433_(blockPos.m_6630_(i), blockState -> blockState.m_60795_() || blockState.m_204336_(BlockTags.f_13035_) || blockState.m_60713_(Blocks.f_49990_) || blockState.m_204336_(BlockTags.f_13106_))) continue;
                world.m_7731_(blockPos.m_6630_(i), config.f_68185_.m_213972_(random, blockPos.m_6630_(i)), 2);
                continue;
            }
            if (!world.m_7433_(blockPos.m_6630_(i), blockState -> blockState.m_60795_() || blockState.m_204336_(BlockTags.f_13035_) || blockState.m_60713_(Blocks.f_49990_))) continue;
            world.m_7731_(blockPos.m_6630_(i), config.f_68185_.m_213972_(random, blockPos.m_6630_(i)), 19);
        }
        for (int y = -1; y <= 2; ++y) {
            int radius = 4;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_() + y + treeHeight, blockPos.m_123343_() + z);
                    int eliminateFactor = 16;
                    if (y == -1 && (x <= 1 && x >= -1 && (z == 2 || z == -2) || z <= 1 && z >= -1 && (x == 2 || x == -2))) {
                        if (world.m_7433_(pos.m_7495_(), DripstoneUtils::m_159664_)) {
                            world.m_7731_(pos.m_7495_(), (BlockState)config.f_161213_.m_213972_(random, pos.m_7495_()).m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)), 19);
                            leavePoses.add(pos.m_7495_());
                        }
                        if ((x == 0 || z == 0) && world.m_7433_(pos.m_6625_(2), DripstoneUtils::m_159664_)) {
                            world.m_7731_(pos.m_6625_(2), (BlockState)config.f_161213_.m_213972_(random, pos.m_6625_(2)).m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)), 19);
                            leavePoses.add(pos.m_6625_(2));
                        }
                    }
                    if (y > 0) {
                        eliminateFactor /= y * 2;
                    }
                    if (x * x + z * z > eliminateFactor || !world.m_7433_(pos, DripstoneUtils::m_159664_)) continue;
                    world.m_7731_(pos, (BlockState)config.f_161213_.m_213972_(random, pos).m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)), 19);
                    leavePoses.add(pos);
                }
            }
        }
        this.generateHangingVines(world, 0.25f, random, leavePoses);
        return true;
    }

    public void generateHangingVines(WorldGenLevel world, float probability, RandomSource random, List<BlockPos> leavePositions) {
        leavePositions.stream().filter(pos -> world.m_46859_(pos.m_7495_()) && world.m_8055_(pos).m_60713_(Blocks.f_50050_)).forEach(pos -> {
            BlockPos.MutableBlockPos mutable = pos.m_122032_();
            if (random.m_188501_() < probability) {
                int length = Mth.m_216271_((RandomSource)random, (int)1, (int)2);
                for (int i = 0; i <= length; ++i) {
                    if (world.m_46859_((BlockPos)mutable)) {
                        if (i == length || !world.m_46859_(mutable.m_7495_())) {
                            world.m_7731_((BlockPos)mutable, (BlockState)((Block)GoodEndingBlocks.HANGING_OAK_LEAVES.get()).m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(Mth.m_216271_((RandomSource)random, (int)17, (int)25))), 2);
                            break;
                        }
                        world.m_7731_((BlockPos)mutable, ((Block)GoodEndingBlocks.HANGING_OAK_LEAVES_PLANT.get()).m_49966_(), 2);
                    }
                    mutable.m_122173_(Direction.DOWN);
                }
            }
        });
    }
}

