/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.orcinus.goodending.init.GoodEndingBlocks;
import net.orcinus.goodending.world.gen.features.config.FancyDarkOakTreeConfig;

public class FancyDarkOakFeature
extends Feature<FancyDarkOakTreeConfig> {
    public FancyDarkOakFeature(Codec<FancyDarkOakTreeConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<FancyDarkOakTreeConfig> context) {
        int y;
        BlockPos blockPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        WorldGenLevel world = context.m_159774_();
        boolean huge = false;
        int height = 7;
        if (((FancyDarkOakTreeConfig)context.m_159778_()).isFancy) {
            height *= 2;
            huge = true;
        }
        int baseRadius = 2;
        ArrayList list = Lists.newArrayList();
        ArrayList leavePoses = Lists.newArrayList();
        ArrayList stemPoses = Lists.newArrayList();
        if (!world.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_144274_)) {
            return false;
        }
        Optional<BlockPos> initialPos = this.getInitialPos((FancyDarkOakTreeConfig)context.m_159778_(), world, blockPos, baseRadius, 1);
        if (initialPos.isEmpty()) {
            return false;
        }
        blockPos = initialPos.get();
        for (int x = -baseRadius; x <= baseRadius; ++x) {
            for (int z = -baseRadius; z <= baseRadius; ++z) {
                for (int y2 = 0; y2 < height; ++y2) {
                    boolean logFlag2;
                    boolean flag1;
                    BlockPos pos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_() + y2, blockPos.m_123343_() + z);
                    boolean flag = x == -baseRadius || x == baseRadius;
                    boolean bl = flag1 = z == -baseRadius || z == baseRadius;
                    if (flag && flag1) continue;
                    int corner = baseRadius - 1;
                    boolean logFlag = (x == corner && flag1 || x == -corner && flag1 || z == corner && flag || z == -corner && flag) && y2 > 1;
                    boolean logFlag1 = (x == 0 && flag1 || z == 0 && flag) && y2 > 2;
                    boolean bl2 = logFlag2 = !(x != corner && x != -corner || z != corner && z != -corner || y2 <= 3);
                    if (logFlag || logFlag1 || logFlag2) continue;
                    if (y2 > 5 && (x == -corner && z == 0 || x == corner && z == 0 || x == 0 && z == -corner || x == 0 && z == corner)) {
                        for (Direction direction : Direction.Plane.HORIZONTAL) {
                            BlockPos branchPos = blockPos.m_6630_(height - 1).m_121945_(direction);
                            int length = UniformInt.m_146622_((int)1, (int)3).m_214085_(random);
                            for (int i = 0; i < length; ++i) {
                                if (!world.m_46859_(branchPos.m_5484_(direction, i)) && !world.m_8055_(branchPos.m_5484_(direction, i)).m_60767_().m_76336_()) continue;
                                world.m_7731_(branchPos.m_5484_(direction, i), (BlockState)Blocks.f_50004_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 2);
                                for (int t = 0; t < length; ++t) {
                                    if (!world.m_46859_(branchPos.m_5484_(direction, length).m_6630_(t)) && !world.m_8055_(branchPos.m_5484_(direction, length).m_6630_(t)).m_60767_().m_76336_()) continue;
                                    world.m_7731_(branchPos.m_5484_(direction, length).m_6630_(t), Blocks.f_50004_.m_49966_(), 19);
                                    list.add(branchPos.m_5484_(direction, length).m_6630_(length));
                                }
                            }
                        }
                    }
                    if (!world.m_46859_(pos) && !world.m_8055_(pos).m_60767_().m_76336_()) continue;
                    world.m_7731_(pos, Blocks.f_50004_.m_49966_(), 19);
                    if (!huge || y2 <= height - 2) continue;
                    stemPoses.add(pos);
                }
            }
        }
        for (BlockPos stemPos : stemPoses) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    int stemLength = Mth.m_216271_((RandomSource)random, (int)1, (int)4);
                    for (y = 0; y <= stemLength; ++y) {
                        BlockPos pos = new BlockPos(stemPos.m_123341_() + x, stemPos.m_123342_() - y, stemPos.m_123343_() + z);
                        if (x * x + z * z > 4 || !world.m_46859_(pos)) continue;
                        world.m_7731_(pos, Blocks.f_50004_.m_49966_(), 19);
                    }
                }
            }
        }
        for (BlockPos pos : list) {
            int leaveRadius = 2;
            for (int x = -leaveRadius; x <= leaveRadius; ++x) {
                for (int z = -leaveRadius; z <= leaveRadius; ++z) {
                    for (y = -1; y <= 1; ++y) {
                        boolean flag2;
                        BlockPos leavePos = new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                        boolean flag = !(x != -leaveRadius && x != leaveRadius || z != -leaveRadius && z != leaveRadius);
                        boolean flag1 = y == 1 && (x <= -leaveRadius + random.m_188503_(2) || x >= leaveRadius - random.m_188503_(2) || z <= -leaveRadius + random.m_188503_(2) || z >= leaveRadius - random.m_188503_(2));
                        boolean bl = flag2 = y == -1 && x * x + z * z > 4;
                        if (flag || flag1 || flag2) continue;
                        if (world.m_7433_(leavePos, DripstoneUtils::m_159664_)) {
                            world.m_7731_(leavePos, (BlockState)Blocks.f_50055_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 19);
                        }
                        leavePoses.add(leavePos);
                    }
                }
            }
        }
        Iterator iterator = leavePoses.iterator();
        if (iterator.hasNext()) {
            BlockPos densePos = (BlockPos)iterator.next();
            world.m_7731_(densePos, (BlockState)((Block)GoodEndingBlocks.DENSE_DARK_OAK_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 19);
        }
        block14: for (BlockPos pos : leavePoses) {
            if (!(random.m_188501_() < 0.15f) || !world.m_7433_(pos.m_7495_(), BlockBehaviour.BlockStateBase::m_60795_) || !world.m_7433_(pos, blockState -> blockState.m_60713_(Blocks.f_50055_))) continue;
            int branchHeight = (int)Mth.m_216267_((RandomSource)random, (float)((float)height * 0.25f), (float)((float)height * 0.75f));
            for (int i = 0; i <= branchHeight; ++i) {
                BlockPos placePos = pos.m_6625_(i);
                if (i == branchHeight && world.m_7433_(placePos, BlockBehaviour.BlockStateBase::m_60795_)) {
                    world.m_7731_(placePos, (BlockState)((Block)GoodEndingBlocks.HANGING_DARK_OAK_LEAVES.get()).m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(25)), 19);
                    continue block14;
                }
                if (world.m_8055_(placePos.m_7495_()).m_204336_(BlockTags.f_13106_)) {
                    world.m_7731_(placePos, (BlockState)((Block)GoodEndingBlocks.HANGING_DARK_OAK_LEAVES.get()).m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(25)), 19);
                    continue block14;
                }
                if (!world.m_7433_(placePos, BlockBehaviour.BlockStateBase::m_60795_)) continue;
                world.m_7731_(placePos, ((Block)GoodEndingBlocks.HANGING_DARK_OAK_LEAVES_PLANT.get()).m_49966_(), 19);
            }
        }
        return true;
    }

    public Optional<BlockPos> getInitialPos(FancyDarkOakTreeConfig config, WorldGenLevel world, BlockPos originPos, int baseRadius, int count) {
        if (config.planted) {
            return Optional.of(originPos);
        }
        for (int x = -baseRadius; x <= baseRadius; ++x) {
            for (int z = -baseRadius; z <= baseRadius; ++z) {
                BlockPos pos = new BlockPos(originPos.m_123341_() + x, originPos.m_123342_(), originPos.m_123343_() + z);
                if (!world.m_46859_(pos.m_7495_())) continue;
                if (count > 4) {
                    return Optional.empty();
                }
                return this.getInitialPos(config, world, originPos.m_7495_(), baseRadius, ++count);
            }
        }
        return Optional.of(originPos);
    }
}

