/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.mixin;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.orcinus.goodending.init.GoodEndingCriteriaTriggers;
import net.orcinus.goodending.init.GoodEndingStatusEffects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    private static final LinkedList<Supplier<MobEffect>> IMMUNITY_HIERARCHY = (LinkedList)Util.m_137469_((Object)Lists.newLinkedList(), list -> {
        list.add(GoodEndingStatusEffects.STRONG_IMMUNITY);
        list.add(GoodEndingStatusEffects.CONTEMPORARY_IMMUNITY);
        list.add(GoodEndingStatusEffects.SHATTERED_IMMUNITY);
    });

    @Inject(at={@At(value="HEAD")}, method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, cancellable=true)
    private void GE$addStatusEffect(MobEffectInstance effect, Entity source, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity $this = (LivingEntity)this;
        Supplier<MobEffect> finalResult = this.hierarchyResult($this, null);
        if (this.isHarmful(effect) && this.containsImmunity($this)) {
            if (finalResult != null) {
                IMMUNITY_HIERARCHY.stream().map(Supplier::get).filter(arg_0 -> ((LivingEntity)$this).m_21023_(arg_0)).toList().forEach(hierarchy -> {
                    MobEffectInstance instance = $this.m_21124_(hierarchy);
                    $this.m_21195_(hierarchy);
                    if (instance != null) {
                        if ($this instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)$this;
                            GoodEndingCriteriaTriggers.IMMUNITY.trigger(serverPlayer);
                        }
                        $this.m_7292_(new MobEffectInstance((MobEffect)finalResult.get(), instance.m_19557_(), instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_()));
                    }
                });
            } else {
                IMMUNITY_HIERARCHY.stream().map(Supplier::get).filter(arg_0 -> ((LivingEntity)$this).m_21023_(arg_0)).toList().forEach(arg_0 -> ((LivingEntity)$this).m_21195_(arg_0));
            }
            cir.setReturnValue((Object)false);
        }
        if (effect.m_19544_() == GoodEndingStatusEffects.STRONG_IMMUNITY.get()) {
            if (this.containsImmunity($this)) {
                cir.setReturnValue((Object)false);
            }
            $this.m_21220_().stream().filter(this::isHarmful).toList().forEach(statusEffectInstance -> {
                $this.m_21195_(statusEffectInstance.m_19544_());
                $this.m_7292_(new MobEffectInstance(this.hierarchyResult($this, () -> ((MobEffectInstance)effect).m_19544_()).get(), effect.m_19557_(), effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_()));
                if ($this instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)$this;
                    GoodEndingCriteriaTriggers.IMMUNITY.trigger(serverPlayer);
                }
                cir.setReturnValue((Object)true);
            });
        }
    }

    private boolean isHarmful(MobEffectInstance instance) {
        return instance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL;
    }

    private Supplier<MobEffect> hierarchyResult(LivingEntity $this, Supplier<MobEffect> finalResult) {
        for (int i = 0; i < IMMUNITY_HIERARCHY.size() - 1; ++i) {
            Supplier<MobEffect> statusEffect = IMMUNITY_HIERARCHY.get(i);
            if (!$this.m_21023_(statusEffect.get())) continue;
            finalResult = IMMUNITY_HIERARCHY.get(i + 1);
            break;
        }
        return finalResult;
    }

    private boolean containsImmunity(LivingEntity livingEntity) {
        return livingEntity.m_21023_((MobEffect)GoodEndingStatusEffects.STRONG_IMMUNITY.get()) || livingEntity.m_21023_((MobEffect)GoodEndingStatusEffects.CONTEMPORARY_IMMUNITY.get()) || livingEntity.m_21023_((MobEffect)GoodEndingStatusEffects.SHATTERED_IMMUNITY.get());
    }
}

