/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.init;

import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="goodending", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GoodEndingBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"goodending");
    public static final RegistryObject<Biome> MARSHY_SWAMP = BIOMES.register("marshy_swamp", GoodEndingBiomes::marshySwamp);
    public static final RegistryObject<Biome> OAK_HAMMOCK_FOREST = BIOMES.register("oak_hammock_forest", GoodEndingBiomes::oakHammockForest);
    public static final ResourceKey<Biome> OAK_HAMMOCK_FOREST_KEY = GoodEndingBiomes.registerResourceKey("oak_hammock_forest");
    public static final ResourceKey<Biome> MARSHY_SWAMP_KEY = GoodEndingBiomes.registerResourceKey("marshy_swamp");

    public static Biome oakHammockForest() {
        MobSpawnSettings.Builder builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)builder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)builder);
        BiomeGenerationSettings.Builder builder2 = new BiomeGenerationSettings.Builder();
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)builder2);
        Music musicSound = Musics.m_11653_((SoundEvent)SoundEvents.f_215731_);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.7f).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(GoodEndingBiomes.getSkyColor(0.7f)).m_48031_(BiomeSpecialEffects.GrassColorModifier.NONE).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(musicSound).m_48018_()).m_47605_(builder.m_48381_()).m_47601_(builder2.m_47831_()).m_47592_();
    }

    public static Biome marshySwamp() {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        mobspawnsettings$builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 1, 1, 1));
        mobspawnsettings$builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder();
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195417_);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195455_);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195466_);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195412_);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195413_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126753_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195222_);
        Music music = Musics.m_11653_((SoundEvent)SoundEvents.f_215730_);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.8f).m_47611_(0.9f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(6388580).m_48037_(2302743).m_48019_(12638463).m_48040_(GoodEndingBiomes.getSkyColor(0.8f)).m_48043_(10662207).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(mobspawnsettings$builder.m_48381_()).m_47601_(biomegenerationsettings$builder.m_47831_()).m_47592_();
    }

    protected static int getSkyColor(float temperature) {
        float value = temperature / 3.0f;
        value = Mth.m_14036_((float)value, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - value * 0.05f), (float)(0.5f + value * 0.1f), (float)1.0f);
    }

    private static ResourceKey<Biome> registerResourceKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("goodending", name));
    }
}

