/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.events;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.orcinus.goodending.entities.FireflyEntity;
import net.orcinus.goodending.entities.MarshEntity;
import net.orcinus.goodending.entities.WoodpeckerEntity;
import net.orcinus.goodending.init.GoodEndingEntityTypes;
import net.orcinus.goodending.init.GoodEndingStatusEffects;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="goodending", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MobEvents {
    private static final LinkedList<Supplier<MobEffect>> IMMUNITY_HIERARCHY = (LinkedList)Util.m_137469_((Object)Lists.newLinkedList(), list -> {
        list.add(GoodEndingStatusEffects.STRONG_IMMUNITY);
        list.add(GoodEndingStatusEffects.CONTEMPORARY_IMMUNITY);
        list.add(GoodEndingStatusEffects.SHATTERED_IMMUNITY);
    });

    @SubscribeEvent
    public static void registerEntityAttribute(EntityAttributeCreationEvent event) {
        event.put((EntityType)GoodEndingEntityTypes.MARSH.get(), MarshEntity.createMarshAttributes().m_22265_());
        event.put((EntityType)GoodEndingEntityTypes.FIREFLY_SWARM.get(), FireflyEntity.createFireflyAttributes().m_22265_());
        event.put((EntityType)GoodEndingEntityTypes.WOODPECKER.get(), WoodpeckerEntity.createWoodPeckerAttributes().m_22265_());
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Player player;
        ItemStack stack;
        LivingEntity $this = event.getEntity();
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof Player && (stack = (player = (Player)entity).m_21120_($this.m_7655_())).m_41783_() != null && (stack.m_41783_().m_128441_("Infinite") || stack.m_41783_().m_128441_("Potion")) && !(stack.m_41720_() instanceof PotionItem)) {
            PotionUtils.m_43577_((CompoundTag)stack.m_41783_()).m_43488_().stream().filter(this::isHarmful).toList().forEach(statusEffectInstance -> {
                if (stack.m_41783_().m_128451_("Amount") > 0) {
                    stack.m_41783_().m_128405_("Amount", stack.m_41783_().m_128451_("Amount") - 1);
                }
                $this.m_7292_(new MobEffectInstance(statusEffectInstance.m_19544_(), 200, statusEffectInstance.m_19564_(), statusEffectInstance.m_19571_(), statusEffectInstance.m_19572_(), statusEffectInstance.m_19575_()));
            });
        }
    }

    @SubscribeEvent
    public void onShieldBlock(ShieldBlockEvent event) {
        LivingEntity $this = event.getEntity();
        CompoundTag nbt = $this.m_21211_().m_41783_();
        if (nbt != null && (nbt.m_128471_("Infinite") || nbt.m_128451_("Amount") > 0) && nbt.m_128441_("Potion") && $this.m_21254_()) {
            Potion potion = PotionUtils.m_43579_((ItemStack)$this.m_21211_());
            potion.m_43488_().stream().filter(this::isBeneficial).toList().forEach(statusEffectInstance -> {
                MobEffect effectType;
                if ($this.m_21211_().m_41783_().m_128451_("Amount") > 0) {
                    nbt.m_128405_("Amount", nbt.m_128451_("Amount") - 1);
                }
                if ((effectType = statusEffectInstance.m_19544_()) == GoodEndingStatusEffects.STRONG_IMMUNITY.get() || effectType == GoodEndingStatusEffects.CONTEMPORARY_IMMUNITY.get()) {
                    effectType = (MobEffect)GoodEndingStatusEffects.SHATTERED_IMMUNITY.get();
                }
                $this.m_7292_(new MobEffectInstance(effectType, 200, statusEffectInstance.m_19564_(), statusEffectInstance.m_19571_(), statusEffectInstance.m_19572_(), statusEffectInstance.m_19575_()));
            });
        }
    }

    private boolean isBeneficial(MobEffectInstance instance) {
        return this.getCategory(instance) == MobEffectCategory.BENEFICIAL;
    }

    private boolean isHarmful(MobEffectInstance instance) {
        return this.getCategory(instance) == MobEffectCategory.HARMFUL;
    }

    @NotNull
    private MobEffectCategory getCategory(MobEffectInstance instance) {
        return instance.m_19544_().m_19483_();
    }
}

