/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.entities.ai;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.orcinus.goodending.entities.WoodpeckerEntity;
import net.orcinus.goodending.init.GoodEndingSoundEvents;

public class MoveToWoodGoal
extends Goal {
    private final WoodpeckerEntity woodpecker;
    private final RandomSource random;
    private final int initialPeckingTicks;
    private final int initialPeckingCooldownTicks;
    private boolean cancel = false;
    private int peckingTicks;
    private int peckingCooldownTicks;
    private int drummingTicks;

    public MoveToWoodGoal(WoodpeckerEntity woodpecker, RandomSource random) {
        this.woodpecker = woodpecker;
        this.random = random;
        this.initialPeckingTicks = 600 + random.m_188503_(2400);
        this.initialPeckingCooldownTicks = 40 + random.m_188503_(100);
    }

    public boolean m_8036_() {
        List woodpeckerEntities;
        BlockPos woodPos = this.woodpecker.getWoodPos();
        if (woodPos != null && (woodpeckerEntities = this.woodpecker.f_19853_.m_45976_(WoodpeckerEntity.class, new AABB(woodPos.m_121945_(this.woodpecker.getAttachedFace())))).size() > 1) {
            return false;
        }
        if (this.woodpecker.m_21188_() != null) {
            return false;
        }
        return this.woodpecker.getWoodPos() != null && this.woodpecker.f_19853_.m_8055_(this.woodpecker.getWoodPos()).m_204336_(BlockTags.f_13106_) && this.woodpecker.getPeckingWoodCooldown() == 0;
    }

    public void m_8056_() {
        super.m_8056_();
        if (this.woodpecker.hasWood()) {
            this.peckingTicks = this.initialPeckingTicks;
            this.peckingCooldownTicks = this.initialPeckingCooldownTicks;
        }
    }

    public boolean m_8045_() {
        List woodpeckerEntities;
        BlockPos woodPos = this.woodpecker.getWoodPos();
        if (woodPos != null && (woodpeckerEntities = this.woodpecker.f_19853_.m_45976_(WoodpeckerEntity.class, new AABB(woodPos.m_121945_(this.woodpecker.getAttachedFace())))).size() > 1 && this.peckingTicks == 100) {
            this.cancel = true;
            this.woodpecker.setPeckingWoodCooldown(200);
            return false;
        }
        if (this.woodpecker.m_21188_() != null) {
            return false;
        }
        if (this.cancel) {
            return false;
        }
        if (this.peckingTicks == 0) {
            return false;
        }
        return this.woodpecker.getWoodPos() != null && this.woodpecker.f_19853_.m_8055_(this.woodpecker.getWoodPos()).m_204336_(BlockTags.f_13106_);
    }

    public void m_8041_() {
        super.m_8041_();
        this.woodpecker.setWoodPos(null);
        this.woodpecker.setPeckingWoodCooldown(this.cancel ? 200 : 400);
        this.woodpecker.m_20124_(Pose.FALL_FLYING);
        this.peckingTicks = 600 + this.random.m_188503_(2400);
    }

    public void m_8037_() {
        BlockPos woodPos = this.woodpecker.getWoodPos();
        if (woodPos != null) {
            boolean flag;
            Direction attachedFace = this.woodpecker.getAttachedFace();
            boolean bl = flag = attachedFace == Direction.UP || attachedFace == Direction.DOWN;
            if (!flag) {
                Vec3 center = Vec3.m_82539_((Vec3i)woodPos.m_121945_(attachedFace));
                this.woodpecker.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)woodPos));
                if (this.woodpecker.m_20183_().m_203193_((Position)center) <= 3.0) {
                    center = Vec3.m_82539_((Vec3i)woodPos);
                }
                this.woodpecker.m_21573_().m_26519_(center.m_7096_(), center.m_7098_(), center.m_7094_(), (double)1.2f);
                double squaredDistance = Mth.m_14116_((float)((float)this.woodpecker.m_20183_().m_203193_((Position)Vec3.m_82539_((Vec3i)woodPos))));
                if (squaredDistance <= 1.2) {
                    BlockHitResult blockHitResult = this.woodpecker.f_19853_.m_151353_(new ClipBlockStateContext(this.woodpecker.m_20182_(), Vec3.m_82512_((Vec3i)woodPos), state -> state.m_204336_(BlockTags.f_13106_)));
                    this.woodpecker.m_20256_(Vec3.f_82478_);
                    this.woodpecker.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)woodPos));
                    if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
                        List woodpeckerEntities = this.woodpecker.f_19853_.m_45976_(WoodpeckerEntity.class, new AABB(woodPos.m_121945_(this.woodpecker.getAttachedFace())));
                        if (woodpeckerEntities.size() > 1 && this.peckingTicks > this.initialPeckingTicks - 10) {
                            this.cancel = true;
                        }
                        BlockPos pos = new BlockPos(Vec3.m_82539_((Vec3i)woodPos));
                        this.woodpecker.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)pos));
                        double xPosition = (double)pos.m_123341_() + (attachedFace.m_122434_() == Direction.Axis.Z ? 0.5 : (attachedFace == Direction.WEST ? -0.2 : 1.2));
                        double yPosition = (double)pos.m_123342_() + 0.25;
                        double zPosition = (double)pos.m_123343_() + (attachedFace.m_122434_() == Direction.Axis.X ? 0.5 : (attachedFace == Direction.NORTH ? -0.2 : 1.2));
                        float yaw = (float)(Mth.m_14136_((double)((double)pos.m_123343_() + 0.5 - this.woodpecker.m_20189_()), (double)((double)pos.m_123341_() + 0.5 - this.woodpecker.m_20185_())) * 57.29577951308232 - 90.0);
                        this.woodpecker.m_7678_(xPosition, yPosition, zPosition, this.woodpecker.m_146908_(), yaw);
                        this.woodpecker.m_5618_(yaw);
                        this.woodpecker.m_5616_(yaw);
                        this.woodpecker.m_21573_().m_26573_();
                        if (this.peckingTicks > 0) {
                            --this.peckingTicks;
                            --this.peckingCooldownTicks;
                            --this.drummingTicks;
                            this.woodpecker.m_20124_(Pose.STANDING);
                        }
                        if (this.drummingTicks < 0 || this.drummingTicks > 50) {
                            this.woodpecker.m_20124_(Pose.STANDING);
                        }
                        if (this.drummingTicks > 0 && this.drummingTicks < 50) {
                            this.woodpecker.m_20124_(Pose.DIGGING);
                        }
                        if (this.peckingCooldownTicks == 0) {
                            this.drummingTicks = 50;
                            this.woodpecker.m_5496_((SoundEvent)GoodEndingSoundEvents.ENTITY_WOODPECKER_DRUM.get(), 1.0f, 1.0f);
                            this.peckingCooldownTicks = 200 + this.random.m_188503_(300);
                        }
                        if (this.drummingTicks > 25 && this.drummingTicks < 40) {
                            this.peckWood(woodPos);
                        }
                    }
                } else if (this.woodpecker.m_21573_().m_26571_()) {
                    Path path = this.woodpecker.m_21573_().m_7864_(this.woodpecker.getWoodPos().m_121945_(this.woodpecker.getAttachedFace().m_122424_()).m_7495_(), 3);
                    this.woodpecker.m_21573_().m_26536_(path, (double)1.2f);
                }
            }
        }
    }

    private void peckWood(BlockPos woodPos) {
        BlockState blockState = this.woodpecker.f_19853_.m_8055_(woodPos);
        for (int i = 0; i < 10; ++i) {
            double d = (double)woodPos.m_123341_() + 0.5;
            double e = (double)woodPos.m_123342_() + 0.5;
            double f = (double)woodPos.m_123343_() + 0.5;
            ((ServerLevel)this.woodpecker.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), d, e, f, 1, 0.5, 0.25, 0.5, 0.0);
        }
    }
}

