/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.entities;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.orcinus.goodending.entities.ai.FindWoodGoal;
import net.orcinus.goodending.entities.ai.FlyAroundGoal;
import net.orcinus.goodending.entities.ai.MoveToWoodGoal;
import net.orcinus.goodending.init.GoodEndingSoundEvents;
import org.jetbrains.annotations.Nullable;

public class WoodpeckerEntity
extends PathfinderMob
implements FlyingAnimal {
    protected static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.m_135353_(WoodpeckerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    public float flapProgress;
    public float maxWingDeviation;
    public float prevMaxWingDeviation;
    public float prevFlapProgress;
    private float flapSpeed = 1.0f;
    private float field_28640 = 1.0f;
    private int peckingWoodCooldown;
    @Nullable
    public BlockPos woodPos;
    public final AnimationState peckingAnimationState = new AnimationState();
    public final AnimationState standingAnimationState = new AnimationState();
    public final AnimationState flyingAnimationState = new AnimationState();

    public WoodpeckerEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_20124_(Pose.FALL_FLYING);
    }

    public static AttributeSupplier.Builder createWoodPeckerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, (double)0.4f).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACHED_FACE, (Object)Direction.DOWN);
    }

    public Direction getAttachedFace() {
        return (Direction)this.f_19804_.m_135370_(ATTACHED_FACE);
    }

    public void setAttachedFace(Direction attachedFace) {
        this.f_19804_.m_135381_(ATTACHED_FACE, (Object)attachedFace);
    }

    public void m_7378_(CompoundTag nbt) {
        this.setWoodPos(null);
        if (nbt.m_128441_("WoodPos")) {
            this.setWoodPos(NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("WoodPos")));
        }
        this.setAttachedFace(Direction.m_122376_((int)nbt.m_128445_("AttachFace")));
        this.setPeckingWoodCooldown(nbt.m_128451_("PeckingWoodCooldownTicks"));
        super.m_7378_(nbt);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.hasWood()) {
            nbt.m_128365_("WoodPos", (Tag)NbtUtils.m_129224_((BlockPos)this.m_20183_()));
        }
        nbt.m_128344_("AttachFace", (byte)this.getAttachedFace().m_122411_());
        nbt.m_128405_("PeckingWoodCooldownTicks", this.getPeckingWoodCooldown());
    }

    public int getPeckingWoodCooldown() {
        return this.peckingWoodCooldown;
    }

    public void setPeckingWoodCooldown(int peckingWoodCooldown) {
        this.peckingWoodCooldown = peckingWoodCooldown;
    }

    public boolean hasWood() {
        return this.getWoodPos() != null;
    }

    public void setWoodPos(BlockPos blockPos) {
        this.woodPos = blockPos;
    }

    @Nullable
    public BlockPos getWoodPos() {
        return this.woodPos;
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            if (this.m_20089_() == Pose.FALL_FLYING) {
                this.flyingAnimationState.m_216982_(this.f_19797_);
            } else {
                this.flyingAnimationState.m_216973_();
            }
            if (this.m_20089_() == Pose.STANDING) {
                this.standingAnimationState.m_216982_(this.f_19797_);
            } else {
                this.standingAnimationState.m_216973_();
            }
            if (this.m_20089_() == Pose.DIGGING) {
                this.peckingAnimationState.m_216982_(this.f_19797_);
            } else {
                this.peckingAnimationState.m_216973_();
            }
        } else {
            if (this.getPeckingWoodCooldown() > 0) {
                this.setPeckingWoodCooldown(this.getPeckingWoodCooldown() - 1);
            }
            if (this.getWoodPos() == null && this.getAttachedFace() != Direction.DOWN) {
                this.setAttachedFace(Direction.DOWN);
            }
            if (this.getWoodPos() != null && !this.f_19853_.m_8055_(this.getWoodPos()).m_204336_(BlockTags.f_13106_)) {
                this.setWoodPos(null);
            }
        }
        super.m_8119_();
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world);
        birdNavigation.m_26443_(false);
        birdNavigation.m_7008_(true);
        birdNavigation.m_26440_(true);
        return birdNavigation;
    }

    public void m_8107_() {
        super.m_8107_();
        this.flapWings();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new FlyAroundGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FindWoodGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveToWoodGoal(this, this.f_19796_));
    }

    private void flapWings() {
        this.prevFlapProgress = this.flapProgress;
        this.prevMaxWingDeviation = this.maxWingDeviation;
        this.maxWingDeviation += (float)(this.f_19861_ || this.m_20159_() ? -1 : 4) * 0.3f;
        this.maxWingDeviation = Mth.m_14036_((float)this.maxWingDeviation, (float)0.0f, (float)1.0f);
        if (!this.f_19861_ && this.flapSpeed < 1.0f) {
            this.flapSpeed = 1.0f;
        }
        this.flapSpeed *= 0.9f;
        Vec3 vec3d = this.m_20184_();
        if (!this.f_19861_ && vec3d.f_82480_ < 0.0) {
            this.m_20256_(vec3d.m_82542_(1.0, 0.6, 1.0));
        }
        this.flapProgress += this.flapSpeed * 2.0f;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.field_28640;
    }

    protected float m_6121_() {
        return 0.5f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        String string;
        if (this.m_8077_() && "woody".equalsIgnoreCase(string = ChatFormatting.m_126649_((String)this.m_7755_().getString()))) {
            return (SoundEvent)GoodEndingSoundEvents.ENTITY_WOODPECKER_WOODY_IDLE.get();
        }
        return (SoundEvent)GoodEndingSoundEvents.ENTITY_WOODPECKER_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)GoodEndingSoundEvents.ENTITY_WOODPECKER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)GoodEndingSoundEvents.ENTITY_WOODPECKER_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12226_, 0.15f, 1.0f);
    }

    protected void m_142043_() {
        this.m_5496_((SoundEvent)GoodEndingSoundEvents.ENTITY_WOODPECKER_FLY.get(), 0.15f, 1.0f);
        this.field_28640 = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
    }

    public static boolean canSpawn(EntityType<WoodpeckerEntity> entityType, ServerLevelAccessor world, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184232_);
    }
}

