/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.client.models;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import net.orcinus.goodending.client.animations.WoodpeckerAnimations;
import net.orcinus.goodending.entities.WoodpeckerEntity;

public class WoodPeckerEntityModel
extends HierarchicalModel<WoodpeckerEntity> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart tail;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public WoodPeckerEntityModel(ModelPart root) {
        this.root = root;
        this.body = this.root.m_171324_("body");
        this.head = this.root.m_171324_("head");
        this.leftLeg = this.body.m_171324_("left_leg");
        this.rightLeg = this.body.m_171324_("right_leg");
        this.leftWing = this.body.m_171324_("left_wing");
        this.rightWing = this.body.m_171324_("right_wing");
        this.tail = this.body.m_171324_("tail");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition data = new MeshDefinition();
        PartDefinition root = data.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -4.0f, -3.0f, 4.0f, 4.0f, 5.0f).m_171514_(13, 0).m_171481_(-0.5f, -2.0f, -6.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-2.0f, -3.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)21.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(15, 6).m_171481_(0.0f, 0.0f, -1.5f, 1.0f, 4.0f, 3.0f), PartPose.m_171423_((float)2.0f, (float)-3.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightWing = body.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(15, 6).m_171555_(true).m_171481_(-1.0f, 0.0f, -1.5f, 1.0f, 4.0f, 3.0f), PartPose.m_171423_((float)-2.0f, (float)-3.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-1.0f, -0.5f, 0.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171481_(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f).m_171514_(-1, 20).m_171481_(-0.5f, 2.0f, -1.5f, 1.0f, 0.0f, 3.0f), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171555_(true).m_171481_(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f).m_171514_(-1, 20).m_171555_(true).m_171481_(-0.5f, 2.0f, -1.5f, 1.0f, 0.0f, 3.0f), PartPose.m_171423_((float)-1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)data, (int)32, (int)32);
    }

    public void setupAnim(WoodpeckerEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        limbDistance = Mth.m_14036_((float)limbDistance, (float)-0.45f, (float)0.45f);
        if (entity.m_20089_() != Pose.STANDING && entity.m_20089_() != Pose.DIGGING) {
            this.setHeadAngle(headYaw, headPitch);
        }
        this.setBodyAngles(limbDistance);
        this.m_233381_(entity.standingAnimationState, WoodpeckerAnimations.WOODPECKER_STANDING, animationProgress);
        this.m_233381_(entity.flyingAnimationState, WoodpeckerAnimations.WOODPECKER_FLY, animationProgress);
        this.m_233381_(entity.peckingAnimationState, WoodpeckerAnimations.WOODPECKER_PECK, animationProgress);
    }

    private void setBodyAngles(float limbDistance) {
        float tilt = Math.min(limbDistance / 0.3f, 1.0f);
        this.body.f_104203_ += tilt * 0.7f;
        this.head.f_104202_ += tilt * -2.5f + 1.0f;
        this.head.f_104201_ += tilt * 0.5f;
        this.tail.f_104203_ += tilt * -1.0f;
    }

    private void setHeadAngle(float yaw, float pitch) {
        this.head.f_104203_ = pitch * ((float)Math.PI / 180);
        this.head.f_104204_ = yaw * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

