/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.blocks;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.goodending.init.GoodEndingParticleTypes;
import net.orcinus.goodending.init.GoodEndingSoundEvents;

public class FireflyLanternBlock
extends LanternBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    protected static final VoxelShape STANDING_SHAPE = Stream.of(FireflyLanternBlock.m_49796_((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0), FireflyLanternBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), FireflyLanternBlock.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public FireflyLanternBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return STANDING_SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        world.m_7731_(pos, (BlockState)state.m_61122_((Property)OPEN), 2);
        world.m_5594_(null, pos, (Boolean)state.m_61143_((Property)OPEN) != false ? (SoundEvent)GoodEndingSoundEvents.BLOCK_FIREFLY_LANTERN_CLOSE.get() : (SoundEvent)GoodEndingSoundEvents.BLOCK_FIREFLY_LANTERN_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        world.m_142346_((Entity)player, (Boolean)state.m_61143_((Property)OPEN) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        boolean flag;
        boolean bl = flag = (Boolean)state.m_61143_((Property)OPEN) != false && (!world.m_45527_(pos) || world.m_46468_() >= 13000L && world.m_46468_() < 24000L);
        if (flag) {
            this.addExteriorFireflies(state, world, pos, random);
        } else {
            this.addInteriorFireflies(state, world, pos, random);
        }
    }

    private void addExteriorFireflies(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int i = pos.m_123341_();
        int j = pos.m_123342_() + ((Boolean)state.m_61143_((Property)f_153459_) != false ? -1 : 6);
        int k = pos.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int l = 0; l < 10; ++l) {
            mutable.m_122178_(i + Mth.m_216271_((RandomSource)random, (int)-6, (int)6), j - random.m_188503_(6), k + Mth.m_216271_((RandomSource)random, (int)-6, (int)6));
            BlockState blockState = world.m_8055_((BlockPos)mutable);
            if (blockState.m_60838_((BlockGetter)world, (BlockPos)mutable)) continue;
            double velx = random.m_188583_() * 0.025;
            double vely = random.m_188583_() * 0.025;
            double velz = random.m_188583_() * 0.025;
            world.m_7106_((ParticleOptions)GoodEndingParticleTypes.FIREFLY.get(), (double)mutable.m_123341_() + random.m_188500_(), (double)mutable.m_123342_() + random.m_188500_(), (double)mutable.m_123343_() + random.m_188500_(), velx, vely, velz);
        }
    }

    private void addInteriorFireflies(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        double xVelocity = random.m_188501_() / 45.0f * (float)(random.m_188499_() ? -1 : 1);
        double yVelocity = random.m_188501_() / 100.0f * (float)((Boolean)state.m_61143_((Property)f_153459_) != false ? 2 : -1);
        double zVelocity = random.m_188501_() / 45.0f * (float)(random.m_188499_() ? -1 : 1);
        world.m_7106_((ParticleOptions)GoodEndingParticleTypes.FIREFLY.get(), x, y + 0.4, z, xVelocity, yVelocity, zVelocity);
    }
}

