/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import umpaz.farmersrespite.common.block.CoffeeCakeBlock;
import umpaz.farmersrespite.common.registry.FRBlocks;
import umpaz.farmersrespite.common.registry.FREffects;
import umpaz.farmersrespite.common.registry.FRItems;
import vectorwing.farmersdelight.common.tag.ModTags;

public class CandleCoffeeCakeBlock
extends AbstractCandleBlock {
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    protected static final VoxelShape CAKE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final VoxelShape CANDLE_SHAPE = Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)CAKE_SHAPE, (VoxelShape)CANDLE_SHAPE);
    private static final Map<Pair<Block, CoffeeCakeBlock>, CandleCoffeeCakeBlock> BY_CANDLE_AND_CAKE = Maps.newHashMap();
    private static final Iterable<Vec3> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));
    private final Block candle;

    public CandleCoffeeCakeBlock(Block candle, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
        this.candle = candle;
        BY_CANDLE_AND_CAKE.put((Pair<Block, CoffeeCakeBlock>)Pair.of((Object)candle, (Object)((Object)((CoffeeCakeBlock)((Object)FRBlocks.COFFEE_CAKE.get())))), this);
    }

    protected Iterable<Vec3> m_142199_(BlockState p_152868_) {
        return PARTICLE_OFFSETS;
    }

    public VoxelShape m_5940_(BlockState p_152875_, BlockGetter p_152876_, BlockPos p_152877_, CollisionContext p_152878_) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Object object;
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_150930_(Items.f_42409_) && !itemstack.m_150930_(Items.f_42613_) && (object = FRBlocks.COFFEE_CAKE.get()) instanceof CoffeeCakeBlock) {
            CoffeeCakeBlock cakeBlock = (CoffeeCakeBlock)((Object)object);
            if (CandleCoffeeCakeBlock.candleHit(result) && player.m_21120_(hand).m_41619_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                CandleCoffeeCakeBlock.m_151899_((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (itemstack.m_204117_(ModTags.KNIVES)) {
                return this.cutSlice(level, pos, state, player);
            }
            return this.eatSlice(level, pos, state, player);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult eatSlice(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        player.m_36220_(Stats.f_12942_);
        player.m_36324_().m_38707_(2, 0.1f);
        if (!level.m_5776_()) {
            player.m_7292_(new MobEffectInstance((MobEffect)FREffects.CAFFEINATED.get(), 600, 0));
        }
        level.m_142346_((Entity)player, GameEvent.f_157806_, pos);
        level.m_7731_(pos, (BlockState)((Block)FRBlocks.COFFEE_CAKE.get()).m_49966_().m_61124_((Property)CoffeeCakeBlock.f_51180_, (Comparable)Integer.valueOf(1)), 3);
        Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        level.m_7731_(pos, (BlockState)((Block)FRBlocks.COFFEE_CAKE.get()).m_49966_().m_61124_((Property)CoffeeCakeBlock.f_51180_, (Comparable)Integer.valueOf(1)), 3);
        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)FRItems.COFFEE_CAKE_SLICE.get()));
        Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)FRBlocks.COFFEE_CAKE.get());
    }

    private static boolean candleHit(BlockHitResult result) {
        return result.m_82450_().f_82480_ - (double)result.m_82425_().m_123342_() > 0.5;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_152905_) {
        p_152905_.m_61104_(new Property[]{LIT});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState p_152900_, LevelAccessor p_152901_, BlockPos p_152902_, BlockPos p_152903_) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)p_152901_, p_152902_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, p_152900_, p_152901_, p_152902_, p_152903_);
    }

    public boolean m_7898_(BlockState p_152891_, LevelReader p_152892_, BlockPos p_152893_) {
        return p_152892_.m_8055_(p_152893_.m_7495_()).m_60767_().m_76333_();
    }

    public int m_6782_(BlockState p_152880_, Level p_152881_, BlockPos p_152882_) {
        return CakeBlock.f_152743_;
    }

    public boolean m_7278_(BlockState p_152909_) {
        return true;
    }

    public boolean m_7357_(BlockState p_152870_, BlockGetter p_152871_, BlockPos p_152872_, PathComputationType p_152873_) {
        return false;
    }

    public static BlockState byCandle(Block candle, CoffeeCakeBlock cake) {
        return BY_CANDLE_AND_CAKE.get(Pair.of((Object)candle, (Object)((Object)cake))).m_49966_();
    }

    public Block getCandle() {
        return this.candle;
    }
}

