/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.util;

import com.mojang.blaze3d.platform.NativeImage;
import de.cheaterpaul.fallingleaves.FallingLeavesMod;
import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import de.cheaterpaul.fallingleaves.init.FallingLeavesConfig;
import de.cheaterpaul.fallingleaves.init.Leaves;
import de.cheaterpaul.fallingleaves.mixin.NativeImageAccessor;
import de.cheaterpaul.fallingleaves.mixin.TextureAtlasSpriteAccessor;
import de.cheaterpaul.fallingleaves.particle.FallingLeafParticle;
import de.cheaterpaul.fallingleaves.util.TextureCache;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class LeafUtil {
    private static final Logger LOGGER = LogManager.getLogger(FallingLeavesMod.class);
    private static final RandomSource renderRandom = RandomSource.m_216327_();

    public static void trySpawnLeafParticle(BlockState state, Level world, BlockPos pos, RandomSource random, @Nullable LeafSettingsEntry leafSettings) {
        double b;
        double g;
        Minecraft client;
        BakedModel model;
        ModelData modelData;
        double[] color;
        double r;
        FallingLeafParticle.DefaultFactory provider;
        Particle particle;
        double z;
        double y;
        double x = (double)pos.m_123341_() + random.m_188500_();
        if (LeafUtil.shouldSpawnParticle(world, pos, x, y = (double)pos.m_123342_() - random.m_188500_() / 3.0, z = (double)pos.m_123343_() + random.m_188500_()) && (particle = (provider = leafSettings == null || !leafSettings.isConiferBlock ? Leaves.falling_leaf : Leaves.falling_leaf_conifer).m_6966_(null, (ClientLevel)world, x, y, z, r = (color = LeafUtil.getBlockTextureColor(state, world, pos, modelData = (model = (client = Minecraft.m_91087_()).m_91289_().m_110910_(state)).getModelData((BlockAndTintGetter)world, pos, state, ModelData.EMPTY)))[0], g = color[1], b = color[2])) != null) {
            Minecraft.m_91087_().f_91061_.m_107344_(particle);
        }
    }

    private static boolean shouldSpawnParticle(Level world, BlockPos pos, double x, double y, double z) {
        if (LeafUtil.isLeafBlock(world.m_8055_(pos.m_7495_()), true)) {
            return false;
        }
        double y2 = y - (double)((Integer)FallingLeavesConfig.CONFIG.minimumFreeSpaceBelow.get()).intValue() * 0.5;
        AABB collisionBox = new AABB(x - 0.1, y, z - 0.1, x + 0.1, y2, z + 0.1);
        return !world.m_186434_(null, collisionBox).iterator().hasNext();
    }

    public static boolean isLeafBlock(BlockState block, boolean useBlockTags) {
        return block.m_60734_() instanceof LeavesBlock || useBlockTags && block.m_204336_(BlockTags.f_13035_);
    }

    public static double[] averageColor(NativeImage image) {
        if (image.m_85102_() != NativeImage.Format.RGBA) {
            LOGGER.error("RGBA image required, was {}", (Object)image.m_85102_());
            return new double[]{1.0, 1.0, 1.0};
        }
        long pixels = ((NativeImageAccessor)image).getPixels();
        if (pixels == 0L) {
            LOGGER.error("image is not allocated");
            return new double[]{1.0, 1.0, 1.0};
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = 0;
        int width = image.m_84982_();
        int height = image.m_85084_();
        for (int i = 0; i < width * height; ++i) {
            int c = MemoryUtil.memGetInt((long)(pixels + 4L * (long)i));
            int cr = c & 0xFF;
            int cg = c >> 8 & 0xFF;
            int cb = c >> 16 & 0xFF;
            int ca = c >> 24 & 0xFF;
            if (ca == 0) continue;
            r += (double)cr;
            g += (double)cg;
            b += (double)cb;
            ++n;
        }
        return new double[]{r / (double)n / 255.0, g / (double)n / 255.0, b / (double)n / 255.0};
    }

    public static ResourceLocation spriteToTexture(TextureAtlasSprite sprite) {
        String texture = sprite.m_118413_().m_135815_();
        return new ResourceLocation(sprite.m_118413_().m_135827_(), "textures/" + texture + ".png");
    }

    public static double[] getBlockTextureColor(BlockState state, Level world, BlockPos pos, ModelData modelData) {
        boolean shouldColor;
        TextureAtlasSprite sprite;
        Minecraft client = Minecraft.m_91087_();
        BakedModel model = client.m_91289_().m_110910_(state);
        renderRandom.m_188584_(state.m_60726_(pos));
        List quads = model.getQuads(state, Direction.DOWN, renderRandom, modelData, RenderType.m_110463_());
        if (!quads.isEmpty()) {
            BakedQuad quad = (BakedQuad)quads.get(0);
            sprite = quad.m_173410_();
            shouldColor = quad.m_111304_();
        } else {
            sprite = model.getParticleIcon(modelData);
            shouldColor = true;
        }
        ResourceLocation spriteId = sprite.m_118413_();
        NativeImage texture = ((TextureAtlasSpriteAccessor)sprite).getMainImage()[0];
        int blockColor = shouldColor ? client.m_91298_().m_92577_(state, (BlockAndTintGetter)world, pos, 0) : -1;
        return LeafUtil.calculateLeafColor(spriteId, texture, blockColor);
    }

    private static double[] calculateLeafColor(ResourceLocation spriteId, NativeImage texture, int blockColor) {
        double[] textureColor = TextureCache.INST.computeIfAbsent(spriteId, loc -> {
            double[] doubles = LeafUtil.averageColor(texture);
            LogManager.getLogger().debug("{}: Calculated texture color {} ", (Object)spriteId, (Object)doubles);
            return new TextureCache.Data(doubles);
        }).getColor();
        if (blockColor != -1) {
            textureColor[0] = textureColor[0] * ((double)(blockColor >> 16 & 0xFF) / 255.0);
            textureColor[1] = textureColor[1] * ((double)(blockColor >> 8 & 0xFF) / 255.0);
            textureColor[2] = textureColor[2] * ((double)(blockColor & 0xFF) / 255.0);
        }
        return textureColor;
    }
}

