/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TreeValueLoader
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    private Map<ResourceLocation, LeafSettingsEntry> treeLeaveSizeValues = new HashMap<ResourceLocation, LeafSettingsEntry>();

    public TreeValueLoader() {
        super(GSON, "fallingleaves");
    }

    protected void apply(Map<ResourceLocation, JsonElement> values, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, LeafSettingsEntry> map = new HashMap<ResourceLocation, LeafSettingsEntry>();
        values.forEach((id, json) -> {
            try {
                JsonObject object = GsonHelper.m_13918_((JsonElement)json, (String)"leafsettings");
                double spawnrate = 1.0;
                if (object.has("spawnrate")) {
                    spawnrate = object.get("spawnrate").getAsDouble();
                }
                boolean isConifer = false;
                if (object.has("isConifer")) {
                    isConifer = object.get("isConifer").getAsBoolean();
                }
                map.put((ResourceLocation)id, new LeafSettingsEntry((ResourceLocation)id, spawnrate, isConifer));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.error("Parsing error loading leaf settings {}: {}", json, (Object)e.getMessage());
            }
        });
        this.treeLeaveSizeValues = map;
    }

    @Nullable
    public LeafSettingsEntry getLeafSetting(ResourceLocation loc) {
        return this.treeLeaveSizeValues.get(loc);
    }

    @Nonnull
    public Collection<LeafSettingsEntry> getALlSettings() {
        return this.treeLeaveSizeValues.values();
    }
}

