/*
 * Decompiled with CFR 0.152.
 */
package io.sigpipe.jbsdiff.sort;

import io.sigpipe.jbsdiff.sort.SearchResult;

public class SuffixSort {
    public static void qsufsort(int[] I, int[] V, byte[] data) {
        int i;
        int[] buckets = new int[256];
        for (i = 0; i < data.length; ++i) {
            int n = data[i] & 0xFF;
            buckets[n] = buckets[n] + 1;
        }
        for (i = 1; i < 256; ++i) {
            int n = i;
            buckets[n] = buckets[n] + buckets[i - 1];
        }
        for (i = 255; i > 0; --i) {
            buckets[i] = buckets[i - 1];
        }
        buckets[0] = 0;
        i = 0;
        while (i < data.length) {
            int n = data[i] & 0xFF;
            int n2 = buckets[n] + 1;
            buckets[n] = n2;
            I[n2] = i++;
        }
        I[0] = data.length;
        for (i = 0; i < data.length; ++i) {
            V[i] = buckets[data[i] & 0xFF];
        }
        V[data.length] = 0;
        for (i = 1; i < 256; ++i) {
            if (buckets[i] != buckets[i - 1] + 1) continue;
            I[buckets[i]] = -1;
        }
        I[0] = -1;
        int h = 1;
        while (I[0] != -(data.length + 1)) {
            int len = 0;
            i = 0;
            while (i < data.length + 1) {
                if (I[i] < 0) {
                    len -= I[i];
                    i -= I[i];
                    continue;
                }
                if (len != 0) {
                    I[i - len] = -len;
                }
                len = V[I[i]] + 1 - i;
                SuffixSort.split(I, V, i, len, h);
                i += len;
                len = 0;
            }
            if (len != 0) {
                I[i - len] = -len;
            }
            h += h;
        }
        for (i = 0; i < data.length + 1; ++i) {
            I[V[i]] = i;
        }
    }

    public static void split(int[] I, int[] V, int start, int len, int h) {
        int tmp;
        int i;
        if (len < 16) {
            int j;
            for (int k = start; k < start + len; k += j) {
                j = 1;
                int x = V[I[k] + h];
                int i2 = 1;
                while (k + i2 < start + len) {
                    if (V[I[k + i2] + h] < x) {
                        x = V[I[k + i2] + h];
                        j = 0;
                    }
                    if (V[I[k + i2] + h] == x) {
                        int tmp2 = I[k + j];
                        I[k + j] = I[k + i2];
                        I[k + i2] = tmp2;
                        ++j;
                    }
                    ++i2;
                }
                for (i2 = 0; i2 < j; ++i2) {
                    V[I[k + i2]] = k + j - 1;
                }
                if (j != 1) continue;
                I[k] = -1;
            }
            return;
        }
        int x = V[I[start + len / 2] + h];
        int jj = 0;
        int kk = 0;
        for (i = start; i < start + len; ++i) {
            if (V[I[i] + h] < x) {
                ++jj;
            }
            if (V[I[i] + h] != x) continue;
            ++kk;
        }
        kk += (jj += start);
        i = start;
        int j = 0;
        int k = 0;
        while (i < jj) {
            if (V[I[i] + h] < x) {
                ++i;
                continue;
            }
            if (V[I[i] + h] == x) {
                tmp = I[i];
                I[i] = I[jj + j];
                I[jj + j] = tmp;
                ++j;
                continue;
            }
            tmp = I[i];
            I[i] = I[kk + k];
            I[kk + k] = tmp;
            ++k;
        }
        while (jj + j < kk) {
            if (V[I[jj + j] + h] == x) {
                ++j;
                continue;
            }
            tmp = I[jj + j];
            I[jj + j] = I[kk + k];
            I[kk + k] = tmp;
            ++k;
        }
        if (jj > start) {
            SuffixSort.split(I, V, start, jj - start, h);
        }
        for (i = 0; i < kk - jj; ++i) {
            V[I[jj + i]] = kk - 1;
        }
        if (jj == kk - 1) {
            I[jj] = -1;
        }
        if (start + len > kk) {
            SuffixSort.split(I, V, kk, start + len - kk, h);
        }
    }

    private static int matchLength(byte[] bytesA, int offsetA, byte[] bytesB, int offsetB) {
        int i;
        int oldLimit = bytesA.length - offsetA;
        int newLimit = bytesB.length - offsetB;
        for (i = 0; i < oldLimit && i < newLimit && bytesA[i + offsetA] == bytesB[i + offsetB]; ++i) {
        }
        return i;
    }

    public static SearchResult search(int[] I, byte[] oldBytes, int oldOffset, byte[] newBytes, int newOffset, int start, int end) {
        if (end - start < 2) {
            int y;
            int x = SuffixSort.matchLength(oldBytes, I[start], newBytes, newOffset);
            if (x > (y = SuffixSort.matchLength(oldBytes, I[end], newBytes, newOffset))) {
                return new SearchResult(x, I[start]);
            }
            return new SearchResult(y, I[end]);
        }
        int center = start + (end - start) / 2;
        if (SuffixSort.compareBytes(oldBytes, I[center], newBytes, newOffset) < 0) {
            return SuffixSort.search(I, oldBytes, 0, newBytes, newOffset, center, end);
        }
        return SuffixSort.search(I, oldBytes, 0, newBytes, newOffset, start, center);
    }

    private static int compareBytes(byte[] bytesA, int offsetA, byte[] bytesB, int offsetB) {
        int length = Math.min(bytesA.length - offsetA, bytesB.length - offsetB);
        int valA = 0;
        int valB = 0;
        for (int i = 0; i < length && (valA = bytesA[i + offsetA] & 0xFF) == (valB = bytesB[i + offsetB] & 0xFF); ++i) {
        }
        return valA - valB;
    }
}

