/*
 * Decompiled with CFR 0.152.
 */
package de.isuewo.euphoria_patcher;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ArchiveUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extract(Path in, Path out) throws IOException, ArchiveException {
        if (!Files.exists(out, new LinkOption[0])) {
            Files.createDirectory(out, new FileAttribute[0]);
        }
        try (ArchiveInputStream ai = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(in, StandardOpenOption.READ)));){
            ArchiveEntry entry;
            while ((entry = ai.getNextEntry()) != null) {
                if (!ai.canReadEntryData(entry)) continue;
                Path targetFilePath = out.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectory(targetFilePath, new FileAttribute[0]);
                    continue;
                }
                Path parent = targetFilePath.getParent();
                if (!Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                OutputStream o = Files.newOutputStream(targetFilePath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                try {
                    IOUtils.copy((InputStream)ai, (OutputStream)o);
                }
                finally {
                    if (o == null) continue;
                    o.close();
                }
            }
            return;
        }
    }

    public static void archive(Path sourceDir, Path archive) throws IOException {
        List filesToArchive = Files.walk(sourceDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted().collect(Collectors.toList());
        try (TarArchiveOutputStream o = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(archive, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING)));){
            for (Path f : filesToArchive) {
                TarArchiveEntry entry = new TarArchiveEntry(f.toFile(), sourceDir.relativize(f).toString());
                entry.setModTime(0L);
                entry.setIds(0, 0);
                entry.setNames("", "");
                o.putArchiveEntry((ArchiveEntry)entry);
                if (Files.isRegularFile(f, new LinkOption[0])) {
                    try (InputStream i = Files.newInputStream(f, StandardOpenOption.READ);){
                        IOUtils.copy((InputStream)i, (OutputStream)o);
                    }
                }
                o.closeArchiveEntry();
            }
            o.finish();
        }
    }
}

