/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.epherolib.lang;

import com.epherical.epherolib.config.LanguageConfig;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.chat.contents.TranslatableFormatException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class ServerTranslation
extends TranslatableContents {
    private static final Object[] NO_ARGS = new Object[0];
    private final Language language;
    private List<FormattedText> decomposedParts = ImmutableList.of();
    private static final FormattedText TEXT_PERCENT = FormattedText.m_130775_((String)"%");
    private static final FormattedText TEXT_NULL = FormattedText.m_130775_((String)"null");
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public ServerTranslation(Language language, String key, Object[] args) {
        super(key, args);
        this.language = language;
    }

    protected void decomposePieces() {
        String msg = this.language.m_6834_(this.m_237508_());
        try {
            ImmutableList.Builder builder = ImmutableList.builder();
            Objects.requireNonNull(builder);
            this.m_237515_(msg, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.decomposedParts = builder.build();
        }
        catch (TranslatableFormatException e) {
            this.decomposedParts = ImmutableList.of((Object)FormattedText.m_130775_((String)msg));
        }
    }

    private void m_237515_(String string, Consumer<FormattedText> consumer) {
        Matcher matcher = FORMAT_PATTERN.matcher(string);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                String string2;
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    string2 = string.substring(j, k);
                    if (string2.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    consumer.accept(FormattedText.m_130775_((String)string2));
                }
                string2 = matcher.group(2);
                String string3 = string.substring(k, l);
                if ("%".equals(string2) && "%%".equals(string3)) {
                    consumer.accept(TEXT_PERCENT);
                } else {
                    if (!"s".equals(string2)) {
                        throw new TranslatableFormatException((TranslatableContents)this, "Unsupported format: '" + string3 + "'");
                    }
                    String string4 = matcher.group(1);
                    int m = string4 != null ? Integer.parseInt(string4) - 1 : i++;
                    consumer.accept(this.argument(m));
                }
                j = l;
            }
            if (j < string.length()) {
                String string5 = string.substring(j);
                if (string5.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                consumer.accept(FormattedText.m_130775_((String)string5));
            }
        }
        catch (IllegalArgumentException var12) {
            throw new TranslatableFormatException((TranslatableContents)this, (Throwable)var12);
        }
    }

    public FormattedText argument(int i) {
        if (i >= 0 && i < this.m_237523_().length) {
            Object object = this.m_237523_()[i];
            if (object instanceof Component) {
                return (Component)object;
            }
            return object == null ? TEXT_NULL : FormattedText.m_130775_((String)object.toString());
        }
        throw new TranslatableFormatException((TranslatableContents)this, i);
    }

    public <T> Optional<T> m_213724_(FormattedText.StyledContentConsumer<T> styledContentConsumer, Style style) {
        this.decomposePieces();
        Optional optional = Optional.empty();
        for (FormattedText decomposedPart : this.decomposedParts) {
            optional = decomposedPart.m_7451_(styledContentConsumer, style);
        }
        return optional;
    }

    public <T> Optional<T> m_213874_(FormattedText.ContentConsumer<T> contentConsumer) {
        this.decomposePieces();
        Optional optional = Optional.empty();
        for (FormattedText decomposedPart : this.decomposedParts) {
            optional = decomposedPart.m_5651_(contentConsumer);
        }
        return optional;
    }

    public MutableComponent m_213698_(@Nullable CommandSourceStack commandSourceStack, @Nullable Entity entity, int i) throws CommandSyntaxException {
        Object[] objects = new Object[this.m_237523_().length];
        for (int j = 0; j < objects.length; ++j) {
            Object object = this.m_237523_()[j];
            objects[j] = object instanceof Component ? ComponentUtils.m_130731_((CommandSourceStack)commandSourceStack, (Component)((Component)object), (Entity)entity, (int)i) : object;
        }
        return MutableComponent.m_237204_((ComponentContents)new ServerTranslation(this.language, this.m_237508_(), objects));
    }

    public static MutableComponent translatable(ServerPlayer player, String key) {
        return MutableComponent.m_237204_((ComponentContents)new ServerTranslation(LanguageConfig.getLanguage(player), key, NO_ARGS));
    }

    public static MutableComponent translatable(ServerPlayer player, String key, Object ... args) {
        return MutableComponent.m_237204_((ComponentContents)new ServerTranslation(LanguageConfig.getLanguage(player), key, args));
    }

    public static MutableComponent translatableWithFallback(ServerPlayer player, String key, @Nullable String fallback) {
        return MutableComponent.m_237204_((ComponentContents)new ServerTranslation(LanguageConfig.getLanguage(player), key, NO_ARGS));
    }

    public static MutableComponent translatableWithFallback(ServerPlayer player, String key, @Nullable String fallback, Object ... args) {
        return MutableComponent.m_237204_((ComponentContents)new ServerTranslation(LanguageConfig.getLanguage(player), key, args));
    }
}

