/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.client;

import com.aizistral.enigmaticlegacy.client.Quote;
import com.aizistral.enigmaticlegacy.client.Subtitles;
import com.aizistral.enigmaticlegacy.config.OmniconfigHandler;
import com.aizistral.enigmaticlegacy.gui.GUIUtils;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class QuoteHandler {
    public static final QuoteHandler INSTANCE = new QuoteHandler();
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private Quote currentQuote = null;
    private long startedPlaying = -1L;
    private int delayTicks = -1;
    private boolean shownExperimentalInfo = false;

    private QuoteHandler() {
    }

    private double getPlayTime() {
        long millis = System.currentTimeMillis() - this.startedPlaying;
        return (double)millis / 1000.0;
    }

    public void playQuote(Quote quote, int delayTicks) {
        if (this.currentQuote == null) {
            this.currentQuote = quote;
            this.delayTicks = delayTicks;
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player == Minecraft.m_91087_().f_91074_ && this.delayTicks > 0 && !(Minecraft.m_91087_().f_91080_ instanceof LevelLoadingScreen) && !(Minecraft.m_91087_().f_91080_ instanceof ReceivingLevelScreen)) {
            --this.delayTicks;
            if (this.delayTicks == 0) {
                SimpleSoundInstance instance = new SimpleSoundInstance(this.currentQuote.getSound().m_11660_(), SoundSource.VOICE, 0.7f, 1.0f, RANDOM, false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)instance);
                this.startedPlaying = System.currentTimeMillis();
            }
        }
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGuiEvent.Post event) {
        if (Minecraft.m_91087_().f_91080_ != null || this.currentQuote == null || this.delayTicks > 0) {
            return;
        }
        this.drawQuote(event.getPoseStack(), event.getWindow());
    }

    @SubscribeEvent
    public void onScreenRender(ScreenEvent.Render.Post event) {
        if (this.currentQuote != null && this.delayTicks <= 0) {
            this.drawQuote(event.getPoseStack(), Minecraft.m_91087_().m_91268_());
            Minecraft.m_91087_().m_91106_().m_120407_();
        }
    }

    private void sendExperimentalInfo(Player player) {
    }

    private void drawQuote(PoseStack stack, Window window) {
        if (this.currentQuote.getSubtitles().getDuration() - this.getPlayTime() <= 0.1) {
            if (Quote.NARRATOR_INTROS.contains(this.currentQuote) && Minecraft.m_91087_().f_91074_ != null) {
                this.sendExperimentalInfo((Player)Minecraft.m_91087_().f_91074_);
            }
            this.currentQuote = null;
            this.delayTicks = -1;
            this.startedPlaying = -1;
            return;
        }
        if (this.getPlayTime() < 0.05) {
            return;
        }
        if (OmniconfigHandler.disableQuoteSubtitles.getValue()) {
            return;
        }
        Subtitles subtitles = this.currentQuote.getSubtitles();
        Font font = Minecraft.m_91087_().f_91062_;
        String[] text = SuperpositionHandler.wrapString(subtitles.getLine(this.getPlayTime()), font, 260);
        int alphaMod = 255;
        if (this.getPlayTime() < 0.5) {
            alphaMod = (int)((double)alphaMod * (this.getPlayTime() / 0.5));
        } else if (this.currentQuote.getSubtitles().getDuration() - this.getPlayTime() < 0.5) {
            alphaMod = (int)((double)alphaMod * ((this.currentQuote.getSubtitles().getDuration() - this.getPlayTime()) / 0.5));
        }
        if (alphaMod < 0) {
            alphaMod = 255;
        }
        int width = window.m_85445_() / 2 - SuperpositionHandler.greatestWidth(font, text) / 2;
        int n = window.m_85446_() - 70;
        Objects.requireNonNull(font);
        int height = n - (9 + 2) * (text.length - 1);
        stack.m_85836_();
        stack.m_85841_(1.0f, 1.0f, 1.0f);
        int fromX = width;
        int fromY = height;
        int toX = fromX + SuperpositionHandler.greatestWidth(font, text);
        Objects.requireNonNull(font);
        int toY = fromY + 9 * text.length + 2 * text.length - 1;
        int color1 = 0 | (int)((double)alphaMod * 0.266) << 24;
        int color2 = ChatFormatting.YELLOW.m_126665_() | alphaMod << 24;
        GUIUtils.drawGradientRect(stack.m_85850_().m_85861_(), 0, fromX - 4, fromY - 4, toX + 4, toY + 4, color1, color1);
        GUIUtils.drawGradientRect(stack.m_85850_().m_85861_(), 0, fromX - 6, fromY - 6, toX + 6, toY + 6, color1, color1);
        GUIUtils.drawGradientRect(stack.m_85850_().m_85861_(), 0, fromX - 8, fromY - 8, toX + 8, toY + 8, color1, color1);
        int counter = 0;
        for (String line : text) {
            float f = window.m_85445_() / 2 - font.m_92895_(line) / 2;
            Objects.requireNonNull(font);
            font.m_92756_(stack, line, f, (float)(height + counter * (9 + 2)), color2, true);
            ++counter;
        }
        stack.m_85849_();
    }
}

