/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.integration.apotheosis;

import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.world.inventory.ModAnvilMenu;
import fuzs.easyanvils.world.level.block.entity.ContainerImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;
import shadows.apotheosis.ench.anvil.AnvilTile;

public class ApothAnvilBlockEntity
extends AnvilTile
implements MenuProvider,
Nameable,
WorldlyContainer,
ContainerImpl {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private LockCode lockKey = LockCode.f_19102_;
    private Component name;
    LazyOptional<? extends IItemHandler> handler = LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, Direction.UP));

    public ApothAnvilBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)ModRegistry.ANVIL_BLOCK_ENTITY_TYPE.get();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.lockKey = LockCode.m_19111_((CompoundTag)tag);
        if (tag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        this.inventory.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.lockKey.m_19109_(tag);
        if (this.name != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        ContainerHelper.m_18976_((CompoundTag)tag, this.inventory, (boolean)true);
    }

    @javax.annotation.Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public NonNullList<ItemStack> items() {
        return this.inventory;
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_ != null && !(this.f_58857_.m_7702_(this.f_58858_) instanceof ApothAnvilBlockEntity)) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public int[] m_7071_(Direction side) {
        int[] nArray;
        if (side != Direction.DOWN) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @javax.annotation.Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component m_7755_() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    public boolean canOpen(Player player) {
        return ApothAnvilBlockEntity.canUnlock(player, this.lockKey, this.m_5446_());
    }

    public static boolean canUnlock(Player player, LockCode code, Component displayName) {
        if (!player.m_5833_() && !code.m_19107_(player.m_21205_())) {
            player.m_5661_((Component)Component.m_237110_((String)"container.isLocked", (Object[])new Object[]{displayName}), true);
            player.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return this.canOpen(player) ? this.createMenu(i, inventory) : null;
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.repair");
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new ModAnvilMenu(id, playerInventory, this, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER && facing != Direction.UP) {
            return this.handler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handler = LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, Direction.UP));
    }
}

