/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.handler;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.network.S2CAnvilRepairMessage;
import fuzs.easyanvils.network.S2COpenNameTagEditorMessage;
import fuzs.puzzleslib.network.Message;
import java.util.Optional;
import java.util.OptionalDouble;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ItemInteractionHandler {
    public static Optional<InteractionResultHolder<ItemStack>> onRightClickItem(Level level, Player player, InteractionHand hand) {
        if (!((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).editNameTagsNoAnvil) {
            return Optional.empty();
        }
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_() && stack.m_150930_(Items.f_42656_)) {
            if (!level.f_46443_) {
                EasyAnvils.NETWORK.sendTo((Message)new S2COpenNameTagEditorMessage(hand, stack.m_41786_().getString()), (ServerPlayer)player);
            }
            return Optional.of(InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_));
        }
        return Optional.empty();
    }

    public static Optional<InteractionResult> onRightClickBlock(Level level, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos pos;
        BlockState state;
        if (!((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).anvilRepairing) {
            return Optional.empty();
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_41913_) && (state = level.m_8055_(pos = hitResult.m_82425_())).m_204336_(BlockTags.f_13033_) && ItemInteractionHandler.tryRepairAnvil(level, pos, state)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return Optional.of(InteractionResult.m_19078_((boolean)level.f_46443_));
        }
        return Optional.empty();
    }

    public static boolean tryRepairAnvil(Level level, BlockPos pos, BlockState state) {
        BlockState repairedState = ItemInteractionHandler.getRepairedState(state);
        if (repairedState != null) {
            if (!level.f_46443_) {
                level.m_7731_(pos, repairedState, 2);
                EasyAnvils.NETWORK.sendToAllNear((Message)new S2CAnvilRepairMessage(pos, repairedState), pos, level);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static BlockState getRepairedState(BlockState state) {
        if (state.m_60713_(Blocks.f_50324_)) {
            return (BlockState)Blocks.f_50323_.m_49966_().m_61124_((Property)AnvilBlock.f_48764_, (Comparable)((Direction)state.m_61143_((Property)AnvilBlock.f_48764_)));
        }
        return state.m_60713_(Blocks.f_50323_) ? (BlockState)Blocks.f_50322_.m_49966_().m_61124_((Property)AnvilBlock.f_48764_, (Comparable)((Direction)state.m_61143_((Property)AnvilBlock.f_48764_))) : null;
    }

    public static OptionalDouble onAnvilRepair(Player player, ItemStack left, ItemStack right, ItemStack output, double breakChance) {
        if (((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).riskFreeAnvilRenaming && right.m_41619_()) {
            return OptionalDouble.of(0.0);
        }
        return OptionalDouble.of(((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).anvilBreakChance);
    }
}

