/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class SendGeneralDataPacket
extends BaseS2CMessage {
    public final int claimed;
    public final int loaded;
    public final int maxClaimChunks;
    public final int maxForceLoadChunks;

    public static void send(FTBChunksTeamData teamData, ServerPlayer player) {
        SendGeneralDataPacket.send(teamData, List.of(player));
    }

    public static void send(FTBChunksTeamData teamData, Collection<ServerPlayer> players) {
        Collection<ClaimedChunk> cc = teamData.getClaimedChunks();
        int loaded = (int)cc.stream().filter(ClaimedChunk::isForceLoaded).count();
        SendGeneralDataPacket data = new SendGeneralDataPacket(cc.size(), loaded, teamData.getMaxClaimChunks(), teamData.getMaxForceLoadChunks());
        players.forEach(player -> {
            if (FTBTeamsAPI.getPlayerTeam((ServerPlayer)player).getId().equals(teamData.getTeamId())) {
                data.sendTo((ServerPlayer)player);
            }
        });
    }

    private SendGeneralDataPacket(int claimed, int loaded, int maxClaimChunks, int maxForceLoadChunks) {
        this.claimed = claimed;
        this.loaded = loaded;
        this.maxClaimChunks = maxClaimChunks;
        this.maxForceLoadChunks = maxForceLoadChunks;
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_GENERAL_DATA;
    }

    SendGeneralDataPacket(FriendlyByteBuf buf) {
        this.claimed = buf.m_130242_();
        this.loaded = buf.m_130242_();
        this.maxClaimChunks = buf.m_130242_();
        this.maxForceLoadChunks = buf.m_130242_();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.claimed);
        buf.m_130130_(this.loaded);
        buf.m_130130_(this.maxClaimChunks);
        buf.m_130130_(this.maxForceLoadChunks);
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunks.PROXY.updateGeneralData(this);
    }
}

