/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import dev.ftb.mods.ftblibrary.config.NameMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public enum MinimapPosition {
    BOTTOM_LEFT(0, 2),
    LEFT(0, 1),
    TOP_LEFT(0, 0),
    TOP_RIGHT(1, 0),
    RIGHT(1, 1),
    BOTTOM_RIGHT(1, 2);

    public static final NameMap<MinimapPosition> NAME_MAP;
    public final int posX;
    public final int posY;

    private MinimapPosition(int x, int y) {
        this.posX = x;
        this.posY = y;
    }

    public int getX(int w, int s) {
        if (this.posX == 0) {
            return 5;
        }
        return w - s - 5;
    }

    public int getY(int h, int s) {
        if (this.posY == 0) {
            return 5;
        }
        if (this.posY == 1) {
            return (h - s) / 2;
        }
        return h - s - 5;
    }

    static {
        NAME_MAP = NameMap.of((Object)((Object)TOP_RIGHT), (Object[])MinimapPosition.values()).baseNameKey("ftbchunks.minimap.position").create();
    }

    public static enum MinimapOffsetConditional implements Predicate<MinimapPosition>
    {
        BOTTOM_LEFT(BOTTOM_LEFT),
        LEFT(LEFT),
        TOP_LEFT(TOP_LEFT),
        TOP_RIGHT(TOP_RIGHT),
        RIGHT(RIGHT),
        BOTTOM_RIGHT(BOTTOM_RIGHT),
        NONE(null);

        public static final NameMap<MinimapOffsetConditional> NAME_MAP;
        @Nullable
        private final MinimapPosition position;

        private MinimapOffsetConditional(MinimapPosition position) {
            this.position = position;
        }

        @Override
        public boolean test(MinimapPosition minimapPosition) {
            return this == NONE || this.position == minimapPosition;
        }

        static {
            NAME_MAP = NameMap.of((Object)NONE, (Object[])MinimapOffsetConditional.values()).baseNameKey("ftbchunks.minimap.position").create();
        }
    }
}

