/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;

public class FillMany {
    public static void drawStrings(PoseStack stack, Font renderer, List<Text> texts) {
        for (Text text : texts) {
            renderer.m_92883_(stack, text.text, (float)text.x, (float)text.y, text.color);
        }
    }

    public static void fillMany(Matrix4f matrix, List<ColoredRectangle> rects) {
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (ColoredRectangle rect : rects) {
            FillMany.addRectangle(bufferbuilder, matrix, rect.x0, rect.y0, rect.x1, rect.y1, rect.color);
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    private static void addRectangle(BufferBuilder bufferbuilder, Matrix4f matrix, int x0, int y0, int x1, int y1, int color) {
        if (x0 < x1) {
            int i = x0;
            x0 = x1;
            x1 = i;
        }
        if (y0 < y1) {
            int j = y0;
            y0 = y1;
            y1 = j;
        }
        float ca = (float)(color >> 24 & 0xFF) / 255.0f;
        float cr = (float)(color >> 16 & 0xFF) / 255.0f;
        float cg = (float)(color >> 8 & 0xFF) / 255.0f;
        float cb = (float)(color & 0xFF) / 255.0f;
        bufferbuilder.m_85982_(matrix, (float)x0, (float)y1, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x1, (float)y1, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x1, (float)y0, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x0, (float)y0, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
    }

    public static final class Text {
        public final int x;
        public final int y;
        public final String text;
        int color;

        public Text(int x, int y, String text, int color) {
            this.x = x;
            this.y = y;
            this.text = text;
            this.color = color;
        }
    }

    public static final class ColoredRectangle {
        public final int x0;
        public final int y0;
        public final int x1;
        public final int y1;
        public final int color;

        public ColoredRectangle(int x0, int y0, int x1, int y1, int color) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.color = color;
        }
    }
}

