/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.events.pie;

import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.events.pie.Pies;
import net.brnbrd.delightful.compat.Mods;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vectorwing.farmersdelight.common.block.PieBlock;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class PieEvents {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    void onPieTooltip(ItemTooltipEvent e) {
        BlockItem b;
        ItemStack stack = e.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (b = (BlockItem)item).m_40614_() instanceof PieBlock || Pies.enabled(stack) || this.isBerryPieOrMuffin(stack)) {
            e.getToolTip().add(Component.m_237115_((String)"delightful.placeable.desc").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    void onCancelDefault(PlayerInteractEvent.RightClickItem e) {
        if (Pies.enabled(e.getItemStack())) {
            e.setCancellationResult(InteractionResult.FAIL);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    void onPieOverhaul(PlayerInteractEvent.RightClickBlock e) {
        PieBlock pie;
        if (Pies.enabled(e.getItemStack()) && !e.getLevel().m_8055_(e.getHitVec().m_82425_()).m_60713_((Block)ModBlocks.CUTTING_BOARD.get()) && !e.isCanceled() && (pie = Pies.get(e.getItemStack())) != null) {
            e.setUseItem(Event.Result.DENY);
            e.setUseBlock(Event.Result.DENY);
            InteractionResult place = this.placePie(pie, new BlockPlaceContext(e.getEntity(), e.getHand(), e.getItemStack(), e.getHitVec()));
            e.setCancellationResult(place);
            e.setCanceled(place.m_19077_());
        }
    }

    private InteractionResult placePie(PieBlock pie, BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (context.m_7059_() && level.m_8055_(pos.m_7495_()).m_60767_().m_76333_()) {
            Player player = context.m_43723_();
            BlockState pieState = pie.m_5573_(context);
            if (this.canPlace(context, pieState) && level.m_7731_(pos, pieState, 11)) {
                BlockState placedState = level.m_8055_(pos);
                if (placedState.m_60713_(pieState.m_60734_())) {
                    placedState.m_60734_().m_6402_(level, pos, placedState, (LivingEntity)player, context.m_43722_());
                }
                level.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)pieState));
                SoundType soundtype = placedState.getSoundType((LevelReader)level, pos, (Entity)player);
                level.m_5594_(player, pos, placedState.getSoundType((LevelReader)level, pos, (Entity)player).m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                if (!player.m_150110_().f_35937_) {
                    context.m_43722_().m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return InteractionResult.FAIL;
    }

    private boolean canPlace(BlockPlaceContext pContext, BlockState pState) {
        Player player = pContext.m_43723_();
        CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return pState.m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_()) && pContext.m_43725_().m_45752_(pState, pContext.m_8083_(), collisioncontext);
    }

    boolean isBerryPieOrMuffin(ItemStack stack) {
        return Mods.loaded("wildberries") && (stack.m_204117_(Util.it("wildberries", "berry_pies")) || stack.m_204117_(Util.it("wildberries", "berry_muffins")));
    }
}

