/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.slab;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.content.copycat.MathHelper;
import com.copycatsplus.copycats.content.copycat.base.CTWaterloggedCopycatBlock;
import com.copycatsplus.copycats.content.copycat.base.ICopycatWithWrappedBlock;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatSlabBlock
extends CTWaterloggedCopycatBlock
implements ICopycatWithWrappedBlock<Block> {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final EnumProperty<SlabType> SLAB_TYPE = BlockStateProperties.f_61397_;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public CopycatSlabBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_(SLAB_TYPE, (Comparable)SlabType.BOTTOM));
    }

    @Override
    public Block getWrappedBlock() {
        return Blocks.f_50405_;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (!player.m_6144_() && player.m_36326_()) {
            ItemStack heldItem = player.m_21120_(hand);
            IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
            if (placementHelper.matchesItem(heldItem)) {
                placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, ray);
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        BlockState toState = reader.m_8055_(toPos);
        if (toState.m_60713_((Block)this)) {
            if (toState.m_61143_(AXIS) != axis) {
                return true;
            }
            return CopycatSlabBlock.getFaceShape(state, face) != CopycatSlabBlock.getFaceShape(toState, face);
        }
        if (face.m_122434_() != axis) {
            return true;
        }
        return CopycatSlabBlock.getFaceShape(state, face) != FaceShape.FULL;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (!toState.m_60713_((Block)this)) {
            return false;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        BlockPos diff = toPos.m_121996_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return true;
        }
        Direction face = MathHelper.DirectionFromDelta(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (face == null) {
            boolean correctAxis = switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> {
                    if (diff.m_123341_() == 0) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Y -> {
                    if (diff.m_123342_() == 0) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> diff.m_123343_() == 0;
            };
            return correctAxis && diff.m_123333_(Vec3i.f_123288_) <= 2;
        }
        if (face.m_122434_() == axis) {
            return false;
        }
        if (toState.m_60713_((Block)this)) {
            return FaceShape.canConnect(CopycatSlabBlock.getFaceShape(state, face), CopycatSlabBlock.getFaceShape(toState, face.m_122424_()));
        }
        return true;
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return CopycatSlabBlock.getFaceShape(state, face).hasContact();
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return !CopycatSlabBlock.getFaceShape(state, face).hasContact();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        assert (stateForPlacement != null);
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            return (BlockState)((BlockState)state.m_61124_(SLAB_TYPE, (Comparable)SlabType.DOUBLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        Direction.Axis axis = context.m_7820_().m_122434_();
        boolean flag = switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (context.m_43720_().f_82479_ - (double)blockPos.m_123341_() > 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (context.m_43720_().f_82480_ - (double)blockPos.m_123342_() > 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> context.m_43720_().f_82481_ - (double)blockPos.m_123343_() > 0.5;
        };
        Direction clickedFace = context.m_43719_();
        return (BlockState)((BlockState)stateForPlacement.m_61124_(AXIS, (Comparable)axis)).m_61124_(SLAB_TYPE, (Comparable)(clickedFace == Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) || clickedFace.m_122434_() != axis && !flag ? SlabType.BOTTOM : SlabType.TOP));
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        SlabType slabtype = (SlabType)pState.m_61143_(SLAB_TYPE);
        Direction.Axis axis = (Direction.Axis)pState.m_61143_(AXIS);
        if (slabtype != SlabType.DOUBLE && itemstack.m_150930_(this.m_5456_())) {
            boolean flag = switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> {
                    if (pUseContext.m_43720_().f_82479_ - (double)pUseContext.m_8083_().m_123341_() > 0.5) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Y -> {
                    if (pUseContext.m_43720_().f_82480_ - (double)pUseContext.m_8083_().m_123342_() > 0.5) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> pUseContext.m_43720_().f_82481_ - (double)pUseContext.m_8083_().m_123343_() > 0.5;
            };
            Direction direction = pUseContext.m_43719_();
            if (slabtype == SlabType.BOTTOM) {
                return direction == Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) || flag;
            }
            return direction == Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE) || !flag;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{AXIS}).m_61104_(new Property[]{SLAB_TYPE}));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return super.m_7357_(pState, pLevel, pPos, pType);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        SlabType type = (SlabType)pState.m_61143_(SLAB_TYPE);
        Direction.Axis axis = (Direction.Axis)pState.m_61143_(AXIS);
        if (type == SlabType.DOUBLE) {
            return Shapes.m_83144_();
        }
        if (type == SlabType.BOTTOM) {
            return CCShapes.CASING_8PX.get(axis);
        }
        return CCShapes.CASING_8PX_TOP.get(axis);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if ((neighborState.m_60734_() instanceof SlabBlock || neighborState.m_60734_() instanceof CopycatSlabBlock) && CopycatSlabBlock.getMaterial(level, pos).m_60719_(CopycatSlabBlock.getMaterial(level, pos.m_121945_(dir)), dir.m_122424_())) {
            return CopycatSlabBlock.getFaceShape(state, dir) == CopycatSlabBlock.getFaceShape(neighborState, dir.m_122424_());
        }
        return CopycatSlabBlock.getFaceShape(state, dir) == FaceShape.FULL && CopycatSlabBlock.getMaterial(level, pos).m_60719_(neighborState, dir.m_122424_());
    }

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos) {
        BlockState state = CopycatBlock.getMaterial((BlockGetter)reader, (BlockPos)targetPos);
        if (state.m_60713_(Blocks.f_50016_)) {
            return reader.m_8055_(targetPos);
        }
        return state;
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        return CopycatSlabBlock.setApparentDirection(state, rot.m_55954_(CopycatSlabBlock.getApparentDirection(state)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_(CopycatSlabBlock.getApparentDirection(state)));
    }

    public static FaceShape getFaceShape(BlockState state, Direction face) {
        SlabType slab = (SlabType)state.m_61143_(SLAB_TYPE);
        if (state.m_61143_(AXIS) != face.m_122434_()) {
            return FaceShape.forSlabSide(slab);
        }
        return switch (slab) {
            default -> throw new IncompatibleClassChangeError();
            case SlabType.TOP -> FaceShape.fullOrNone(face.m_122421_() == Direction.AxisDirection.POSITIVE);
            case SlabType.BOTTOM -> FaceShape.fullOrNone(face.m_122421_() == Direction.AxisDirection.NEGATIVE);
            case SlabType.DOUBLE -> FaceShape.FULL;
        };
    }

    public static Direction getApparentDirection(BlockState state) {
        return Direction.m_122387_((Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)), (Direction.AxisDirection)(state.m_61143_(SLAB_TYPE) == SlabType.BOTTOM ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
    }

    public static BlockState setApparentDirection(BlockState state, Direction direction) {
        SlabType type = (SlabType)state.m_61143_(SLAB_TYPE);
        if (type == SlabType.DOUBLE) {
            return (BlockState)state.m_61124_(AXIS, (Comparable)direction.m_122434_());
        }
        if (CopycatSlabBlock.getApparentDirection(state).m_122421_() != direction.m_122421_()) {
            return (BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)direction.m_122434_())).m_61124_(SLAB_TYPE, (Comparable)(type == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM));
        }
        return (BlockState)state.m_61124_(AXIS, (Comparable)direction.m_122434_());
    }

    private static enum FaceShape {
        FULL,
        TOP,
        BOTTOM,
        NONE;


        public static FaceShape forSlabSide(SlabType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case SlabType.TOP -> TOP;
                case SlabType.BOTTOM -> BOTTOM;
                case SlabType.DOUBLE -> FULL;
            };
        }

        public static FaceShape fullOrNone(boolean value) {
            return value ? FULL : NONE;
        }

        public static boolean canConnect(FaceShape shape1, FaceShape shape2) {
            return shape1 == shape2 || shape1 == FULL && shape2 != NONE || shape2 == FULL && shape1 != NONE;
        }

        public boolean hasContact() {
            return this != NONE;
        }
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> CCBlocks.COPYCAT_SLAB.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> CCBlocks.COPYCAT_SLAB.has(arg_0);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)), dir -> world.m_8055_(pos.m_121945_(dir)).m_60767_().m_76336_());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            if (((SlabType)state.m_61143_(SLAB_TYPE)).equals((Object)SlabType.DOUBLE)) {
                return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)((BlockState)s.m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)))).m_61124_(SLAB_TYPE, (Comparable)SlabType.BOTTOM));
            }
            return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)((BlockState)s.m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)))).m_61124_(SLAB_TYPE, (Comparable)((SlabType)state.m_61143_(SLAB_TYPE))));
        }
    }
}

