/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.half_panel;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.content.copycat.MathHelper;
import com.copycatsplus.copycats.content.copycat.base.CTWaterloggedCopycatBlock;
import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.placement.PoleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VoxelShaper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatHalfPanelBlock
extends CTWaterloggedCopycatBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final DirectionProperty OFFSET = DirectionProperty.m_61546_((String)"offset", (Predicate)Direction.Plane.HORIZONTAL);
    private static final Map<Direction, VoxelShaper> SHAPE_BY_OFFSET = new HashMap<Direction, VoxelShaper>();
    private static final int placementHelperId;

    public CopycatHalfPanelBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OFFSET, (Comparable)Direction.NORTH));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (!player.m_6144_() && player.m_36326_()) {
            ItemStack heldItem = player.m_21120_(hand);
            IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
            if (placementHelper.matchesItem(heldItem)) {
                placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, ray);
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Direction offset = (Direction)state.m_61143_((Property)OFFSET);
        BlockState toState = reader.m_8055_(toPos);
        if (toState.m_60713_((Block)this)) {
            return toState.m_61143_((Property)FACING) != direction || toState.m_61143_((Property)OFFSET) != offset;
        }
        return true;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (!toState.m_60713_((Block)this)) {
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction offset = (Direction)state.m_61143_((Property)OFFSET);
        BlockPos diff = toPos.m_121996_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return true;
        }
        Direction face = MathHelper.DirectionFromDelta(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (face == null) {
            return false;
        }
        if (toState.m_60713_((Block)this)) {
            try {
                return toState.m_61143_((Property)FACING) == facing && toState.m_61143_((Property)OFFSET) == offset && face.m_122434_() == CopycatHalfPanelBlock.getOffsetAxis(facing, offset);
            }
            catch (IllegalStateException ignored) {
                return false;
            }
        }
        return false;
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction offset = (Direction)state.m_61143_((Property)OFFSET);
        return face == facing || face == CopycatHalfPanelBlock.getOffsetFacing(facing, offset) || face.m_122434_() == CopycatHalfPanelBlock.getOffsetAxis(facing, offset);
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return !this.canFaceBeOccluded(state, face);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        double offset1;
        BlockState stateForPlacement = super.m_5573_(context);
        assert (stateForPlacement != null);
        Direction facing = context.m_43719_().m_122424_();
        double offset2 = switch (facing.m_122434_()) {
            case Direction.Axis.X -> {
                offset1 = context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_();
                yield context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_();
            }
            case Direction.Axis.Y -> {
                offset1 = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_();
                yield context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_();
            }
            case Direction.Axis.Z -> {
                offset1 = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_();
                yield context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_();
            }
            default -> {
                offset1 = 0.0;
                yield 0.0;
            }
        };
        Direction offset = Math.abs(offset1 - 0.5) > Math.abs(offset2 - 0.5) ? Direction.m_122387_((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)(offset1 > 0.5 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE)) : Direction.m_122387_((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)(offset2 > 0.5 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
        return (BlockState)((BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)OFFSET, (Comparable)offset);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{FACING, OFFSET}));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE_BY_OFFSET.get(pState.m_61143_((Property)OFFSET)).get((Direction)pState.m_61143_((Property)FACING));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (state.m_60713_((Block)this) == neighborState.m_60713_((Block)this) && CopycatHalfPanelBlock.getMaterial((BlockGetter)level, (BlockPos)pos).m_60719_(CopycatHalfPanelBlock.getMaterial((BlockGetter)level, (BlockPos)pos.m_121945_(dir)), dir.m_122424_())) {
            return neighborState.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) && neighborState.m_61143_((Property)OFFSET) == state.m_61143_((Property)OFFSET) && CopycatHalfPanelBlock.getOffsetAxis((Direction)state.m_61143_((Property)FACING), (Direction)state.m_61143_((Property)OFFSET)) == dir.m_122434_();
        }
        return false;
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        Direction.Axis mirrorAxis = null;
        for (Direction.Axis axis : Iterate.axes) {
            if (!pMirror.m_54842_().m_56526_(axis)) continue;
            mirrorAxis = axis;
            break;
        }
        if (mirrorAxis == null) {
            return super.m_6943_(pState, pMirror);
        }
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        Direction offset = (Direction)pState.m_61143_((Property)OFFSET);
        if (facing.m_122434_() == mirrorAxis) {
            return (BlockState)pState.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
        }
        if (offset.m_122434_() == mirrorAxis) {
            return (BlockState)pState.m_61124_((Property)OFFSET, (Comparable)offset.m_122424_());
        }
        return pState;
    }

    public static Direction getOffsetFacing(Direction facing, Direction offset) {
        if (offset.m_122434_().m_122478_()) {
            throw new IllegalArgumentException("offset must be a horizontal direction.");
        }
        Vec3i facingNormal = facing.m_122436_();
        Vec3i offsetNormal = offset.m_122436_();
        if (facingNormal.m_123341_() != 0 && offsetNormal.m_123341_() != 0) {
            offsetNormal = new Vec3i(offsetNormal.m_123342_(), offsetNormal.m_123341_(), offsetNormal.m_123343_());
        }
        if (facingNormal.m_123343_() != 0 && offsetNormal.m_123343_() != 0) {
            offsetNormal = new Vec3i(offsetNormal.m_123341_(), offsetNormal.m_123343_(), offsetNormal.m_123342_());
        }
        return Objects.requireNonNull(MathHelper.DirectionFromDelta(offsetNormal.m_123341_(), offsetNormal.m_123342_(), offsetNormal.m_123343_()));
    }

    public static Direction.Axis getOffsetAxis(Direction facing, Direction offset) {
        Direction offsetFacing = CopycatHalfPanelBlock.getOffsetFacing(facing, offset);
        if (facing.m_122434_().m_122478_()) {
            return offsetFacing.m_122427_().m_122434_();
        }
        if (offsetFacing.m_122434_().m_122478_()) {
            return facing.m_122427_().m_122434_();
        }
        return Direction.Axis.Y;
    }

    static {
        SHAPE_BY_OFFSET.put(Direction.NORTH, CCShapes.HALF_PANEL_NORTH);
        SHAPE_BY_OFFSET.put(Direction.SOUTH, CCShapes.HALF_PANEL_SOUTH);
        SHAPE_BY_OFFSET.put(Direction.EAST, CCShapes.HALF_PANEL_EAST);
        SHAPE_BY_OFFSET.put(Direction.WEST, CCShapes.HALF_PANEL_WEST);
        placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction> {
        private PlacementHelper() {
            super(arg_0 -> CCBlocks.COPYCAT_HALF_PANEL.has(arg_0), state -> CopycatHalfPanelBlock.getOffsetAxis((Direction)state.m_61143_((Property)FACING), (Direction)state.m_61143_((Property)OFFSET)), (Property)FACING);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof CopycatHalfPanelBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistance((BlockPos)pos, (Vec3)ray.m_82450_(), dir -> dir.m_122434_() == this.axisFunction.apply(state));
            for (Direction dir2 : directions) {
                BlockPos newPos;
                BlockState newState;
                int poles;
                Object reach;
                int range = (Integer)AllConfigs.server().equipment.placementAssistRange.get();
                if (player != null && (reach = null) != null && reach.m_22109_(ExtendoGripItem.singleRangeAttributeModifier)) {
                    range += 4;
                }
                if ((poles = this.attachedPoles(world, pos, dir2)) >= range || !(newState = world.m_8055_(newPos = pos.m_5484_(dir2, poles + 1))).m_60767_().m_76336_()) continue;
                return PlacementOffset.success((Vec3i)newPos, bState -> (BlockState)((BlockState)bState.m_61124_(this.property, (Comparable)((Direction)state.m_61143_(this.property)))).m_61124_((Property)OFFSET, (Comparable)((Direction)state.m_61143_((Property)OFFSET))));
            }
            return PlacementOffset.fail();
        }
    }
}

