/*
 * Decompiled with CFR 0.152.
 */
package com.seleneandmana.compatoplenty.core.registry.util;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.client.ChestManager;
import com.teamabnormals.blueprint.client.renderer.block.ChestBlockEntityWithoutLevelRenderer;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.entity.BlueprintChestBlockEntity;
import com.teamabnormals.blueprint.common.block.entity.BlueprintTrappedChestBlockEntity;
import com.teamabnormals.blueprint.common.item.BEWLRBlockItem;
import com.teamabnormals.blueprint.common.item.BEWLRFuelBlockItem;
import com.teamabnormals.blueprint.common.item.FuelBlockItem;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;

public class CompatBlockSubRegistryHelper
extends BlockSubRegistryHelper {
    public CompatBlockSubRegistryHelper(RegistryHelper parent) {
        super(parent);
    }

    public Pair<RegistryObject<BlueprintChestBlock>, RegistryObject<BlueprintTrappedChestBlock>> createUnburnableMultiCompatChestBlocks(String firstCompatModId, String secondCompatModId, String name, MaterialColor color) {
        boolean isModLoaded = CompatBlockSubRegistryHelper.areModsLoaded((String[])new String[]{firstCompatModId}) || CompatBlockSubRegistryHelper.areModsLoaded((String[])new String[]{secondCompatModId});
        CreativeModeTab chestGroup = isModLoaded ? CreativeModeTab.f_40750_ : null;
        CreativeModeTab trappedChestGroup = isModLoaded ? CreativeModeTab.f_40751_ : null;
        String modId = this.parent.getModId();
        String chestName = name + "_chest";
        String trappedChestName = name + "_trapped_chest";
        RegistryObject chest = this.deferredRegister.register(chestName, () -> new BlueprintChestBlock(modId + ":" + name, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(2.5f).m_60918_(SoundType.f_56736_)));
        RegistryObject trappedChest = this.deferredRegister.register(trappedChestName, () -> new BlueprintTrappedChestBlock(modId + ":" + name + "_trapped", BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(2.5f).m_60918_(SoundType.f_56736_)));
        this.itemRegister.register(chestName, () -> new BEWLRBlockItem((Block)chest.get(), new Item.Properties().m_41491_(chestGroup), () -> () -> CompatBlockSubRegistryHelper.chestBEWLR(false)));
        this.itemRegister.register(trappedChestName, () -> new BEWLRBlockItem((Block)trappedChest.get(), new Item.Properties().m_41491_(trappedChestGroup), () -> () -> CompatBlockSubRegistryHelper.chestBEWLR(true)));
        ChestManager.putChestInfo((String)modId, (String)name, (boolean)false);
        ChestManager.putChestInfo((String)modId, (String)name, (boolean)true);
        return Pair.of((Object)chest, (Object)trappedChest);
    }

    public Pair<RegistryObject<BlueprintChestBlock>, RegistryObject<BlueprintTrappedChestBlock>> createMultiCompatChestBlocks(String firstCompatModId, String secondCompatModId, String name, MaterialColor color) {
        boolean isModLoaded = CompatBlockSubRegistryHelper.areModsLoaded((String[])new String[]{firstCompatModId}) || CompatBlockSubRegistryHelper.areModsLoaded((String[])new String[]{secondCompatModId});
        CreativeModeTab chestGroup = isModLoaded ? CreativeModeTab.f_40750_ : null;
        CreativeModeTab trappedChestGroup = isModLoaded ? CreativeModeTab.f_40751_ : null;
        String modId = this.parent.getModId();
        String chestName = name + "_chest";
        String trappedChestName = name + "_trapped_chest";
        RegistryObject chest = this.deferredRegister.register(chestName, () -> new BlueprintChestBlock(modId + ":" + name, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(2.5f).m_60918_(SoundType.f_56736_)));
        RegistryObject trappedChest = this.deferredRegister.register(trappedChestName, () -> new BlueprintTrappedChestBlock(modId + ":" + name + "_trapped", BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(2.5f).m_60918_(SoundType.f_56736_)));
        this.itemRegister.register(chestName, () -> new BEWLRFuelBlockItem((Block)chest.get(), new Item.Properties().m_41491_(chestGroup), () -> () -> CompatBlockSubRegistryHelper.chestBEWLR(false), 300));
        this.itemRegister.register(trappedChestName, () -> new BEWLRFuelBlockItem((Block)trappedChest.get(), new Item.Properties().m_41491_(trappedChestGroup), () -> () -> CompatBlockSubRegistryHelper.chestBEWLR(true), 300));
        ChestManager.putChestInfo((String)modId, (String)name, (boolean)false);
        ChestManager.putChestInfo((String)modId, (String)name, (boolean)true);
        return Pair.of((Object)chest, (Object)trappedChest);
    }

    public <B extends Block> RegistryObject<B> createMultiCompatFuelBlock(String firstCompatModId, String secondCompatModId, String name, Supplier<? extends B> supplier, int burnTime, @Nullable CreativeModeTab group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new FuelBlockItem((Block)block.get(), burnTime, new Item.Properties().m_41491_((CreativeModeTab)(CompatBlockSubRegistryHelper.areModsLoaded((String[])new String[]{firstCompatModId}) || CompatBlockSubRegistryHelper.areModsLoaded((String[])new String[]{secondCompatModId}) ? group : null))));
        return block;
    }

    public <B extends Block> RegistryObject<B> createMultiCompatBlock(String firstCompatModId, String secondCompatModId, String name, Supplier<? extends B> supplier, @Nullable CreativeModeTab group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_((CreativeModeTab)(CompatBlockSubRegistryHelper.areModsLoaded((String[])new String[]{firstCompatModId}) || CompatBlockSubRegistryHelper.areModsLoaded((String[])new String[]{secondCompatModId}) ? group : null))));
        return block;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BEWLRBlockItem.LazyBEWLR chestBEWLR(boolean trapped) {
        return trapped ? new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer(dispatcher, entityModelSet, (BlockEntity)new BlueprintTrappedChestBlockEntity(BlockPos.f_121853_, Blocks.f_50325_.m_49966_()))) : new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer(dispatcher, entityModelSet, (BlockEntity)new BlueprintChestBlockEntity(BlockPos.f_121853_, Blocks.f_50087_.m_49966_())));
    }
}

