/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.compat;

import com.anthonyhilyard.iceberg.util.Tooltips;
import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.util.compat.create.ColdSweatDisplayBehaviors;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModDamageSources;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.DivingHelmetItem;
import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.content.purity.ContainerWithPurity;
import dev.ghen.thirst.content.purity.WaterPurity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import sereneseasons.season.SeasonHooks;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber
public class CompatManager {
    private static final boolean BOP_LOADED = CompatManager.modLoaded("biomesoplenty");
    private static final boolean SEASONS_LOADED = CompatManager.modLoaded("sereneseasons");
    private static final boolean CURIOS_LOADED = CompatManager.modLoaded("curios");
    private static final boolean WEREWOLVES_LOADED = CompatManager.modLoaded("werewolves");
    private static final boolean SPIRIT_LOADED = CompatManager.modLoaded("spirit");
    private static final boolean ARMOR_UNDERWEAR_LOADED = CompatManager.modLoaded("armorunder");
    private static final boolean BYG_LOADED = CompatManager.modLoaded("byg");
    private static final boolean CREATE_LOADED = CompatManager.modLoaded("create", 0, 5, 1);
    private static final boolean ATMOSPHERIC_LOADED = CompatManager.modLoaded("atmospheric");
    private static final boolean ENVIRONMENTAL_LOADED = CompatManager.modLoaded("environmental");
    private static final boolean TERRALITH_LOADED = CompatManager.modLoaded("terralith");
    private static final boolean WEATHER_LOADED = CompatManager.modLoaded("weather2");
    private static final boolean WYTHERS_LOADED = CompatManager.modLoaded("wwoo");
    private static final boolean TOOLTIPS_LOADED = CompatManager.modLoaded("legendarytooltips");
    private static final boolean PRIMAL_WINTER_LOADED = CompatManager.modLoaded("primalwinter");
    private static final boolean THIRST_LOADED = CompatManager.modLoaded("thirst");
    private static final boolean ICEBERG_LOADED = CompatManager.modLoaded("iceberg");
    private static final boolean SPOILED_LOADED = CompatManager.modLoaded("spoiled");
    private static final boolean SUPPLEMENTARIES_LOADED = CompatManager.modLoaded("supplementaries");
    public static boolean USING_BACKTANK;

    public static boolean modLoaded(String modID, int minMajorVer, int minMinorVer, int minPatchVer) {
        ModContainer mod = ModList.get().getModContainerById(modID).orElse(null);
        if (mod == null) {
            return false;
        }
        if (minMajorVer > 0 || minMinorVer > 0 || minPatchVer > 0) {
            ArtifactVersion version = mod.getModInfo().getVersion();
            if (version.getMajorVersion() >= minMajorVer && version.getMinorVersion() >= minMinorVer && version.getIncrementalVersion() >= minPatchVer) {
                return true;
            }
            ColdSweat.LOGGER.error("Cold Sweat requires {} {} or higher for compat to be enabled!", (Object)(modID.substring(0, 1).toUpperCase() + modID.substring(1)), (Object)(minMajorVer + "." + minMinorVer + "." + minPatchVer));
            return false;
        }
        return true;
    }

    public static boolean modLoaded(String modID) {
        return CompatManager.modLoaded(modID, 0, 0, 0);
    }

    public static boolean isBiomesOPlentyLoaded() {
        return BOP_LOADED;
    }

    public static boolean isSereneSeasonsLoaded() {
        return SEASONS_LOADED;
    }

    public static boolean isCuriosLoaded() {
        return CURIOS_LOADED;
    }

    public static boolean isWerewolvesLoaded() {
        return WEREWOLVES_LOADED;
    }

    public static boolean isSpiritLoaded() {
        return SPIRIT_LOADED;
    }

    public static boolean isArmorUnderwearLoaded() {
        return ARMOR_UNDERWEAR_LOADED;
    }

    public static boolean isBiomesYoullGoLoaded() {
        return BYG_LOADED;
    }

    public static boolean isCreateLoaded() {
        return CREATE_LOADED;
    }

    public static boolean isAtmosphericLoaded() {
        return ATMOSPHERIC_LOADED;
    }

    public static boolean isEnvironmentalLoaded() {
        return ENVIRONMENTAL_LOADED;
    }

    public static boolean isTerralithLoaded() {
        return TERRALITH_LOADED;
    }

    public static boolean isWeather2Loaded() {
        return WEATHER_LOADED;
    }

    public static boolean isWythersLoaded() {
        return WYTHERS_LOADED;
    }

    public static boolean isLegendaryTooltipsLoaded() {
        return TOOLTIPS_LOADED;
    }

    public static boolean isPrimalWinterLoaded() {
        return PRIMAL_WINTER_LOADED;
    }

    public static boolean isThirstLoaded() {
        return THIRST_LOADED;
    }

    public static boolean isIcebergLoaded() {
        return ICEBERG_LOADED;
    }

    public static boolean isSpoiledLoaded() {
        return SPOILED_LOADED;
    }

    public static boolean isSupplementariesLoaded() {
        return SUPPLEMENTARIES_LOADED;
    }

    public static boolean hasCurio(Player player, Item curio) {
        return CURIOS_LOADED && CompatManager.getCurios((LivingEntity)player).stream().map(ItemStack::m_41720_).anyMatch(item -> item == curio);
    }

    public static List<ItemStack> getCurios(LivingEntity entity) {
        if (!CURIOS_LOADED) {
            return new ArrayList<ItemStack>();
        }
        return entity.getCapability(CuriosCapability.INVENTORY).map(handler -> handler.getCurios().values()).stream().flatMap(Collection::stream).map(ICurioStacksHandler::getStacks).map(stacks -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                list.add(stacks.getStackInSlot(i));
            }
            return list;
        }).flatMap(Collection::stream).toList();
    }

    public static boolean hasOzzyLiner(ItemStack stack) {
        return false;
    }

    public static boolean hasOttoLiner(ItemStack stack) {
        return false;
    }

    public static boolean hasOllieLiner(ItemStack stack) {
        return false;
    }

    public static boolean isWerewolf(Player player) {
        return WEREWOLVES_LOADED && WerewolfPlayer.getOpt((Player)player).filter(w -> w.getLevel() > 0).map(w -> w.getForm().isTransformed()).orElse(false) != false;
    }

    public static boolean isColdEnoughToSnow(Level level, BlockPos pos) {
        return SEASONS_LOADED && SeasonHooks.coldEnoughToSnowHook((Biome)((Biome)level.m_204166_(pos).get()), (BlockPos)pos, (LevelReader)level);
    }

    public static int getWaterPurity(ItemStack stack) {
        if (THIRST_LOADED) {
            return WaterPurity.getPurity((ItemStack)stack);
        }
        return 0;
    }

    public static ItemStack setWaterPurity(ItemStack stack, int purity) {
        if (THIRST_LOADED) {
            return WaterPurity.addPurity((ItemStack)stack, (int)purity);
        }
        return stack;
    }

    public static ItemStack setWaterPurity(ItemStack item, BlockPos pos, Level level) {
        if (THIRST_LOADED) {
            return WaterPurity.addPurity((ItemStack)item, (BlockPos)pos, (Level)level);
        }
        return item;
    }

    public static int getLegendaryTTStartIndex(List<Either<FormattedText, TooltipComponent>> tooltip) {
        if (CompatManager.isIcebergLoaded()) {
            int index = CSMath.getIndexOf(tooltip, element -> element.right().map(component -> component instanceof Tooltips.TitleBreakComponent).orElse(false));
            if (index == -1) {
                return 0;
            }
            return index;
        }
        return 0;
    }

    @SubscribeEvent
    public static void onLivingTempDamage(LivingEvent event) {
        if (!(event instanceof LivingDamageEvent) && !(event instanceof LivingAttackEvent)) {
            return;
        }
        if (ARMOR_UNDERWEAR_LOADED && !event.getEntity().f_19853_.f_46443_) {
            DamageSource source;
            DamageSource damageSource = source = event instanceof LivingDamageEvent ? ((LivingDamageEvent)event).getSource() : ((LivingAttackEvent)event).getSource();
            if (source == null) {
                return;
            }
            boolean isDamageCold = source == ModDamageSources.COLD;
            if (isDamageCold || source == ModDamageSources.HOT) {
                int liners = 0;
                for (ItemStack stack : event.getEntity().m_6168_()) {
                    if (!(isDamageCold ? CompatManager.hasOttoLiner(stack) : CompatManager.hasOllieLiner(stack))) continue;
                    ++liners;
                }
                if (liners >= 4) {
                    event.setCanceled(true);
                    return;
                }
                if (event instanceof LivingDamageEvent) {
                    LivingDamageEvent damageEvent = (LivingDamageEvent)event;
                    damageEvent.setAmount(CSMath.blend(damageEvent.getAmount(), 0.0f, liners, 0.0f, 4.0f));
                }
            }
        }
    }

    @SubscribeEvent
    public static void drainCreateBacktank(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!CompatManager.isCreateLoaded()) {
            return;
        }
        ItemStack backTank = player.m_6844_(EquipmentSlot.CHEST);
        if (USING_BACKTANK && player.f_19853_.f_46443_) {
            player.getPersistentData().m_128405_("VisualBacktankAir", Math.round(BacktankUtil.getAir((ItemStack)backTank)) - 1);
        }
        if (player.f_19797_ % 20 != 0 || event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!player.m_7500_() && !player.m_20077_() && backTank.m_41720_() instanceof BacktankItem && backTank.m_41720_().m_41475_() && Temperature.get((LivingEntity)player, Temperature.Trait.WORLD) > Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT)) {
            ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
            if (!helmet.m_41720_().m_41475_() || !(helmet.m_41720_() instanceof DivingHelmetItem)) {
                return;
            }
            ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
            if (!boots.m_41720_().m_41475_()) {
                return;
            }
            ItemStack pants = player.m_6844_(EquipmentSlot.LEGS);
            if (!pants.m_41720_().m_41475_()) {
                return;
            }
            if (player.f_19853_.f_46443_) {
                USING_BACKTANK = true;
            }
            if (CSMath.getIfNotNull(backTank.m_41783_(), tag -> tag.m_128451_("Air"), 0) > 0) {
                BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)backTank, (float)1.0f);
                if (player.f_19853_.f_46443_) {
                    player.getPersistentData().m_128405_("VisualBacktankAir", Math.round(BacktankUtil.getAir((ItemStack)backTank)) - 1);
                }
            }
        } else if (player.f_19853_.f_46443_) {
            USING_BACKTANK = false;
        }
    }

    static {
        if (CURIOS_LOADED) {
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void onCurioChange(CurioChangeEvent event) {
                    EntityTempManager.updateInsulationAttributeModifiers(event.getEntity());
                }
            });
        }
        USING_BACKTANK = false;
    }

    @Mod.EventBusSubscriber(modid="cold_sweat", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void addThirstDrinks(FMLCommonSetupEvent event) {
            if (CompatManager.isThirstLoaded()) {
                ThirstHelper.addDrink((Item)ModItems.FILLED_WATERSKIN, (int)6, (int)12);
                WaterPurity.addContainer((ContainerWithPurity)new ContainerWithPurity(ModItems.WATERSKIN.m_7968_(), ModItems.FILLED_WATERSKIN.m_7968_()));
            }
            if (CompatManager.isCreateLoaded()) {
                new Object(){

                    public void registerDisplayBehaviors() {
                        ColdSweatDisplayBehaviors.THERMOLITH = AllDisplayBehaviours.register((ResourceLocation)new ResourceLocation("cold_sweat", "thermolith"), (DisplayBehaviour)new ColdSweatDisplayBehaviors.Thermolith());
                        AllDisplayBehaviours.assignBlock((DisplayBehaviour)ColdSweatDisplayBehaviors.THERMOLITH, (Block)ModBlocks.THERMOLITH);
                    }
                }.registerDisplayBehaviors();
            }
        }
    }
}

