/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.event.TempEffectsCommon;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public class MixinHeartRender {
    private static final ResourceLocation HEART_TEXTURE = new ResourceLocation("cold_sweat", "textures/gui/overlay/hearts_frozen.png");
    private static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("minecraft", "textures/gui/icons.png");
    private static int HEART_INDEX = 0;

    @Inject(method={"renderHeart(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/gui/Gui$HeartType;IIIZZ)V"}, at={@At(value="TAIL")}, cancellable=true)
    private void renderHeart(PoseStack ps, Gui.HeartType heartType, int x, int y, int texV, boolean blink, boolean half, CallbackInfo ci) {
        double heartsFreezePercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean isHardcore = player.f_19853_.m_6106_().m_5466_();
        if (heartsFreezePercentage == 0.0 || player.m_21023_(ModEffects.GRACE)) {
            return;
        }
        if (heartType == Gui.HeartType.CONTAINER) {
            ++HEART_INDEX;
        }
        if (player != null) {
            if (player.m_21023_(ModEffects.ICE_RESISTANCE)) {
                return;
            }
            double temp = Overlays.BODY_TEMP;
            float unfrozenHealth = CSMath.blend((float)(1.0 - heartsFreezePercentage), 1.0f, TempEffectsCommon.getColdResistance((Player)player), 0.0f, 4.0f);
            if (unfrozenHealth == 1.0f) {
                return;
            }
            int frozenHealth = (int)((double)player.m_21233_() - (double)player.m_21233_() * CSMath.blend((double)unfrozenHealth, 1.0, temp, -100.0, -50.0));
            int frozenHearts = frozenHealth / 2;
            int u = blink || heartType == Gui.HeartType.CONTAINER ? 14 : (half ? 7 : 0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)HEART_TEXTURE);
            if (HEART_INDEX > 0 && HEART_INDEX < frozenHearts + 1) {
                GuiComponent.m_93133_((PoseStack)ps, (int)x, (int)y, (float)21.0f, (float)0.0f, (int)9, (int)9, (int)30, (int)14);
                GuiComponent.m_93133_((PoseStack)ps, (int)(x + 1), (int)(y + 1), (float)u, (float)0.0f, (int)7, (int)7, (int)30, (int)14);
                if (isHardcore) {
                    GuiComponent.m_93133_((PoseStack)ps, (int)(x + 1), (int)(y + 1), (float)23.0f, (float)10.0f, (int)7, (int)4, (int)30, (int)14);
                }
                ci.cancel();
            } else if (HEART_INDEX == frozenHearts + 1 && frozenHealth % 2 == 1) {
                GuiComponent.m_93133_((PoseStack)ps, (int)(x + 1), (int)(y + 1), (float)u, (float)7.0f, (int)7, (int)7, (int)30, (int)14);
                if (isHardcore) {
                    GuiComponent.m_93133_((PoseStack)ps, (int)(x + 4), (int)(y + 1), (float)26.0f, (float)10.0f, (int)4, (int)4, (int)30, (int)14);
                }
            }
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS_TEXTURE);
    }

    @Inject(method={"renderHearts"}, at={@At(value="HEAD")})
    private void renderHearts(PoseStack pPoseStack, Player pPlayer, int pX, int pY, int pHeight, int p_168694_, float p_168695_, int p_168696_, int p_168697_, int p_168698_, boolean p_168699_, CallbackInfo ci) {
        HEART_INDEX = 0;
    }
}

