/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public record PlayerDataRequirement(Optional<GameType> gameType, Optional<Map<StatRequirement, IntegerBounds>> stats, Optional<Map<ResourceLocation, Boolean>> recipes, Optional<Map<ResourceLocation, Either<AdvancementCompletionRequirement, AdvancementCriteriaRequirement>>> advancements, Optional<EntityRequirement> lookingAt) {
    public static final Codec<PlayerDataRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(GameType::m_46400_, GameType::m_46405_).optionalFieldOf("gameType").forGetter(requirement -> requirement.gameType), (App)Codec.unboundedMap(StatRequirement.CODEC, IntegerBounds.CODEC).optionalFieldOf("stats").forGetter(requirement -> requirement.stats), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.BOOL).optionalFieldOf("recipes").forGetter(requirement -> requirement.recipes), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.either(AdvancementCompletionRequirement.CODEC, AdvancementCriteriaRequirement.CODEC)).optionalFieldOf("advancements").forGetter(requirement -> requirement.advancements), (App)EntityRequirement.getCodec().optionalFieldOf("lookingAt").forGetter(requirement -> requirement.lookingAt)).apply((Applicative)instance, PlayerDataRequirement::new));

    public static Codec<PlayerDataRequirement> getCodec(Codec<EntityRequirement> lastCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(GameType::m_46400_, GameType::m_46405_).optionalFieldOf("gameType").forGetter(requirement -> requirement.gameType), (App)Codec.unboundedMap(StatRequirement.CODEC, IntegerBounds.CODEC).optionalFieldOf("stats").forGetter(requirement -> requirement.stats), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.BOOL).optionalFieldOf("recipes").forGetter(requirement -> requirement.recipes), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.either(AdvancementCompletionRequirement.CODEC, AdvancementCriteriaRequirement.CODEC)).optionalFieldOf("advancements").forGetter(requirement -> requirement.advancements), (App)lastCodec.optionalFieldOf("lookingAt").forGetter(requirement -> requirement.lookingAt)).apply((Applicative)instance, PlayerDataRequirement::new));
    }

    public boolean test(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        ServerPlayer serverPlayer = EntityHelper.getServerPlayer(player);
        if (this.gameType.isPresent() && EntityHelper.getGameModeForPlayer(player) != this.gameType.get()) {
            return false;
        }
        if (this.stats.isPresent()) {
            for (Map.Entry<StatRequirement, IntegerBounds> entry : this.stats.get().entrySet()) {
                int value = serverPlayer.m_8951_().m_13015_(entry.getKey().stat());
                if (entry.getKey().test(entry.getKey().stat(), value)) continue;
                return false;
            }
        }
        if (this.recipes.isPresent()) {
            for (Map.Entry<StatRequirement, Object> entry : this.recipes.get().entrySet()) {
                if (serverPlayer.m_8952_().m_12711_((ResourceLocation)entry.getKey()) == ((Boolean)entry.getValue()).booleanValue()) continue;
                return false;
            }
        }
        if (this.advancements.isPresent()) {
            for (Map.Entry<StatRequirement, Object> entry : this.advancements.get().entrySet()) {
                AdvancementProgress progress = serverPlayer.m_8960_().m_135996_(serverPlayer.m_20194_().m_129889_().m_136041_((ResourceLocation)entry.getKey()));
                if (!((Boolean)((Either)entry.getValue()).map(complete -> complete.test(progress), criteria -> criteria.test(progress))).booleanValue()) continue;
                return false;
            }
        }
        if (this.lookingAt.isPresent()) {
            Vec3 vec3 = player.m_146892_();
            Vec3 vec32 = player.m_20252_(1.0f);
            Vec3 vec322 = vec3.m_82520_(vec32.f_82479_ * 100.0, vec32.f_82480_ * 100.0, vec32.f_82481_ * 100.0);
            EntityHitResult entityhitresult = ProjectileUtil.m_150175_((Level)player.f_19853_, (Entity)player, (Vec3)vec3, (Vec3)vec322, (AABB)new AABB(vec3, vec322).m_82400_(1.0), ent -> !ent.m_5833_(), (float)0.0f);
            if (entityhitresult == null || entityhitresult.m_6662_() != HitResult.Type.ENTITY) {
                return false;
            }
            Entity hitEntity = entityhitresult.m_82443_();
            if (!this.lookingAt.get().test(hitEntity) || !player.m_142582_(hitEntity)) {
                return false;
            }
        }
        return true;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        this.gameType.ifPresent(gameType -> tag.m_128359_("gameType", gameType.m_46405_()));
        this.stats.ifPresent(stats -> {
            ListTag statsTag = new ListTag();
            for (Map.Entry entry : stats.entrySet()) {
                CompoundTag statTag = new CompoundTag();
                statTag.m_128365_("stat", (Tag)((StatRequirement)entry.getKey()).serialize());
                statTag.m_128365_("value", (Tag)((IntegerBounds)entry.getValue()).serialize());
                statsTag.add((Object)statTag);
            }
            tag.m_128365_("stats", (Tag)statsTag);
        });
        this.recipes.ifPresent(recipes -> {
            CompoundTag recipesTag = new CompoundTag();
            for (Map.Entry entry : recipes.entrySet()) {
                recipesTag.m_128379_(((ResourceLocation)entry.getKey()).toString(), ((Boolean)entry.getValue()).booleanValue());
            }
            tag.m_128365_("recipes", (Tag)recipesTag);
        });
        this.advancements.ifPresent(advancements -> {
            CompoundTag advancementsTag = new CompoundTag();
            for (Map.Entry entry : advancements.entrySet()) {
                CompoundTag advancementTag = new CompoundTag();
                ((Either)entry.getValue()).ifLeft(complete -> advancementTag.m_128379_("complete", complete.complete.booleanValue()));
                ((Either)entry.getValue()).ifRight(criteria -> {
                    CompoundTag criteriaTag = new CompoundTag();
                    for (Map.Entry<String, Boolean> criteriaEntry : criteria.criteria.entrySet()) {
                        criteriaTag.m_128379_(criteriaEntry.getKey(), criteriaEntry.getValue().booleanValue());
                    }
                    advancementTag.m_128365_("criteria", (Tag)criteriaTag);
                });
                advancementsTag.m_128365_(((ResourceLocation)entry.getKey()).toString(), (Tag)advancementTag);
            }
            tag.m_128365_("advancements", (Tag)advancementsTag);
        });
        this.lookingAt.ifPresent(lookingAt -> tag.m_128365_("lookingAt", (Tag)lookingAt.serialize()));
        return tag;
    }

    public static PlayerDataRequirement deserialize(CompoundTag tag) {
        Optional<GameType> gameType = tag.m_128441_("gameType") ? Optional.of(GameType.m_46400_((String)tag.m_128461_("gameType"))) : Optional.empty();
        Optional<Map<StatRequirement, IntegerBounds>> stats = tag.m_128441_("stats") ? Optional.of(tag.m_128437_("stats", 10).stream().map(tg -> (CompoundTag)tg).collect(Collectors.toMap(tg -> StatRequirement.deserialize(tg.m_128469_("stat")), tg -> IntegerBounds.deserialize(tg.m_128469_("value"))))) : Optional.empty();
        Optional<Map<ResourceLocation, Boolean>> recipes = tag.m_128441_("recipes") ? Optional.of(tag.m_128469_("recipes").m_128431_().stream().collect(Collectors.toMap(key -> new ResourceLocation(key), key -> tag.m_128469_("recipes").m_128471_(key)))) : Optional.empty();
        Optional<Map<ResourceLocation, Either<AdvancementCompletionRequirement, AdvancementCriteriaRequirement>>> advancements = tag.m_128441_("advancements") ? Optional.of(tag.m_128469_("advancements").m_128431_().stream().collect(Collectors.toMap(key -> new ResourceLocation(key), key -> {
            CompoundTag advancementTag = tag.m_128469_("advancements").m_128469_(key);
            if (advancementTag.m_128441_("complete")) {
                return Either.left((Object)new AdvancementCompletionRequirement(advancementTag.m_128471_("complete")));
            }
            return Either.right((Object)new AdvancementCriteriaRequirement(advancementTag.m_128469_("criteria").m_128431_().stream().collect(Collectors.toMap(criteriaKey -> criteriaKey, criteriaKey -> advancementTag.m_128469_("criteria").m_128471_(criteriaKey)))));
        }))) : Optional.empty();
        Optional<EntityRequirement> lookingAt = tag.m_128441_("lookingAt") ? Optional.of(EntityRequirement.deserialize(tag.m_128469_("lookingAt"))) : Optional.empty();
        return new PlayerDataRequirement(gameType, stats, recipes, advancements, lookingAt);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerDataRequirement that = (PlayerDataRequirement)obj;
        if (!this.gameType.equals(that.gameType)) {
            return false;
        }
        if (!this.stats.equals(that.stats)) {
            return false;
        }
        if (!this.recipes.equals(that.recipes)) {
            return false;
        }
        if (!this.advancements.equals(that.advancements)) {
            return false;
        }
        return this.lookingAt.equals(that.lookingAt);
    }

    @Override
    public String toString() {
        return "PlayerData{gameType=" + this.gameType + ", stats=" + this.stats + ", recipes=" + this.recipes + ", advancements=" + this.advancements + ", lookingAt=" + this.lookingAt + "}";
    }

    public static class StatRequirement {
        private final StatType<?> type;
        private ResourceLocation statId;
        private final Stat<?> stat;
        private final IntegerBounds value;
        public static final Codec<StatRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.STAT_TYPES.getCodec().fieldOf("type").forGetter(stat -> stat.type), (App)ResourceLocation.f_135803_.fieldOf("stat").forGetter(stat -> stat.statId), (App)IntegerBounds.CODEC.fieldOf("value").forGetter(stat -> stat.value)).apply((Applicative)instance, StatRequirement::new));

        public StatRequirement(StatType<?> type, ResourceLocation statId, IntegerBounds value) {
            this(type, (Stat)type.m_12893_().m_7745_(statId), value);
        }

        public StatRequirement(StatType<?> type, Stat<?> stat, IntegerBounds value) {
            this.type = type;
            this.stat = stat;
            this.value = value;
        }

        public StatType<?> type() {
            return this.type;
        }

        public Stat<?> stat() {
            return this.stat;
        }

        public IntegerBounds value() {
            return this.value;
        }

        public boolean test(Stat<?> stat, int value) {
            return this.stat.equals(stat) && this.value.test(value);
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", ForgeRegistries.STAT_TYPES.getKey(this.type).toString());
            tag.m_128359_("stat", StatRequirement.serializeStat(this.stat));
            tag.m_128365_("value", (Tag)this.value.serialize());
            return tag;
        }

        public static StatRequirement deserialize(CompoundTag tag) {
            StatType type = (StatType)ForgeRegistries.STAT_TYPES.getValue(new ResourceLocation(tag.m_128461_("type")));
            Stat stat = StatRequirement.deserializeStat(type, tag);
            IntegerBounds value = IntegerBounds.deserialize(tag.m_128469_("value"));
            return new StatRequirement(type, stat, value);
        }

        private static <T> String serializeStat(Stat<T> stat) {
            return stat.m_12859_().m_12893_().m_7981_(stat.m_12867_()).toString();
        }

        private static <T> Stat<T> deserializeStat(StatType<T> type, CompoundTag tag) {
            return type.m_12902_(type.m_12893_().m_7745_(new ResourceLocation(tag.m_128461_("stat"))));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StatRequirement that = (StatRequirement)obj;
            if (!this.type.equals(that.type)) {
                return false;
            }
            if (!this.statId.equals((Object)that.statId)) {
                return false;
            }
            if (!this.stat.equals(that.stat)) {
                return false;
            }
            return this.value.equals(that.value);
        }

        public String toString() {
            return "Stat{type=" + this.type + ", statId=" + this.statId + ", stat=" + this.stat + ", value=" + this.value + "}";
        }
    }

    public record AdvancementCompletionRequirement(Boolean complete) {
        public static final Codec<AdvancementCompletionRequirement> CODEC = Codec.BOOL.xmap(AdvancementCompletionRequirement::new, AdvancementCompletionRequirement::complete);

        public boolean test(AdvancementProgress progress) {
            return progress.m_8193_() == this.complete.booleanValue();
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("completion", this.complete.booleanValue());
            return tag;
        }

        public static AdvancementCompletionRequirement deserialize(CompoundTag tag) {
            return new AdvancementCompletionRequirement(tag.m_128471_("completion"));
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AdvancementCompletionRequirement that = (AdvancementCompletionRequirement)obj;
            return this.complete.equals(that.complete);
        }

        @Override
        public String toString() {
            return "Completion{complete=" + this.complete + "}";
        }
    }

    public record AdvancementCriteriaRequirement(Map<String, Boolean> criteria) {
        public static final Codec<AdvancementCriteriaRequirement> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.BOOL).xmap(AdvancementCriteriaRequirement::new, AdvancementCriteriaRequirement::criteria);

        public boolean test(AdvancementProgress progress) {
            for (Map.Entry<String, Boolean> entry : this.criteria.entrySet()) {
                CriterionProgress criterionprogress = progress.m_8214_(entry.getKey());
                if (criterionprogress != null && criterionprogress.m_12911_() == entry.getValue().booleanValue()) continue;
                return false;
            }
            return true;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            for (Map.Entry<String, Boolean> entry : this.criteria.entrySet()) {
                tag.m_128379_(entry.getKey(), entry.getValue().booleanValue());
            }
            return tag;
        }

        public static AdvancementCriteriaRequirement deserialize(CompoundTag tag) {
            return new AdvancementCriteriaRequirement(tag.m_128431_().stream().collect(Collectors.toMap(key -> key, key -> tag.m_128471_(key))));
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AdvancementCriteriaRequirement that = (AdvancementCriteriaRequirement)obj;
            return this.criteria.equals(that.criteria);
        }

        @Override
        public String toString() {
            return "Criteria{criteria=" + this.criteria + "}";
        }
    }
}

