/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.EnchantmentRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;

public record ItemRequirement(Optional<List<Either<TagKey<Item>, Item>>> items, Optional<TagKey<Item>> tag, Optional<IntegerBounds> count, Optional<IntegerBounds> durability, Optional<List<EnchantmentRequirement>> enchantments, Optional<List<EnchantmentRequirement>> storedEnchantments, Optional<Potion> potion, NbtRequirement nbt) {
    public static final Codec<ItemRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.tagOrRegistryObjectCodec(Registry.f_122904_, ForgeRegistries.ITEMS).listOf().optionalFieldOf("items").forGetter(predicate -> predicate.items), (App)TagKey.m_203877_((ResourceKey)Registry.f_122904_).optionalFieldOf("tag").forGetter(predicate -> predicate.tag), (App)IntegerBounds.CODEC.optionalFieldOf("count").forGetter(predicate -> predicate.count), (App)IntegerBounds.CODEC.optionalFieldOf("durability").forGetter(predicate -> predicate.durability), (App)EnchantmentRequirement.CODEC.listOf().optionalFieldOf("enchantments").forGetter(predicate -> predicate.enchantments), (App)EnchantmentRequirement.CODEC.listOf().optionalFieldOf("stored_enchantments").forGetter(predicate -> predicate.storedEnchantments), (App)ForgeRegistries.POTIONS.getCodec().optionalFieldOf("potion").forGetter(predicate -> predicate.potion), (App)NbtRequirement.CODEC.optionalFieldOf("nbt", (Object)new NbtRequirement(new CompoundTag())).forGetter(predicate -> predicate.nbt)).apply((Applicative)instance, ItemRequirement::new));

    public boolean test(ItemStack stack, boolean ignoreCount) {
        block12: {
            block11: {
                if (stack.m_41619_() && this.items.isPresent() && !this.items.get().isEmpty()) {
                    return false;
                }
                if (this.nbt.tag().m_128456_()) {
                    return true;
                }
                if (this.items.isPresent()) {
                    for (int i = 0; i < this.items.get().size(); ++i) {
                        Either<TagKey<Item>, Item> either = this.items.get().get(i);
                        if (((Boolean)either.map(arg_0 -> ((ItemStack)stack).m_204117_(arg_0), arg_0 -> ((ItemStack)stack).m_150930_(arg_0))).booleanValue()) break;
                        if (i != this.items.get().size() - 1) continue;
                        return false;
                    }
                }
                if (this.tag.isPresent() && !stack.m_204117_(this.tag.get())) {
                    return false;
                }
                if (!ignoreCount && this.count.isPresent() && !this.count.get().test(stack.m_41613_())) {
                    return false;
                }
                if (this.durability.isPresent() && !this.durability.get().test(stack.m_41776_() - stack.m_41773_())) {
                    return false;
                }
                if (this.potion.isPresent() && !this.potion.get().m_43488_().equals(PotionUtils.m_43579_((ItemStack)stack).m_43488_())) {
                    return false;
                }
                if (!this.nbt.test((Tag)stack.m_41783_())) {
                    return false;
                }
                if (!this.enchantments.isPresent()) break block11;
                Map stackEnchantments = EnchantmentHelper.m_44882_((ListTag)stack.m_41785_());
                for (EnchantmentRequirement enchantment : this.enchantments.get()) {
                    if (enchantment.test(stackEnchantments)) continue;
                    return false;
                }
                break block12;
            }
            if (!this.storedEnchantments.isPresent()) break block12;
            Map stackEnchantments = EnchantmentHelper.m_44882_((ListTag)EnchantedBookItem.m_41163_((ItemStack)stack));
            for (EnchantmentRequirement enchantment : this.storedEnchantments.get()) {
                if (enchantment.test(stackEnchantments)) continue;
                return false;
            }
        }
        return true;
    }

    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        this.items.ifPresent(itemList -> nbt.m_128365_("items", (Tag)NBTHelper.listTagOf(itemList.stream().map(either -> StringTag.m_129297_((String)((String)either.map(tag -> "#" + tag.f_203868_(), item -> ForgeRegistries.ITEMS.getKey(item).toString())))).collect(Collectors.toList()))));
        this.count.ifPresent(count -> nbt.m_128365_("count", (Tag)count.serialize()));
        this.durability.ifPresent(durability -> nbt.m_128365_("durability", (Tag)durability.serialize()));
        this.enchantments.ifPresent(enchantments -> nbt.m_128365_("enchantments", (Tag)NBTHelper.listTagOf(enchantments.stream().map(EnchantmentRequirement::serialize).collect(Collectors.toList()))));
        this.storedEnchantments.ifPresent(enchantments -> nbt.m_128365_("stored_enchantments", (Tag)NBTHelper.listTagOf(enchantments.stream().map(EnchantmentRequirement::serialize).collect(Collectors.toList()))));
        this.potion.ifPresent(potion -> nbt.m_128359_("potion", ForgeRegistries.POTIONS.getKey(potion).toString()));
        if (!this.nbt.tag().m_128456_()) {
            nbt.m_128365_("nbt", (Tag)this.nbt.serialize());
        }
        return nbt;
    }

    public static ItemRequirement deserialize(CompoundTag nbt) {
        Optional<List<Either<TagKey<Item>, Item>>> items = Optional.of(nbt.m_128437_("items", 8).stream().map(tg -> {
            String string = tg.m_7916_();
            ResourceLocation location = new ResourceLocation(string.replace("#", ""));
            if (!string.contains("#")) {
                return Either.right((Object)((Item)ForgeRegistries.ITEMS.getValue(location)));
            }
            return Either.left((Object)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)location));
        }).toList());
        Optional<TagKey<Item>> tag = nbt.m_128441_("tag") ? Optional.of(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("tag")))) : Optional.empty();
        Optional<IntegerBounds> count = nbt.m_128441_("count") ? Optional.of(IntegerBounds.deserialize(nbt.m_128469_("count"))) : Optional.empty();
        Optional<IntegerBounds> durability = nbt.m_128441_("durability") ? Optional.of(IntegerBounds.deserialize(nbt.m_128469_("durability"))) : Optional.empty();
        Optional<List<EnchantmentRequirement>> enchantments = nbt.m_128441_("enchantments") ? Optional.of(nbt.m_128437_("enchantments", 10).stream().map(tg -> EnchantmentRequirement.deserialize((CompoundTag)tg)).toList()) : Optional.empty();
        Optional<List<EnchantmentRequirement>> storedEnchantments = nbt.m_128441_("stored_enchantments") ? Optional.of(nbt.m_128437_("stored_enchantments", 10).stream().map(tg -> EnchantmentRequirement.deserialize((CompoundTag)tg)).toList()) : Optional.empty();
        Optional<Potion> potion = nbt.m_128441_("potion") ? Optional.ofNullable((Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(nbt.m_128461_("potion")))) : Optional.empty();
        NbtRequirement nbtReq = nbt.m_128441_("nbt") ? NbtRequirement.deserialize(nbt.m_128469_("nbt")) : new NbtRequirement(new CompoundTag());
        return new ItemRequirement(items, tag, count, durability, enchantments, storedEnchantments, potion, nbtReq);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemRequirement that = (ItemRequirement)obj;
        if (!this.items.equals(that.items)) {
            return false;
        }
        if (!this.count.equals(that.count)) {
            return false;
        }
        if (!this.durability.equals(that.durability)) {
            return false;
        }
        if (!this.enchantments.equals(that.enchantments)) {
            return false;
        }
        if (!this.storedEnchantments.equals(that.storedEnchantments)) {
            return false;
        }
        if (!this.potion.equals(that.potion)) {
            return false;
        }
        return this.nbt.equals(that.nbt);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ItemRequirement{");
        this.items.ifPresent(itemList -> itemList.forEach(either -> builder.append(((Comparable)either.map(tag -> "#" + tag.f_203868_(), item -> ForgeRegistries.ITEMS.getKey(item))).toString()).append(", ")));
        this.count.ifPresent(bounds -> builder.append(bounds.toString()).append(", "));
        this.durability.ifPresent(bounds -> builder.append(bounds.toString()).append(", "));
        this.enchantments.ifPresent(enchantments -> builder.append("Enchantments: {").append(enchantments.stream().map(EnchantmentRequirement::toString).collect(Collectors.joining(", "))).append("}, "));
        this.storedEnchantments.ifPresent(enchantments -> builder.append("Stored Enchantments: {").append(enchantments.stream().map(EnchantmentRequirement::toString).collect(Collectors.joining(", "))).append("}, "));
        this.potion.ifPresent(potion -> builder.append("Potion: ").append(ForgeRegistries.POTIONS.getKey(potion).toString()));
        builder.append("NBT: ").append(this.nbt.toString()).append(", ");
        builder.append("}");
        return builder.toString();
    }
}

