/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public record ItemData(ItemRequirement data, Double value, Optional<EntityRequirement> entityRequirement, Optional<List<String>> requiredMods) implements NbtSerializable
{
    public static final Codec<ItemData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemRequirement.CODEC.fieldOf("data").forGetter(ItemData::data), (App)Codec.DOUBLE.fieldOf("value").forGetter(ItemData::value), (App)EntityRequirement.getCodec().optionalFieldOf("entity_requirement").forGetter(ItemData::entityRequirement), (App)Codec.STRING.listOf().optionalFieldOf("required_mods").forGetter(ItemData::requiredMods)).apply((Applicative)instance, ItemData::new));

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("data", (Tag)this.data.serialize());
        tag.m_128347_("value", this.value.doubleValue());
        this.entityRequirement.ifPresent(entityRequirement1 -> tag.m_128365_("entity_requirement", (Tag)entityRequirement1.serialize()));
        ListTag mods = new ListTag();
        this.requiredMods.ifPresent(mods1 -> mods1.forEach(mod -> mods.add((Object)StringTag.m_129297_((String)mod))));
        tag.m_128365_("required_mods", (Tag)mods);
        return tag;
    }

    public static ItemData deserialize(CompoundTag nbt) {
        ItemRequirement items = ItemRequirement.deserialize(nbt.m_128469_("data"));
        Double value = nbt.m_128459_("value");
        Optional<Object> entityRequirement = Optional.ofNullable(nbt.m_128441_("entity_requirement") ? EntityRequirement.deserialize(nbt.m_128469_("entity_requirement")) : null);
        Optional<List<String>> requiredMods = Optional.of(nbt.m_128437_("required_mods", 8)).map(mods -> {
            ArrayList<String> mods1 = new ArrayList<String>();
            for (int i = 0; i < mods.size(); ++i) {
                mods1.add(mods.m_128778_(i));
            }
            return mods1;
        });
        return new ItemData(items, value, entityRequirement, requiredMods);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ItemData{data=").append(this.data).append(", value=").append(this.value);
        this.entityRequirement.ifPresent(entityRequirement1 -> builder.append(", entityRequirement=").append(entityRequirement1));
        this.requiredMods.ifPresent(mods -> builder.append(", requiredMods=").append(mods));
        builder.append("}");
        return builder.toString();
    }
}

