/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.AttributeCodecs;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public record InsulatorData(Insulation.Slot slot, Insulation insulation, ItemRequirement data, EntityRequirement predicate, Optional<AttributeModifierMap> attributes, Map<ResourceLocation, Double> immuneTempModifiers, Optional<List<String>> requiredMods) implements NbtSerializable
{
    public static final Codec<InsulatorData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Insulation.Slot.CODEC.fieldOf("type").forGetter(InsulatorData::slot), (App)Insulation.getCodec().fieldOf("insulation").forGetter(InsulatorData::insulation), (App)ItemRequirement.CODEC.fieldOf("data").forGetter(InsulatorData::data), (App)EntityRequirement.getCodec().optionalFieldOf("predicate", (Object)EntityRequirement.NONE).forGetter(InsulatorData::predicate), (App)AttributeModifierMap.CODEC.optionalFieldOf("attributes").forGetter(InsulatorData::attributes), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.DOUBLE).optionalFieldOf("immune_temp_modifiers", new HashMap()).forGetter(InsulatorData::immuneTempModifiers), (App)Codec.STRING.listOf().optionalFieldOf("required_mods").forGetter(InsulatorData::requiredMods)).apply((Applicative)instance, InsulatorData::new));

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        ListTag items = new ListTag();
        ListTag tags = new ListTag();
        tag.m_128365_("items", (Tag)items);
        tag.m_128365_("tags", (Tag)tags);
        tag.m_128359_("type", this.slot.name());
        tag.m_128365_("insulation", (Tag)this.insulation.serialize());
        tag.m_128365_("data", (Tag)this.data.serialize());
        tag.m_128365_("predicate", (Tag)this.predicate.serialize());
        if (this.attributes.isPresent()) {
            Multimap<Attribute, AttributeModifier> attributes1 = this.attributes.get().getMap();
            CompoundTag attributesTag = new CompoundTag();
            attributes1.forEach((attribute, modifier) -> attributesTag.m_128365_(ForgeRegistries.ATTRIBUTES.getKey(attribute).toString(), (Tag)AttributeCodecs.MODIFIER_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, modifier).result().orElseThrow()));
            tag.m_128365_("attributes", (Tag)attributesTag);
        }
        CompoundTag immuneTempModifiersTag = new CompoundTag();
        this.immuneTempModifiers.forEach((key, value) -> immuneTempModifiersTag.m_128347_(key.toString(), value.doubleValue()));
        tag.m_128365_("immune_temp_modifiers", (Tag)immuneTempModifiersTag);
        if (this.requiredMods.isPresent()) {
            tag.m_128365_("required_mods", NbtOps.f_128958_.createList(this.requiredMods.orElseGet(ArrayList::new).stream().map(StringTag::m_129297_)));
        }
        return tag;
    }

    public static InsulatorData deserialize(CompoundTag nbt) {
        Insulation.Slot slot = Insulation.Slot.valueOf(nbt.m_128461_("type"));
        Insulation insulation = Insulation.deserialize(nbt.m_128469_("insulation"));
        ItemRequirement requirement = ItemRequirement.deserialize(nbt.m_128469_("data"));
        EntityRequirement predicate = EntityRequirement.deserialize(nbt.m_128469_("predicate"));
        Optional<AttributeModifierMap> attributes = Optional.of(nbt.m_128469_("attributes")).map(attributesTag -> {
            HashMap attributes1 = new HashMap();
            attributesTag.m_128431_().forEach(key -> {
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(key));
                AttributeModifier modifier = (AttributeModifier)((Pair)AttributeCodecs.MODIFIER_CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)attributesTag.m_128423_(key)).result().orElseThrow()).getFirst();
                attributes1.put(attribute, modifier);
            });
            return attributes1;
        }).map(AttributeModifierMap::new);
        CompoundTag immuneTempModifiersTag = nbt.m_128469_("immune_temp_modifiers");
        HashMap<ResourceLocation, Double> immuneTempModifiers = new HashMap<ResourceLocation, Double>();
        immuneTempModifiersTag.m_128431_().forEach(key -> immuneTempModifiers.put(new ResourceLocation(key), immuneTempModifiersTag.m_128459_(key)));
        Optional<List<String>> mods = Optional.of(nbt.m_128437_("required_mods", 8).stream().map(Tag::m_7916_).toList());
        return new InsulatorData(slot, insulation, requirement, predicate, attributes, immuneTempModifiers, mods);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InsulatorData{slot=").append((Object)this.slot).append(", insulation=").append(this.insulation).append(", data=").append(this.data).append(", predicate=").append(this.predicate);
        this.attributes.ifPresent(attributeModifierMap -> builder.append(", attributes=").append(attributeModifierMap));
        this.requiredMods.ifPresent(mods -> builder.append(", requiredMods=").append(mods));
        builder.append('}');
        return builder.toString();
    }
}

