/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringRepresentable;

public record FuelData(FuelType type, Double fuel, ItemRequirement data, Optional<List<String>> requiredMods) implements NbtSerializable
{
    public static final Codec<FuelData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FuelType.CODEC.fieldOf("type").forGetter(FuelData::type), (App)Codec.DOUBLE.fieldOf("fuel").forGetter(FuelData::fuel), (App)ItemRequirement.CODEC.fieldOf("data").forGetter(FuelData::data), (App)Codec.STRING.listOf().optionalFieldOf("required_mods").forGetter(FuelData::requiredMods)).apply((Applicative)instance, FuelData::new));

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", this.type.m_7912_());
        tag.m_128347_("fuel", this.fuel.doubleValue());
        tag.m_128365_("data", (Tag)this.data.serialize());
        ListTag mods = new ListTag();
        this.requiredMods.ifPresent(mods1 -> mods1.forEach(mod -> mods.add((Object)StringTag.m_129297_((String)mod))));
        tag.m_128365_("required_mods", (Tag)mods);
        return tag;
    }

    public static FuelData deserialize(CompoundTag nbt) {
        FuelType type = FuelType.byName(nbt.m_128461_("type"));
        Double fuel = nbt.m_128459_("fuel");
        ItemRequirement requirement = ItemRequirement.deserialize(nbt.m_128469_("data"));
        Optional<List<String>> requiredMods = Optional.of(nbt.m_128437_("required_mods", 8)).map(mods -> {
            ArrayList<String> mods1 = new ArrayList<String>();
            for (int i = 0; i < mods.size(); ++i) {
                mods1.add(mods.m_128778_(i));
            }
            return mods1;
        });
        return new FuelData(type, fuel, requirement, requiredMods);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FuelData{type=").append((Object)this.type).append(", fuel=").append(this.fuel).append(", data=").append(this.data);
        this.requiredMods.ifPresent(mods -> builder.append(", requiredMods=").append(mods));
        builder.append("}");
        return builder.toString();
    }

    public static enum FuelType implements StringRepresentable
    {
        BOILER("boiler"),
        ICEBOX("icebox"),
        HEARTH("hearth"),
        SOUL_LAMP("soul_lamp");

        public static Codec<FuelType> CODEC;
        private final String name;

        private FuelType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static FuelType byName(String name) {
            for (FuelType type : FuelType.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return null;
        }

        static {
            CODEC = StringRepresentable.m_216439_(FuelType::values);
        }
    }
}

