/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateHearthSignalsMessage {
    private final boolean isSidePowered;
    private final boolean isBackPowered;
    private final BlockPos pos;

    public UpdateHearthSignalsMessage(boolean isSidePowered, boolean isBackPowered, BlockPos pos) {
        this.isSidePowered = isSidePowered;
        this.isBackPowered = isBackPowered;
        this.pos = pos;
    }

    public static void encode(UpdateHearthSignalsMessage message, FriendlyByteBuf buf) {
        buf.writeBoolean(message.isSidePowered);
        buf.writeBoolean(message.isBackPowered);
        buf.m_130064_(message.pos);
    }

    public static UpdateHearthSignalsMessage decode(FriendlyByteBuf buf) {
        return new UpdateHearthSignalsMessage(buf.readBoolean(), buf.readBoolean(), buf.m_130135_());
    }

    public static void handle(UpdateHearthSignalsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                BlockEntity patt1536$temp = Minecraft.m_91087_().f_91073_.m_7702_(message.pos);
                if (patt1536$temp instanceof HearthBlockEntity) {
                    HearthBlockEntity hearth = (HearthBlockEntity)patt1536$temp;
                    hearth.setSidePowered(message.isSidePowered);
                    hearth.setBackPowered(message.isBackPowered);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

