/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.init;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.BlockTempRegisterEvent;
import com.momosoftworks.coldsweat.api.event.core.TempModifierRegisterEvent;
import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTempConfig;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BoilerBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.CampfireBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.FurnaceBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.IceboxBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.LavaBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.NetherPortalBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.ArmorInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FireTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FoodTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FreezingTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.MountTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulLampTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulSproutTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.UndergroundTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterskinTempModifier;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TempModifierInit {
    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        TempModifierInit.buildRegistries();
    }

    public static void buildRegistries() {
        TempModifierRegistry.flush();
        BlockTempRegistry.flush();
        try {
            MinecraftForge.EVENT_BUS.post((Event)new TempModifierRegisterEvent());
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Registering TempModifiers failed!");
            throw e;
        }
        try {
            MinecraftForge.EVENT_BUS.post((Event)new BlockTempRegisterEvent());
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Registering BlockTemps failed!");
            throw e;
        }
    }

    @SubscribeEvent
    public static void registerBlockTemps(BlockTempRegisterEvent event) {
        long startMS = System.currentTimeMillis();
        for (final List<Object> list : WorldSettingsConfig.getInstance().getBlockTemps()) {
            try {
                String[] blockIDs = ((String)list.get(0)).split(",");
                Block[] effectBlocks = (Block[])Arrays.stream(blockIDs).map(xva$0 -> ConfigHelper.getBlocks(xva$0)).flatMap(Collection::stream).toArray(Block[]::new);
                final HashMap blockPredicates = list.size() >= 6 && list.get(5) instanceof String ? ConfigHelper.getBlockStatePredicates(effectBlocks[0], (String)list.get(5)) : new HashMap();
                event.register(new BlockTempConfig(blockPredicates, effectBlocks){
                    final double blockTemp;
                    final double blockRange;
                    final boolean weaken;
                    final double maxChange;
                    final Optional<CompoundTag> tag;
                    final double maxEffect;
                    final double minEffect;
                    {
                        super(predicates, blocks);
                        this.blockTemp = ((Number)list.get(1)).doubleValue();
                        this.blockRange = ((Number)list.get(2)).doubleValue();
                        this.weaken = list.size() > 3 && list.get(3) instanceof Boolean ? (Boolean)list.get(3) : true;
                        this.maxChange = list.size() > 4 && list.get(4) instanceof Number ? ((Number)list.get(4)).doubleValue() : Double.MAX_VALUE;
                        this.tag = list.size() > 6 && list.get(6) instanceof String ? Optional.of(NBTHelper.parseCompoundNbt((String)list.get(5))) : Optional.empty();
                        this.maxEffect = this.blockTemp > 0.0 ? this.maxChange : Double.MAX_VALUE;
                        this.minEffect = this.blockTemp < 0.0 ? -this.maxChange : -1.7976931348623157E308;
                    }

                    @Override
                    public double getTemperature(Level level, LivingEntity entity, BlockState state, BlockPos pos, double distance) {
                        if (blockPredicates.isEmpty() || this.testPredicates(state)) {
                            BlockEntity blockEntity;
                            if (this.tag.isPresent() && (blockEntity = level.m_7702_(pos)) != null) {
                                CompoundTag blockTag = blockEntity.m_187480_();
                                for (String key : this.tag.get().m_128431_()) {
                                    if (this.tag.get().m_128423_(key).equals(blockTag.m_128423_(key))) continue;
                                    return 0.0;
                                }
                            }
                            return this.weaken ? CSMath.blend(this.blockTemp, 0.0, distance, 0.5, this.blockRange) : this.blockTemp;
                        }
                        return 0.0;
                    }

                    @Override
                    public double maxEffect() {
                        return this.maxEffect;
                    }

                    @Override
                    public double minEffect() {
                        return this.minEffect;
                    }
                });
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Invalid configuration for BlockTemps", (Throwable)e);
                break;
            }
        }
        event.register(new LavaBlockTemp());
        event.register(new FurnaceBlockTemp());
        event.register(new CampfireBlockTemp());
        event.register(new IceboxBlockTemp());
        event.register(new BoilerBlockTemp());
        event.register(new NetherPortalBlockTemp());
        ColdSweat.LOGGER.debug("Registered BlockTemps in {}ms", (Object)(System.currentTimeMillis() - startMS));
    }

    @SubscribeEvent
    public static void registerTempModifiers(TempModifierRegisterEvent event) {
        long startMS = System.currentTimeMillis();
        String compatPath = "com.momosoftworks.coldsweat.api.temperature.modifier.compat.";
        String sereneSeasons = compatPath + "SereneSeasonsTempModifier";
        String armorUnder = compatPath + "ArmorUnderTempModifier";
        String weatherStorms = compatPath + "StormTempModifier";
        String curios = compatPath + "CuriosTempModifier";
        event.register(new ResourceLocation("cold_sweat", "blocks"), BlockTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "biomes"), BiomeTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "underground"), UndergroundTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "armor"), ArmorInsulationTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "mount"), MountTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "waterskin"), WaterskinTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "soulspring_lamp"), SoulLampTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "water"), WaterTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "air_conditioning"), BlockInsulationTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "food"), FoodTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "freezing"), FreezingTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "on_fire"), FireTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "soul_sprout"), SoulSproutTempModifier::new);
        if (CompatManager.isSereneSeasonsLoaded()) {
            event.registerByClassName(new ResourceLocation("sereneseasons", "season"), sereneSeasons);
        }
        if (CompatManager.isArmorUnderwearLoaded()) {
            event.registerByClassName(new ResourceLocation("armorunder", "lining"), armorUnder);
        }
        if (CompatManager.isWeather2Loaded()) {
            event.registerByClassName(new ResourceLocation("weather2", "storm"), weatherStorms);
        }
        if (CompatManager.isCuriosLoaded()) {
            event.registerByClassName(new ResourceLocation("curios", "curios"), curios);
        }
        ColdSweat.LOGGER.debug("Registered TempModifiers in {}ms", (Object)(System.currentTimeMillis() - startMS));
    }
}

