/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class WorldSettingsConfig {
    private static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> biomeOffsets;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> biomeTemps;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> dimensionOffsets;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> dimensionTemps;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> structureOffsets;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> structureTemps;
    public static final ForgeConfigSpec.ConfigValue<Double> caveInsulation;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<Object>>> blockTemps;
    public static final ForgeConfigSpec.IntValue blockRange;
    public static final ForgeConfigSpec.ConfigValue<Boolean> coldSoulFire;
    public static ForgeConfigSpec.ConfigValue<List<? extends Number>> summerTemps;
    public static ForgeConfigSpec.ConfigValue<List<? extends Number>> autumnTemps;
    public static ForgeConfigSpec.ConfigValue<List<? extends Number>> winterTemps;
    public static ForgeConfigSpec.ConfigValue<List<? extends Number>> springTemps;
    public static final ForgeConfigSpec.ConfigValue<Boolean> smartHearth;
    public static final ForgeConfigSpec.ConfigValue<Double> hearthEffect;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> hearthSpreadWhitelist;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> hearthSpreadBlacklist;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> sleepingOverrideBlocks;
    public static final ForgeConfigSpec.ConfigValue<Boolean> checkSleep;
    public static final WorldSettingsConfig INSTANCE;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/world_settings.toml");
    }

    public static WorldSettingsConfig getInstance() {
        return INSTANCE;
    }

    public void save() {
        SPEC.save();
    }

    public List<? extends List<?>> getBiomeTempOffsets() {
        return (List)biomeOffsets.get();
    }

    public List<? extends List<?>> getBiomeTemperatures() {
        return (List)biomeTemps.get();
    }

    public List<? extends List<?>> getDimensionTempOffsets() {
        return (List)dimensionOffsets.get();
    }

    public List<? extends List<?>> getDimensionTemperatures() {
        return (List)dimensionTemps.get();
    }

    public List<? extends List<?>> getStructureTempOffsets() {
        return (List)structureOffsets.get();
    }

    public List<? extends List<?>> getStructureTemperatures() {
        return (List)structureTemps.get();
    }

    public List<? extends List<Object>> getBlockTemps() {
        return (List)blockTemps.get();
    }

    public int getBlockRange() {
        return (Integer)blockRange.get();
    }

    public double getCaveInsulation() {
        return (Double)caveInsulation.get();
    }

    public double getHearthStrength() {
        return (Double)hearthEffect.get();
    }

    public boolean isSmartHearth() {
        return (Boolean)smartHearth.get();
    }

    public List<String> getHearthSpreadWhitelist() {
        return (List)hearthSpreadWhitelist.get();
    }

    public List<String> getHearthSpreadBlacklist() {
        return (List)hearthSpreadBlacklist.get();
    }

    public Double[] getSummerTemps() {
        return (Double[])((List)summerTemps.get()).stream().map(Number::doubleValue).toArray(Double[]::new);
    }

    public Double[] getAutumnTemps() {
        return (Double[])((List)autumnTemps.get()).stream().map(Number::doubleValue).toArray(Double[]::new);
    }

    public Double[] getWinterTemps() {
        return (Double[])((List)winterTemps.get()).stream().map(Number::doubleValue).toArray(Double[]::new);
    }

    public Double[] getSpringTemps() {
        return (Double[])((List)springTemps.get()).stream().map(Number::doubleValue).toArray(Double[]::new);
    }

    public boolean isSoulFireCold() {
        return (Boolean)coldSoulFire.get();
    }

    public boolean isSleepChecked() {
        return (Boolean)checkSleep.get();
    }

    public synchronized List<? extends String> getSleepOverrideBlocks() {
        return (List)sleepingOverrideBlocks.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBiomeTemperatures(List<? extends List<?>> temps) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = biomeTemps;
        synchronized (configValue) {
            biomeTemps.set(temps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBiomeTempOffsets(List<? extends List<?>> offsets) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = biomeOffsets;
        synchronized (configValue) {
            biomeOffsets.set(offsets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDimensionTemperatures(List<? extends List<?>> temps) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = dimensionTemps;
        synchronized (configValue) {
            dimensionTemps.set(temps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDimensionTempOffsets(List<? extends List<?>> offsets) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = dimensionOffsets;
        synchronized (configValue) {
            dimensionOffsets.set(offsets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setStructureTemperatures(List<? extends List<?>> temps) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = structureTemps;
        synchronized (configValue) {
            structureTemps.set(temps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setStructureTempOffsets(List<? extends List<?>> offsets) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = structureOffsets;
        synchronized (configValue) {
            structureOffsets.set(offsets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBlockTemps(List<? extends List<Object>> temps) {
        ForgeConfigSpec.ConfigValue<List<? extends List<Object>>> configValue = blockTemps;
        synchronized (configValue) {
            blockTemps.set(temps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBlockRange(int range) {
        ForgeConfigSpec.IntValue intValue = blockRange;
        synchronized (intValue) {
            blockRange.set((Object)range);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCaveInsulation(double insulation) {
        ForgeConfigSpec.ConfigValue<Double> configValue = caveInsulation;
        synchronized (configValue) {
            caveInsulation.set((Object)insulation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setHearthSpreadWhitelist(List<ResourceLocation> whitelist) {
        ForgeConfigSpec.ConfigValue<List<? extends String>> configValue = hearthSpreadWhitelist;
        synchronized (configValue) {
            hearthSpreadWhitelist.set(whitelist.stream().map(ResourceLocation::toString).collect(Collectors.toList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setHearthSpreadBlacklist(List<ResourceLocation> blacklist) {
        ForgeConfigSpec.ConfigValue<List<? extends String>> configValue = hearthSpreadBlacklist;
        synchronized (configValue) {
            hearthSpreadBlacklist.set(blacklist.stream().map(ResourceLocation::toString).collect(Collectors.toList()));
        }
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        INSTANCE = new WorldSettingsConfig();
        BUILDER.comment(new String[]{"Format: [[\"dimension_1\", temperature1, *units], [\"dimension_2\", temperature2, *units]... etc]", "Common dimension IDs: minecraft:overworld, minecraft:the_nether, minecraft:the_end"}).push("Dimensions");
        dimensionOffsets = BUILDER.comment("Applies an offset to the world's temperature across an entire dimension").defineList("Dimension Temperature Offsets", List.of(List.of("minecraft:the_nether", Double.valueOf(1.0)), List.of("minecraft:the_end", Double.valueOf(-0.1))), it -> {
            List list;
            return it instanceof List && (list = (List)it).get(0) instanceof String && list.get(1) instanceof Number && (list.size() < 3 || list.get(2) instanceof String);
        });
        dimensionTemps = BUILDER.comment(new String[]{"Overrides existing dimension temperatures & offsets", "Also overrides temperatures of all biomes in the dimension"}).defineList("Dimension Temperatures", List.of(), it -> {
            List list;
            return it instanceof List && (list = (List)it).get(0) instanceof String && list.get(1) instanceof Number && (list.size() < 3 || list.get(2) instanceof String);
        });
        BUILDER.pop();
        BUILDER.comment(new String[]{"Format: [[\"biome_1\", tempLow, tempHigh, *units], [\"biome_2\", tempLow, tempHigh, *units]... etc]", "temp-low: The temperature of the biome at midnight", "temp-high: The temperature of the biome at noon", "units: Optional. The units of the temperature (\"C\" or \"F\". Defaults to MC units)"}).push("Biomes");
        biomeOffsets = BUILDER.comment("Applies an offset to the temperature of a biome").defineList("Biome Temperature Offsets", List.of(), it -> {
            if (it instanceof List) {
                List list = (List)it;
                if (list.size() == 2) {
                    ColdSweat.LOGGER.warn("Falling back to legacy code for config setting {} in \"Biome Temperature Offsets\". Please update to the new standard!", list.get(0));
                }
                return !(!(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || list.size() >= 3 && !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String));
            }
            return false;
        });
        biomeTemps = BUILDER.comment("Defines the temperature of a biome, overriding existing biome temperatures & offsets.").defineList("Biome Temperatures", ListBuilder.begin(new List[]{List.of("minecraft:soul_sand_valley", Integer.valueOf(53), Integer.valueOf(53), "F"), List.of("minecraft:old_growth_birch_forest", Integer.valueOf(58), Integer.valueOf(72), "F"), List.of("minecraft:river", Integer.valueOf(60), Integer.valueOf(70), "F"), List.of("minecraft:swamp", Integer.valueOf(72), Integer.valueOf(84), "F"), List.of("minecraft:savanna", Integer.valueOf(70), Integer.valueOf(95), "F"), List.of("minecraft:savanna_plateau", Integer.valueOf(76), Integer.valueOf(98), "F"), List.of("minecraft:windswept_savanna", Integer.valueOf(67), Integer.valueOf(90), "F"), List.of("minecraft:taiga", Integer.valueOf(44), Integer.valueOf(62), "F"), List.of("minecraft:snowy_taiga", Integer.valueOf(19), Integer.valueOf(48), "F"), List.of("minecraft:old_growth_pine_taiga", Integer.valueOf(48), Integer.valueOf(62), "F"), List.of("minecraft:old_growth_spruce_taiga", Integer.valueOf(48), Integer.valueOf(62), "F"), List.of("minecraft:desert", Integer.valueOf(48), Integer.valueOf(115), "F"), List.of("minecraft:stony_shore", Integer.valueOf(50), Integer.valueOf(64), "F"), List.of("minecraft:snowy_beach", Integer.valueOf(38), Integer.valueOf(52), "F"), List.of("minecraft:snowy_slopes", Integer.valueOf(24), Integer.valueOf(38), "F"), List.of("minecraft:windswept_forest", Integer.valueOf(48), Integer.valueOf(66), "F"), List.of("minecraft:frozen_peaks", Integer.valueOf(15), Integer.valueOf(33), "F"), List.of("minecraft:warm_ocean", Integer.valueOf(67), Integer.valueOf(76), "F"), List.of("minecraft:deep_frozen_ocean", Integer.valueOf(56), Integer.valueOf(65), "F"), List.of("minecraft:jungle", Integer.valueOf(76), Integer.valueOf(87), "F"), List.of("minecraft:bamboo_jungle", Integer.valueOf(76), Integer.valueOf(87), "F"), List.of("minecraft:badlands", Integer.valueOf(84), Integer.valueOf(120), "F"), List.of("minecraft:wooded_badlands", Integer.valueOf(80), Integer.valueOf(108), "F"), List.of("minecraft:eroded_badlands", Integer.valueOf(88), Integer.valueOf(120), "F"), List.of("minecraft:deep_dark", Integer.valueOf(63), Integer.valueOf(63), "F")}).addIf(CompatManager.isBiomesOPlentyLoaded(), () -> List.of("biomesoplenty:bayou", Integer.valueOf(67), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:bog", Integer.valueOf(62), Integer.valueOf(73), "F"), () -> List.of("biomesoplenty:fir_clearing", Integer.valueOf(56), Integer.valueOf(68), "F"), () -> List.of("biomesoplenty:marsh", Integer.valueOf(76), Integer.valueOf(87), "F"), () -> List.of("biomesoplenty:wetland", Integer.valueOf(63), Integer.valueOf(74), "F"), () -> List.of("biomesoplenty:field", Integer.valueOf(64), Integer.valueOf(85), "F"), () -> List.of("biomesoplenty:ominous_woods", Integer.valueOf(65), Integer.valueOf(72), "F"), () -> List.of("biomesoplenty:coniferous_forest", Integer.valueOf(44), Integer.valueOf(58), "F"), () -> List.of("biomesoplenty:seasonal_forest", Integer.valueOf(52), Integer.valueOf(64), "F"), () -> List.of("biomesoplenty:pumpkin_patch", Integer.valueOf(57), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:woodland", Integer.valueOf(67), Integer.valueOf(80), "F"), () -> List.of("biomesoplenty:mediterranean_forest", Integer.valueOf(64), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:dune_beach", Integer.valueOf(67), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:rocky_rainforest", Integer.valueOf(73), Integer.valueOf(86), "F"), () -> List.of("biomesoplenty:old_growth_woodland", Integer.valueOf(65), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:forested_field", Integer.valueOf(64), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:fungal_jungle", Integer.valueOf(73), Integer.valueOf(86), "F"), () -> List.of("biomesoplenty:highland", Integer.valueOf(57), Integer.valueOf(70), "F"), () -> List.of("biomesoplenty:highland_moor", Integer.valueOf(54), Integer.valueOf(68), "F"), () -> List.of("biomesoplenty:grassland", Integer.valueOf(58), Integer.valueOf(82), "F"), () -> List.of("biomesoplenty:clover_patch", Integer.valueOf(56), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:jade_cliffs", Integer.valueOf(57), Integer.valueOf(70), "F"), () -> List.of("biomesoplenty:lush_desert", Integer.valueOf(72), Integer.valueOf(94), "F"), () -> List.of("biomesoplenty:dryland", Integer.valueOf(67), Integer.valueOf(97), "F"), () -> List.of("biomesoplenty:maple_woods", Integer.valueOf(58), Integer.valueOf(68), "F"), () -> List.of("biomesoplenty:mystic_grove", Integer.valueOf(65), Integer.valueOf(72), "F"), () -> List.of("biomesoplenty:orchard", Integer.valueOf(58), Integer.valueOf(78), "F"), () -> List.of("biomesoplenty:prairie", Integer.valueOf(66), Integer.valueOf(82), "F"), () -> List.of("biomesoplenty:origin_valley", Integer.valueOf(65), Integer.valueOf(80), "F"), () -> List.of("biomesoplenty:snowy_coniferous_forest", Integer.valueOf(28), Integer.valueOf(48), "F"), () -> List.of("biomesoplenty:snowy_fir_clearing", Integer.valueOf(32), Integer.valueOf(51), "F"), () -> List.of("biomesoplenty:snowy_maple_woods", Integer.valueOf(32), Integer.valueOf(48), "F"), () -> List.of("biomesoplenty:spider_nest", Integer.valueOf(75), Integer.valueOf(75), "F"), () -> List.of("biomesoplenty:volcanic_plains", Integer.valueOf(82), Integer.valueOf(95), "F"), () -> List.of("biomesoplenty:volcano", Integer.valueOf(94), Integer.valueOf(120), "F"), () -> List.of("biomesoplenty:wooded_wasteland", Integer.valueOf(78), Integer.valueOf(95), "F")).addIf(CompatManager.isBiomesYoullGoLoaded(), () -> List.of("byg:coniferous_forest", Integer.valueOf(52), Integer.valueOf(70), "F"), () -> List.of("byg:autumnal_valley", Integer.valueOf(58), Integer.valueOf(67), "F"), () -> List.of("byg:autumnal_forest", Integer.valueOf(60), Integer.valueOf(75), "F"), () -> List.of("byg:autumnal_taiga", Integer.valueOf(56), Integer.valueOf(68), "F"), () -> List.of("byg:baobab_savanna", Integer.valueOf(70), Integer.valueOf(95), "F"), () -> List.of("byg:dacite_ridges", Integer.valueOf(40), Integer.valueOf(65), "F"), () -> List.of("byg:firecracker_shrubland", Integer.valueOf(72), Integer.valueOf(105), "F"), () -> List.of("byg:frosted_taiga", Integer.valueOf(22), Integer.valueOf(48), "F"), () -> List.of("byg:cypress_swamplands", Integer.valueOf(68), Integer.valueOf(82), "F"), () -> List.of("byg:dead_sea", Integer.valueOf(72), Integer.valueOf(82), "F"), () -> List.of("byg:lush_stacks", Integer.valueOf(66), Integer.valueOf(75), "F"), () -> List.of("byg:fragment_forest", Integer.valueOf(43), Integer.valueOf(64), "F"), () -> List.of("byg:frosted_coniferous_forest", Integer.valueOf(8), Integer.valueOf(31), "F"), () -> List.of("byg:maple_taiga", Integer.valueOf(53), Integer.valueOf(71), "F"), () -> List.of("byg:skyris_vale", Integer.valueOf(42), Integer.valueOf(68), "F"), () -> List.of("byg:twilight_meadow", Integer.valueOf(49), Integer.valueOf(66), "F"), () -> List.of("byg:weeping_witch_forest", Integer.valueOf(56), Integer.valueOf(73), "F"), () -> List.of("byg:subzero_hypogeal", Integer.valueOf(-10), Integer.valueOf(-10), "F"), () -> List.of("byg:zelkova_forest", Integer.valueOf(44), Integer.valueOf(61), "F")).addIf(CompatManager.isAtmosphericLoaded(), () -> List.of("atmospheric:dunes", Integer.valueOf(78), Integer.valueOf(115), "F"), () -> List.of("atmospheric:flourishing_dunes", Integer.valueOf(68), Integer.valueOf(105), "F"), () -> List.of("atmospheric:petrified_dunes", Integer.valueOf(58), Integer.valueOf(120), "F"), () -> List.of("atmospheric:rocky_dunes", Integer.valueOf(55), Integer.valueOf(125), "F"), () -> List.of("atmospheric:rainforest", Integer.valueOf(68), Integer.valueOf(90), "F"), () -> List.of("atmospheric:rainforest_basin", Integer.valueOf(68), Integer.valueOf(90), "F"), () -> List.of("atmospheric:sparse_rainforest", Integer.valueOf(62), Integer.valueOf(83), "F"), () -> List.of("atmospheric:sparse_rainforest_basin", Integer.valueOf(62), Integer.valueOf(83), "F")).addIf(CompatManager.isEnvironmentalLoaded(), (Supplier<List[]>)((Supplier<List>)() -> List.of("environmental:marsh", Integer.valueOf(60), Integer.valueOf(80), "F"))).addIf(CompatManager.isTerralithLoaded(), () -> List.of("terralith:moonlight_valley", Integer.valueOf(57), Integer.valueOf(76), "F"), () -> List.of("terralith:rocky_mountains", Integer.valueOf(45), Integer.valueOf(73), "F"), () -> List.of("terralith:blooming_plateau", Integer.valueOf(49), Integer.valueOf(78), "F"), () -> List.of("terralith:alpine_grove", Integer.valueOf(16), Integer.valueOf(53), "F"), () -> List.of("terralith:yellowstone", Integer.valueOf(47), Integer.valueOf(68), "F"), () -> List.of("terralith:forested_highlands", Integer.valueOf(43), Integer.valueOf(70), "F"), () -> List.of("terralith:temperate_highlands", Integer.valueOf(54), Integer.valueOf(80), "F"), () -> List.of("terralith:amethyst_rainforest", Integer.valueOf(69), Integer.valueOf(84), "F"), () -> List.of("terralith:sandstone_valley", Integer.valueOf(78), Integer.valueOf(114), "F"), () -> List.of("terralith:ancient_sands", Integer.valueOf(83), Integer.valueOf(130), "F"), () -> List.of("terralith:arid_highlands", Integer.valueOf(74), Integer.valueOf(102), "F"), () -> List.of("terralith:volcanic_crater", Integer.valueOf(96), Integer.valueOf(162), "F"), () -> List.of("terralith:volcanic_peaks", Integer.valueOf(76), Integer.valueOf(122), "F"), () -> List.of("terralith:basalt_cliffs", Integer.valueOf(76), Integer.valueOf(122), "F"), () -> List.of("terralith:birch_taiga", Integer.valueOf(40), Integer.valueOf(62), "F"), () -> List.of("terralith:brushland", Integer.valueOf(64), Integer.valueOf(89), "F"), () -> List.of("terralith:bryce_canyon", Integer.valueOf(72), Integer.valueOf(110), "F"), () -> List.of("terralith:caldera", Integer.valueOf(58), Integer.valueOf(71), "F"), () -> List.of("terralith:cloud_forest", Integer.valueOf(38), Integer.valueOf(58), "F"), () -> List.of("terralith:desert_canyon", Integer.valueOf(73), Integer.valueOf(121), "F"), () -> List.of("terralith:desert_spires", Integer.valueOf(60), Integer.valueOf(121), "F"), () -> List.of("terralith:orchid_swamp", Integer.valueOf(62), Integer.valueOf(81), "F"), () -> List.of("terralith:fractured_savanna", Integer.valueOf(65), Integer.valueOf(92), "F"), () -> List.of("terralith:savanna_badlands", Integer.valueOf(68), Integer.valueOf(99), "F"), () -> List.of("terralith:granite_cliffs", Integer.valueOf(65), Integer.valueOf(85), "F"), () -> List.of("terralith:granite_cliffs", Integer.valueOf(65), Integer.valueOf(85), "F"), () -> List.of("terralith:haze_mountain", Integer.valueOf(62), Integer.valueOf(74), "F"), () -> List.of("terralith:highlands", Integer.valueOf(62), Integer.valueOf(74), "F"), () -> List.of("terralith:lavender_valley", Integer.valueOf(59), Integer.valueOf(76), "F"), () -> List.of("terralith:lavender_forest", Integer.valueOf(56), Integer.valueOf(75), "F"), () -> List.of("terralith:red_oasis", Integer.valueOf(58), Integer.valueOf(94), "F"), () -> List.of("terralith:shield", Integer.valueOf(48), Integer.valueOf(68), "F"), () -> List.of("terralith:shield_clearing", Integer.valueOf(28), Integer.valueOf(80), "F"), () -> List.of("terralith:steppe", Integer.valueOf(44), Integer.valueOf(78), "F"), () -> List.of("terralith:warped_mesa", Integer.valueOf(66), Integer.valueOf(84), "F")).addIf(CompatManager.isWythersLoaded(), () -> List.of("wythers:ancient_copper_beech_forest", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:ancient_emerald_beech_forest", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:ancient_golden_beech_forest", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:ancient_moss_forest", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:ancient_mossy_swamp", Integer.valueOf(10), Integer.valueOf(12), "C"), () -> List.of("wythers:ancient_oak_swamp", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:ancient_taiga", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:andesite_crags", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:aspen_crags", Integer.valueOf(18), Integer.valueOf(20), "C"), () -> List.of("wythers:autumnal_birch_forest", Integer.valueOf(15), Integer.valueOf(16), "C"), () -> List.of("wythers:autumnal_crags", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:autumnal_flower_forest", Integer.valueOf(18), Integer.valueOf(20), "C"), () -> List.of("wythers:autumnal_forest", Integer.valueOf(15), Integer.valueOf(16), "C"), () -> List.of("wythers:autumnal_forest_edge", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:autumnal_plains", Integer.valueOf(18), Integer.valueOf(20), "C"), () -> List.of("wythers:autumnal_swamp", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:ayers_rock", Integer.valueOf(32), Integer.valueOf(35), "C"), () -> List.of("wythers:badlands_canyon", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:badlands_desert", Integer.valueOf(35), Integer.valueOf(40), "C"), () -> List.of("wythers:badlands_river", Integer.valueOf(30), Integer.valueOf(34), "C"), () -> List.of("wythers:bamboo_jungle_canyon", Integer.valueOf(12), Integer.valueOf(18), "C"), () -> List.of("wythers:bamboo_jungle_highlands", Integer.valueOf(13), Integer.valueOf(15), "C"), () -> List.of("wythers:bamboo_jungle_swamp", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:bamboo_swamp", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:bayou", Integer.valueOf(14), Integer.valueOf(18), "C"), () -> List.of("wythers:berry_bog", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:billabong", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:birch_swamp", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:birch_taiga", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:black_beach", Integer.valueOf(18), Integer.valueOf(22), "C"), () -> List.of("wythers:black_river", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:boreal_forest_red", Integer.valueOf(20), Integer.valueOf(23), "C"), () -> List.of("wythers:boreal_forest_yellow", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:cactus_desert", Integer.valueOf(30), Integer.valueOf(45), "C"), () -> List.of("wythers:calcite_caverns", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:calcite_coast", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:chaparral", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:coastal_mangroves", Integer.valueOf(15), Integer.valueOf(19), "C"), () -> List.of("wythers:cold_island", Integer.valueOf(-1), Integer.valueOf(3), "C"), () -> List.of("wythers:cold_plains", Integer.valueOf(-5), Integer.valueOf(2), "C"), () -> List.of("wythers:cold_stony_shore", Integer.valueOf(-10), Integer.valueOf(2), "C"), () -> List.of("wythers:cool_forest", Integer.valueOf(5), Integer.valueOf(10), "C"), () -> List.of("wythers:cool_forest_edge", Integer.valueOf(5), Integer.valueOf(10), "C"), () -> List.of("wythers:cool_plains", Integer.valueOf(5), Integer.valueOf(10), "C"), () -> List.of("wythers:cool_stony_canyons", Integer.valueOf(0), Integer.valueOf(1), "C"), () -> List.of("wythers:cool_stony_peaks", Integer.valueOf(-10), Integer.valueOf(0), "C"), () -> List.of("wythers:crimson_tundra", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:danakil_desert", Integer.valueOf(30), Integer.valueOf(40), "C"), () -> List.of("wythers:deep_dark_forest", Integer.valueOf(5), Integer.valueOf(6), "C"), () -> List.of("wythers:deep_desert", Integer.valueOf(30), Integer.valueOf(40), "C"), () -> List.of("wythers:deep_desert_river", Integer.valueOf(25), Integer.valueOf(30), "C"), () -> List.of("wythers:deep_icy_ocean", Integer.valueOf(-20), Integer.valueOf(0), "C"), () -> List.of("wythers:deep_snowy_taiga", Integer.valueOf(-10), Integer.valueOf(0), "C"), () -> List.of("wythers:deep_underground", Integer.valueOf(0), Integer.valueOf(5), "C"), () -> List.of("wythers:deepslate_shore", Integer.valueOf(10), Integer.valueOf(12), "C"), () -> List.of("wythers:desert_beach", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:desert_island", Integer.valueOf(40), Integer.valueOf(45), "C"), () -> List.of("wythers:desert_lakes", Integer.valueOf(30), Integer.valueOf(31), "C"), () -> List.of("wythers:desert_pinnacles", Integer.valueOf(28), Integer.valueOf(30), "C"), () -> List.of("wythers:desert_river", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:dripleaf_swamp", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:dry_savanna", Integer.valueOf(29), Integer.valueOf(35), "C"), () -> List.of("wythers:dry_tropical_forest", Integer.valueOf(20), Integer.valueOf(26), "C"), () -> List.of("wythers:dry_tropical_grassland", Integer.valueOf(28), Integer.valueOf(30), "C"), () -> List.of("wythers:eucalyptus_deanei_forest", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:eucalyptus_jungle", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:eucalyptus_jungle_canyon", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:eucalyptus_salubris_woodland", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:eucalyptus_woodland", Integer.valueOf(22), Integer.valueOf(25), "C"), () -> List.of("wythers:fen", Integer.valueOf(10), Integer.valueOf(15), "C"), () -> List.of("wythers:flooded_jungle", Integer.valueOf(12), Integer.valueOf(18), "C"), () -> List.of("wythers:flooded_rainforest", Integer.valueOf(16), Integer.valueOf(20), "C"), () -> List.of("wythers:flooded_savanna", Integer.valueOf(16), Integer.valueOf(20), "C"), () -> List.of("wythers:flooded_temperate_rainforest", Integer.valueOf(20), Integer.valueOf(22), "C"), () -> List.of("wythers:flowering_pantanal", Integer.valueOf(25), Integer.valueOf(28), "C"), () -> List.of("wythers:forbidden_forest", Integer.valueOf(12), Integer.valueOf(18), "C"), () -> List.of("wythers:forest_edge", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:forested_highlands", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:frigid_island", Integer.valueOf(0), Integer.valueOf(5), "C"), () -> List.of("wythers:frozen_island", Integer.valueOf(-15), Integer.valueOf(0), "C"), () -> List.of("wythers:fungous_dripstone_caves", Integer.valueOf(5), Integer.valueOf(10), "C"), () -> List.of("wythers:giant_sequoia_forest", Integer.valueOf(10), Integer.valueOf(15), "C"), () -> List.of("wythers:glacial_cliffs", Integer.valueOf(1), Integer.valueOf(10), "C"), () -> List.of("wythers:granite_canyon", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:gravelly_beach", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:gravelly_river", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:guelta", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:harvest_fields", Integer.valueOf(20), Integer.valueOf(26), "C"), () -> List.of("wythers:highland_plains", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:highland_tropical_rainforest", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:highlands", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:huangshan_highlands", Integer.valueOf(15), Integer.valueOf(25), "C"), () -> List.of("wythers:humid_tropical_grassland", Integer.valueOf(20), Integer.valueOf(26), "C"), () -> List.of("wythers:ice_cap", Integer.valueOf(0), Integer.valueOf(5), "C"), () -> List.of("wythers:icy_crags", Integer.valueOf(-5), Integer.valueOf(0), "C"), () -> List.of("wythers:icy_ocean", Integer.valueOf(-5), Integer.valueOf(0), "C"), () -> List.of("wythers:icy_river", Integer.valueOf(-5), Integer.valueOf(0), "C"), () -> List.of("wythers:icy_shore", Integer.valueOf(-5), Integer.valueOf(0), "C"), () -> List.of("wythers:icy_volcano", Integer.valueOf(1), Integer.valueOf(2), "C"), () -> List.of("wythers:jacaranda_savanna", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:jade_highlands", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:jungle_canyon", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:jungle_island", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:jungle_river", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:kwongan_heath", Integer.valueOf(30), Integer.valueOf(50), "C"), () -> List.of("wythers:lantern_river", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:lapacho_plains", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:larch_taiga", Integer.valueOf(20), Integer.valueOf(22), "C"), () -> List.of("wythers:lichenous_caves", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:lichenous_dripstone_caves", Integer.valueOf(12), Integer.valueOf(18), "C"), () -> List.of("wythers:lush_dripstone_caves", Integer.valueOf(12), Integer.valueOf(18), "C"), () -> List.of("wythers:lush_fungous_dripstone_caves", Integer.valueOf(10), Integer.valueOf(15), "C"), () -> List.of("wythers:lush_shroom_caves", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:maple_mountains", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:marsh", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:mediterranean_island", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:mediterranean_island_thermal_springs", Integer.valueOf(25), Integer.valueOf(30), "C"), () -> List.of("wythers:mossy_caves", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:mossy_dripstone_caves", Integer.valueOf(12), Integer.valueOf(15), "C"), () -> List.of("wythers:mud_pools", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:mushroom_caves", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:mushroom_island", Integer.valueOf(25), Integer.valueOf(28), "C"), () -> List.of("wythers:old_growth_taiga_crags", Integer.valueOf(18), Integer.valueOf(28), "C"), () -> List.of("wythers:old_growth_taiga_swamp", Integer.valueOf(18), Integer.valueOf(22), "C"), () -> List.of("wythers:outback", Integer.valueOf(30), Integer.valueOf(38), "C"), () -> List.of("wythers:outback_desert", Integer.valueOf(40), Integer.valueOf(45), "C"), () -> List.of("wythers:pantanal", Integer.valueOf(12), Integer.valueOf(18), "C"), () -> List.of("wythers:phantasmal_forest", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:phantasmal_swamp", Integer.valueOf(15), Integer.valueOf(16), "C"), () -> List.of("wythers:pine_barrens", Integer.valueOf(20), Integer.valueOf(26), "C"), () -> List.of("wythers:red_desert", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:red_rock_canyon", Integer.valueOf(30), Integer.valueOf(32), "C"), () -> List.of("wythers:sakura_forest", Integer.valueOf(26), Integer.valueOf(32), "C"), () -> List.of("wythers:salt_lakes_pink", Integer.valueOf(16), Integer.valueOf(28), "C"), () -> List.of("wythers:salt_lakes_turquoise", Integer.valueOf(16), Integer.valueOf(20), "C"), () -> List.of("wythers:salt_lakes_white", Integer.valueOf(16), Integer.valueOf(29), "C"), () -> List.of("wythers:sand_dunes", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:sandy_jungle", Integer.valueOf(30), Integer.valueOf(38), "C"), () -> List.of("wythers:savanna_badlands", Integer.valueOf(35), Integer.valueOf(39), "C"), () -> List.of("wythers:savanna_basaltic_incursions", Integer.valueOf(35), Integer.valueOf(40), "C"), () -> List.of("wythers:savanna_river", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:scrub_forest", Integer.valueOf(20), Integer.valueOf(28), "C"), () -> List.of("wythers:scrubland", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:snowy_bog", Integer.valueOf(0), Integer.valueOf(5), "C"), () -> List.of("wythers:snowy_canyon", Integer.valueOf(-5), Integer.valueOf(0), "C"), () -> List.of("wythers:snowy_fen", Integer.valueOf(-10), Integer.valueOf(0), "C"), () -> List.of("wythers:snowy_peaks", Integer.valueOf(-20), Integer.valueOf(0), "C"), () -> List.of("wythers:snowy_thermal_taiga", Integer.valueOf(0), Integer.valueOf(5), "C"), () -> List.of("wythers:snowy_tundra", Integer.valueOf(0), Integer.valueOf(2), "C"), () -> List.of("wythers:sparse_bamboo_jungle", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:sparse_eucalyptus_jungle", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:sparse_eucalyptus_woodland", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:spring_flower_fields", Integer.valueOf(20), Integer.valueOf(28), "C"), () -> List.of("wythers:spring_flower_forest", Integer.valueOf(20), Integer.valueOf(28), "C"), () -> List.of("wythers:stony_canyon", Integer.valueOf(10), Integer.valueOf(15), "C"), () -> List.of("wythers:subtropical_forest", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:subtropical_forest_edge", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:subtropical_grassland", Integer.valueOf(15), Integer.valueOf(20), "C"), () -> List.of("wythers:taiga_crags", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:tangled_forest", Integer.valueOf(12), Integer.valueOf(16), "C"), () -> List.of("wythers:temperate_island", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:temperate_rainforest", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:temperate_rainforest_crags", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:tepui", Integer.valueOf(10), Integer.valueOf(15), "C"), () -> List.of("wythers:thermal_taiga", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:thermal_taiga_crags", Integer.valueOf(20), Integer.valueOf(25), "C"), () -> List.of("wythers:tibesti_mountains", Integer.valueOf(30), Integer.valueOf(35), "C"), () -> List.of("wythers:tropical_beach", Integer.valueOf(35), Integer.valueOf(38), "C"), () -> List.of("wythers:tropical_forest", Integer.valueOf(22), Integer.valueOf(30), "C"), () -> List.of("wythers:tropical_forest_canyon", Integer.valueOf(25), Integer.valueOf(30), "C"), () -> List.of("wythers:tropical_forest_river", Integer.valueOf(22), Integer.valueOf(30), "C"), () -> List.of("wythers:tropical_grassland", Integer.valueOf(20), Integer.valueOf(30), "C"), () -> List.of("wythers:tropical_island", Integer.valueOf(24), Integer.valueOf(34), "C"), () -> List.of("wythers:tropical_rainforest", Integer.valueOf(25), Integer.valueOf(32), "C"), () -> List.of("wythers:tropical_volcano", Integer.valueOf(40), Integer.valueOf(50), "C"), () -> List.of("wythers:tsingy_forest", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:tundra", Integer.valueOf(10), Integer.valueOf(15), "C"), () -> List.of("wythers:underground", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:volcanic_chamber", Integer.valueOf(35), Integer.valueOf(45), "C"), () -> List.of("wythers:volcanic_crater", Integer.valueOf(35), Integer.valueOf(45), "C"), () -> List.of("wythers:volcano", Integer.valueOf(40), Integer.valueOf(50), "C"), () -> List.of("wythers:warm_birch_forest", Integer.valueOf(30), Integer.valueOf(37), "C"), () -> List.of("wythers:warm_stony_shore", Integer.valueOf(30), Integer.valueOf(37), "C"), () -> List.of("wythers:waterlily_swamp", Integer.valueOf(15), Integer.valueOf(18), "C"), () -> List.of("wythers:windswept_jungle", Integer.valueOf(18), Integer.valueOf(22), "C"), () -> List.of("wythers:wistman_woods", Integer.valueOf(18), Integer.valueOf(20), "C"), () -> List.of("wythers:wooded_desert", Integer.valueOf(22), Integer.valueOf(25), "C"), () -> List.of("wythers:wooded_savanna", Integer.valueOf(22), Integer.valueOf(26), "C")).build(), it -> {
            if (it instanceof List) {
                List list = (List)it;
                if (list.size() == 2) {
                    ColdSweat.LOGGER.warn("Falling back to legacy code for config setting {} in \"Biome Temperatures\". Please update to the new standard!", list.get(0));
                }
                return !(!(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || list.size() >= 3 && !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String));
            }
            return false;
        });
        BUILDER.pop();
        BUILDER.push("Blocks");
        blockTemps = BUILDER.comment(new String[]{"Allows for adding simple BlockTemps without the use of Java mods", "Format (All temperatures are in Minecraft units):", "[[\"block-ids\", <temperature>, <range (max 7)>, <*true/false: falloff>, <*max effect>, <*predicates>], [etc...], [etc...]]", "(* = optional) (1 \u00b0MC = 42 \u00b0F/ 23.33 \u00b0C)", "", "Arguments:", "block-ids: multiple IDs can be used by separating them with commas (i.e: \"minecraft:torch,minecraft:wall_torch\")", "temperature: the temperature of the block, in Minecraft units", "falloff: the block is less effective as distance increases", "max effect: the maximum temperature change this block can cause to a player (even with multiple blocks)", "predicates: the state that the block has to be in for the temperature to be applied (lit=true for a campfire, for example).", "Multiple predicates can be used by separating them with commas (i.e: \"lit=true,waterlogged=false\")"}).defineList("Block Temperatures", Arrays.asList(Arrays.asList("minecraft:soul_fire", -0.476, 7, true, 0.8), Arrays.asList("minecraft:fire", 0.476, 7, true, 0.8), Arrays.asList("minecraft:magma_block", 0.25, 3, true, 1), Arrays.asList("minecraft:soul_campfire", -0.476, 7, true, 0.6, "lit=true"), Arrays.asList("minecraft:ice", -0.15, 4, true, 0.5), Arrays.asList("minecraft:packed_ice", -0.25, 4, true, 1.0), Arrays.asList("minecraft:blue_ice", -0.35, 4, true, 1.0), Arrays.asList("minecraft:lava_cauldron", 0.5, 7, true, 1.5)), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() >= 3 && list.get(0) instanceof String && list.get(1) instanceof Number && list.get(2) instanceof Number;
        });
        blockRange = BUILDER.comment(new String[]{"The maximum range of blocks' area of effect", "Note: This will not change anything unless blocks are configured to utilize the expanded range", "This value is capped at 16 for performance reasons"}).defineInRange("Block Range", 7, 1, 16);
        BUILDER.pop();
        BUILDER.push("Misc");
        caveInsulation = BUILDER.comment(new String[]{"The amount of temperature normalization from being deep underground", "0.0 = no insulation, 1.0 = full insulation"}).defineInRange("Cave Insulation Strength", 1.0, 0.0, 1.0);
        structureTemps = BUILDER.comment(new String[]{"Overrides the world temperature when the player is within this structure", "Format: [[\"structure_1\", temperature1, *units], [\"structure_2\", temperature2, *units]... etc]", "(* = optional)"}).defineList("Structure Temperatures", List.of(List.of("minecraft:igloo", Integer.valueOf(65), "F")), it -> {
            List list;
            return it instanceof List && (list = (List)it).get(0) instanceof String && list.get(1) instanceof Number && (list.size() < 3 || list.get(2) instanceof String);
        });
        structureOffsets = BUILDER.comment(new String[]{"Offsets the world temperature when the player is within this structure", "Format: [[\"structure_1\", offset1, *units], [\"structure_2\", offset2, *units]... etc]", "(* = optional)"}).defineList("Structure Temperature Offsets", List.of(), it -> {
            List list;
            return it instanceof List && (list = (List)it).get(0) instanceof String && list.get(1) instanceof Number && (list.size() < 3 || list.get(2) instanceof String);
        });
        sleepingOverrideBlocks = BUILDER.comment(new String[]{"List of blocks that will allow the player to sleep on them, regardless of the \"Prevent Sleep When in Danger\" setting", "Use this list if the player is not getting the temperature effect from sleeping on particular blocks"}).defineList("Sleep Check Override Blocks", ListBuilder.begin(new String[0]).addIf(CompatManager.modLoaded("comforts"), (Supplier<String[]>)((Supplier<String>)() -> "#comforts:sleeping_bags")).build(), it -> it instanceof String);
        checkSleep = BUILDER.comment("When set to true, players cannot sleep if they are cold or hot enough to die").define("Check Sleeping Conditions", true);
        coldSoulFire = BUILDER.comment(new String[]{"Converts damage dealt by Soul Fire to cold damage (default: true)", "Does not affect the block's temperature"}).define("Cold Soul Fire", true);
        BUILDER.pop();
        BUILDER.push("Hearth");
        smartHearth = BUILDER.comment(new String[]{"Allows the hearth to automatically turn on/off based on nearby players' temperature", "If false, the hearth turns on/off by redstone signal"}).define("Automatic Hearth", false);
        hearthEffect = BUILDER.comment("How effective the hearth is at normalizing temperature").defineInRange("Hearth Strength", 0.75, 0.0, 1.0);
        hearthSpreadWhitelist = BUILDER.comment(new String[]{"List of additional blocks that the hearth can spread through", "Use this list if the hearth isn't spreading through particular blocks that it should"}).defineListAllowEmpty(List.of("Hearth Spread Whitelist"), () -> ListBuilder.begin(new String[]{"minecraft:iron_bars", "#minecraft:leaves"}).addIf(CompatManager.isCreateLoaded(), (Supplier<String[]>)((Supplier<String>)() -> "create:encased_fluid_pipe")).build(), o -> o instanceof String);
        hearthSpreadBlacklist = BUILDER.comment(new String[]{"List of additional blocks that the hearth cannot spread through", "Use this list if the hearth is spreading through particular blocks that it shouldn't"}).defineList("Hearth Spread Blacklist", List.of(), o -> o instanceof String);
        BUILDER.pop();
        if (CompatManager.isSereneSeasonsLoaded()) {
            BUILDER.comment(new String[]{"Format: [season-start, season-mid, season-end]", "Applied as an offset to the world's temperature"}).push("Season Temperatures");
            summerTemps = BUILDER.defineList("Summer", Arrays.asList(0.4, 0.6, 0.4), it -> it instanceof Number);
            autumnTemps = BUILDER.defineList("Autumn", Arrays.asList(0.2, 0, -0.2), it -> it instanceof Number);
            winterTemps = BUILDER.defineList("Winter", Arrays.asList(-0.4, -0.6, -0.4), it -> it instanceof Number);
            springTemps = BUILDER.defineList("Spring", Arrays.asList(-0.2, 0, 0.2), it -> it instanceof Number);
            BUILDER.pop();
        }
        SPEC = BUILDER.build();
    }
}

